/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudbridge.model.Tag;
import com.oracle.bmc.cloudbridge.model.VolumeAttachment;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AwsEbsProperties
extends ExplicitlySetBmcModel {
    @JsonProperty(value="attachments")
    private final List<VolumeAttachment> attachments;
    @JsonProperty(value="availabilityZone")
    private final String availabilityZone;
    @JsonProperty(value="isEncrypted")
    private final Boolean isEncrypted;
    @JsonProperty(value="iops")
    private final Integer iops;
    @JsonProperty(value="isMultiAttachEnabled")
    private final Boolean isMultiAttachEnabled;
    @JsonProperty(value="sizeInGiBs")
    private final Integer sizeInGiBs;
    @JsonProperty(value="status")
    private final String status;
    @JsonProperty(value="tags")
    private final List<Tag> tags;
    @JsonProperty(value="throughput")
    private final Integer throughput;
    @JsonProperty(value="volumeKey")
    private final String volumeKey;
    @JsonProperty(value="volumeType")
    private final String volumeType;

    @Deprecated
    @ConstructorProperties(value={"attachments", "availabilityZone", "isEncrypted", "iops", "isMultiAttachEnabled", "sizeInGiBs", "status", "tags", "throughput", "volumeKey", "volumeType"})
    public AwsEbsProperties(List<VolumeAttachment> attachments, String availabilityZone, Boolean isEncrypted, Integer iops, Boolean isMultiAttachEnabled, Integer sizeInGiBs, String status, List<Tag> tags, Integer throughput, String volumeKey, String volumeType) {
        this.attachments = attachments;
        this.availabilityZone = availabilityZone;
        this.isEncrypted = isEncrypted;
        this.iops = iops;
        this.isMultiAttachEnabled = isMultiAttachEnabled;
        this.sizeInGiBs = sizeInGiBs;
        this.status = status;
        this.tags = tags;
        this.throughput = throughput;
        this.volumeKey = volumeKey;
        this.volumeType = volumeType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<VolumeAttachment> getAttachments() {
        return this.attachments;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public Boolean getIsEncrypted() {
        return this.isEncrypted;
    }

    public Integer getIops() {
        return this.iops;
    }

    public Boolean getIsMultiAttachEnabled() {
        return this.isMultiAttachEnabled;
    }

    public Integer getSizeInGiBs() {
        return this.sizeInGiBs;
    }

    public String getStatus() {
        return this.status;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public Integer getThroughput() {
        return this.throughput;
    }

    public String getVolumeKey() {
        return this.volumeKey;
    }

    public String getVolumeType() {
        return this.volumeType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AwsEbsProperties(");
        sb.append("super=").append(super.toString());
        sb.append("attachments=").append(String.valueOf(this.attachments));
        sb.append(", availabilityZone=").append(String.valueOf(this.availabilityZone));
        sb.append(", isEncrypted=").append(String.valueOf(this.isEncrypted));
        sb.append(", iops=").append(String.valueOf(this.iops));
        sb.append(", isMultiAttachEnabled=").append(String.valueOf(this.isMultiAttachEnabled));
        sb.append(", sizeInGiBs=").append(String.valueOf(this.sizeInGiBs));
        sb.append(", status=").append(String.valueOf(this.status));
        sb.append(", tags=").append(String.valueOf(this.tags));
        sb.append(", throughput=").append(String.valueOf(this.throughput));
        sb.append(", volumeKey=").append(String.valueOf(this.volumeKey));
        sb.append(", volumeType=").append(String.valueOf(this.volumeType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AwsEbsProperties)) {
            return false;
        }
        AwsEbsProperties other = (AwsEbsProperties)((Object)o);
        return Objects.equals(this.attachments, other.attachments) && Objects.equals(this.availabilityZone, other.availabilityZone) && Objects.equals(this.isEncrypted, other.isEncrypted) && Objects.equals(this.iops, other.iops) && Objects.equals(this.isMultiAttachEnabled, other.isMultiAttachEnabled) && Objects.equals(this.sizeInGiBs, other.sizeInGiBs) && Objects.equals(this.status, other.status) && Objects.equals(this.tags, other.tags) && Objects.equals(this.throughput, other.throughput) && Objects.equals(this.volumeKey, other.volumeKey) && Objects.equals(this.volumeType, other.volumeType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.attachments == null ? 43 : this.attachments.hashCode());
        result = result * 59 + (this.availabilityZone == null ? 43 : this.availabilityZone.hashCode());
        result = result * 59 + (this.isEncrypted == null ? 43 : this.isEncrypted.hashCode());
        result = result * 59 + (this.iops == null ? 43 : this.iops.hashCode());
        result = result * 59 + (this.isMultiAttachEnabled == null ? 43 : this.isMultiAttachEnabled.hashCode());
        result = result * 59 + (this.sizeInGiBs == null ? 43 : this.sizeInGiBs.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.tags == null ? 43 : this.tags.hashCode());
        result = result * 59 + (this.throughput == null ? 43 : this.throughput.hashCode());
        result = result * 59 + (this.volumeKey == null ? 43 : this.volumeKey.hashCode());
        result = result * 59 + (this.volumeType == null ? 43 : this.volumeType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="attachments")
        private List<VolumeAttachment> attachments;
        @JsonProperty(value="availabilityZone")
        private String availabilityZone;
        @JsonProperty(value="isEncrypted")
        private Boolean isEncrypted;
        @JsonProperty(value="iops")
        private Integer iops;
        @JsonProperty(value="isMultiAttachEnabled")
        private Boolean isMultiAttachEnabled;
        @JsonProperty(value="sizeInGiBs")
        private Integer sizeInGiBs;
        @JsonProperty(value="status")
        private String status;
        @JsonProperty(value="tags")
        private List<Tag> tags;
        @JsonProperty(value="throughput")
        private Integer throughput;
        @JsonProperty(value="volumeKey")
        private String volumeKey;
        @JsonProperty(value="volumeType")
        private String volumeType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder attachments(List<VolumeAttachment> attachments) {
            this.attachments = attachments;
            this.__explicitlySet__.add("attachments");
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            this.__explicitlySet__.add("availabilityZone");
            return this;
        }

        public Builder isEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
            this.__explicitlySet__.add("isEncrypted");
            return this;
        }

        public Builder iops(Integer iops) {
            this.iops = iops;
            this.__explicitlySet__.add("iops");
            return this;
        }

        public Builder isMultiAttachEnabled(Boolean isMultiAttachEnabled) {
            this.isMultiAttachEnabled = isMultiAttachEnabled;
            this.__explicitlySet__.add("isMultiAttachEnabled");
            return this;
        }

        public Builder sizeInGiBs(Integer sizeInGiBs) {
            this.sizeInGiBs = sizeInGiBs;
            this.__explicitlySet__.add("sizeInGiBs");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder tags(List<Tag> tags) {
            this.tags = tags;
            this.__explicitlySet__.add("tags");
            return this;
        }

        public Builder throughput(Integer throughput) {
            this.throughput = throughput;
            this.__explicitlySet__.add("throughput");
            return this;
        }

        public Builder volumeKey(String volumeKey) {
            this.volumeKey = volumeKey;
            this.__explicitlySet__.add("volumeKey");
            return this;
        }

        public Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            this.__explicitlySet__.add("volumeType");
            return this;
        }

        public AwsEbsProperties build() {
            AwsEbsProperties model = new AwsEbsProperties(this.attachments, this.availabilityZone, this.isEncrypted, this.iops, this.isMultiAttachEnabled, this.sizeInGiBs, this.status, this.tags, this.throughput, this.volumeKey, this.volumeType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AwsEbsProperties model) {
            if (model.wasPropertyExplicitlySet("attachments")) {
                this.attachments(model.getAttachments());
            }
            if (model.wasPropertyExplicitlySet("availabilityZone")) {
                this.availabilityZone(model.getAvailabilityZone());
            }
            if (model.wasPropertyExplicitlySet("isEncrypted")) {
                this.isEncrypted(model.getIsEncrypted());
            }
            if (model.wasPropertyExplicitlySet("iops")) {
                this.iops(model.getIops());
            }
            if (model.wasPropertyExplicitlySet("isMultiAttachEnabled")) {
                this.isMultiAttachEnabled(model.getIsMultiAttachEnabled());
            }
            if (model.wasPropertyExplicitlySet("sizeInGiBs")) {
                this.sizeInGiBs(model.getSizeInGiBs());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("tags")) {
                this.tags(model.getTags());
            }
            if (model.wasPropertyExplicitlySet("throughput")) {
                this.throughput(model.getThroughput());
            }
            if (model.wasPropertyExplicitlySet("volumeKey")) {
                this.volumeKey(model.getVolumeKey());
            }
            if (model.wasPropertyExplicitlySet("volumeType")) {
                this.volumeType(model.getVolumeType());
            }
            return this;
        }
    }
}

