/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudbridge.model.Asset;
import com.oracle.bmc.cloudbridge.model.AwsEc2Properties;
import com.oracle.bmc.cloudbridge.model.ComputeProperties;
import com.oracle.bmc.cloudbridge.model.MonthlyCostSummary;
import com.oracle.bmc.cloudbridge.model.VmProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="assetType")
@JsonFilter(value="explicitlySetFilter")
public final class AwsEc2Asset
extends Asset {
    @JsonProperty(value="compute")
    private final ComputeProperties compute;
    @JsonProperty(value="vm")
    private final VmProperties vm;
    @JsonProperty(value="awsEc2")
    private final AwsEc2Properties awsEc2;
    @JsonProperty(value="awsEc2Cost")
    private final MonthlyCostSummary awsEc2Cost;
    @JsonProperty(value="attachedEbsVolumesCost")
    private final MonthlyCostSummary attachedEbsVolumesCost;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public AwsEc2Asset(String displayName, String inventoryId, String id, String compartmentId, String sourceKey, String externalAssetKey, Date timeCreated, Date timeUpdated, List<String> assetSourceIds, Asset.LifecycleState lifecycleState, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, ComputeProperties compute, VmProperties vm, AwsEc2Properties awsEc2, MonthlyCostSummary awsEc2Cost, MonthlyCostSummary attachedEbsVolumesCost) {
        super(displayName, inventoryId, id, compartmentId, sourceKey, externalAssetKey, timeCreated, timeUpdated, assetSourceIds, lifecycleState, freeformTags, definedTags, systemTags);
        this.compute = compute;
        this.vm = vm;
        this.awsEc2 = awsEc2;
        this.awsEc2Cost = awsEc2Cost;
        this.attachedEbsVolumesCost = attachedEbsVolumesCost;
    }

    public ComputeProperties getCompute() {
        return this.compute;
    }

    public VmProperties getVm() {
        return this.vm;
    }

    public AwsEc2Properties getAwsEc2() {
        return this.awsEc2;
    }

    public MonthlyCostSummary getAwsEc2Cost() {
        return this.awsEc2Cost;
    }

    public MonthlyCostSummary getAttachedEbsVolumesCost() {
        return this.attachedEbsVolumesCost;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AwsEc2Asset(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", compute=").append(String.valueOf((Object)this.compute));
        sb.append(", vm=").append(String.valueOf((Object)this.vm));
        sb.append(", awsEc2=").append(String.valueOf((Object)this.awsEc2));
        sb.append(", awsEc2Cost=").append(String.valueOf((Object)this.awsEc2Cost));
        sb.append(", attachedEbsVolumesCost=").append(String.valueOf((Object)this.attachedEbsVolumesCost));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AwsEc2Asset)) {
            return false;
        }
        AwsEc2Asset other = (AwsEc2Asset)((Object)o);
        return Objects.equals((Object)this.compute, (Object)other.compute) && Objects.equals((Object)this.vm, (Object)other.vm) && Objects.equals((Object)this.awsEc2, (Object)other.awsEc2) && Objects.equals((Object)this.awsEc2Cost, (Object)other.awsEc2Cost) && Objects.equals((Object)this.attachedEbsVolumesCost, (Object)other.attachedEbsVolumesCost) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compute == null ? 43 : this.compute.hashCode());
        result = result * 59 + (this.vm == null ? 43 : this.vm.hashCode());
        result = result * 59 + (this.awsEc2 == null ? 43 : this.awsEc2.hashCode());
        result = result * 59 + (this.awsEc2Cost == null ? 43 : this.awsEc2Cost.hashCode());
        result = result * 59 + (this.attachedEbsVolumesCost == null ? 43 : this.attachedEbsVolumesCost.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="inventoryId")
        private String inventoryId;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="sourceKey")
        private String sourceKey;
        @JsonProperty(value="externalAssetKey")
        private String externalAssetKey;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="assetSourceIds")
        private List<String> assetSourceIds;
        @JsonProperty(value="lifecycleState")
        private Asset.LifecycleState lifecycleState;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="compute")
        private ComputeProperties compute;
        @JsonProperty(value="vm")
        private VmProperties vm;
        @JsonProperty(value="awsEc2")
        private AwsEc2Properties awsEc2;
        @JsonProperty(value="awsEc2Cost")
        private MonthlyCostSummary awsEc2Cost;
        @JsonProperty(value="attachedEbsVolumesCost")
        private MonthlyCostSummary attachedEbsVolumesCost;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder inventoryId(String inventoryId) {
            this.inventoryId = inventoryId;
            this.__explicitlySet__.add("inventoryId");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder sourceKey(String sourceKey) {
            this.sourceKey = sourceKey;
            this.__explicitlySet__.add("sourceKey");
            return this;
        }

        public Builder externalAssetKey(String externalAssetKey) {
            this.externalAssetKey = externalAssetKey;
            this.__explicitlySet__.add("externalAssetKey");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder assetSourceIds(List<String> assetSourceIds) {
            this.assetSourceIds = assetSourceIds;
            this.__explicitlySet__.add("assetSourceIds");
            return this;
        }

        public Builder lifecycleState(Asset.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder compute(ComputeProperties compute) {
            this.compute = compute;
            this.__explicitlySet__.add("compute");
            return this;
        }

        public Builder vm(VmProperties vm) {
            this.vm = vm;
            this.__explicitlySet__.add("vm");
            return this;
        }

        public Builder awsEc2(AwsEc2Properties awsEc2) {
            this.awsEc2 = awsEc2;
            this.__explicitlySet__.add("awsEc2");
            return this;
        }

        public Builder awsEc2Cost(MonthlyCostSummary awsEc2Cost) {
            this.awsEc2Cost = awsEc2Cost;
            this.__explicitlySet__.add("awsEc2Cost");
            return this;
        }

        public Builder attachedEbsVolumesCost(MonthlyCostSummary attachedEbsVolumesCost) {
            this.attachedEbsVolumesCost = attachedEbsVolumesCost;
            this.__explicitlySet__.add("attachedEbsVolumesCost");
            return this;
        }

        public AwsEc2Asset build() {
            AwsEc2Asset model = new AwsEc2Asset(this.displayName, this.inventoryId, this.id, this.compartmentId, this.sourceKey, this.externalAssetKey, this.timeCreated, this.timeUpdated, this.assetSourceIds, this.lifecycleState, this.freeformTags, this.definedTags, this.systemTags, this.compute, this.vm, this.awsEc2, this.awsEc2Cost, this.attachedEbsVolumesCost);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AwsEc2Asset model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("inventoryId")) {
                this.inventoryId(model.getInventoryId());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("sourceKey")) {
                this.sourceKey(model.getSourceKey());
            }
            if (model.wasPropertyExplicitlySet("externalAssetKey")) {
                this.externalAssetKey(model.getExternalAssetKey());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("assetSourceIds")) {
                this.assetSourceIds(model.getAssetSourceIds());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("compute")) {
                this.compute(model.getCompute());
            }
            if (model.wasPropertyExplicitlySet("vm")) {
                this.vm(model.getVm());
            }
            if (model.wasPropertyExplicitlySet("awsEc2")) {
                this.awsEc2(model.getAwsEc2());
            }
            if (model.wasPropertyExplicitlySet("awsEc2Cost")) {
                this.awsEc2Cost(model.getAwsEc2Cost());
            }
            if (model.wasPropertyExplicitlySet("attachedEbsVolumesCost")) {
                this.attachedEbsVolumesCost(model.getAttachedEbsVolumesCost());
            }
            return this;
        }
    }
}

