/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudbridge.model.GroupIdentifier;
import com.oracle.bmc.cloudbridge.model.InstanceNetworkInterfaceAssociation;
import com.oracle.bmc.cloudbridge.model.InstanceNetworkInterfaceAttachment;
import com.oracle.bmc.cloudbridge.model.InstancePrivateIpAddress;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InstanceNetworkInterface
extends ExplicitlySetBmcModel {
    @JsonProperty(value="association")
    private final InstanceNetworkInterfaceAssociation association;
    @JsonProperty(value="attachment")
    private final InstanceNetworkInterfaceAttachment attachment;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="securityGroups")
    private final List<GroupIdentifier> securityGroups;
    @JsonProperty(value="interfaceType")
    private final String interfaceType;
    @JsonProperty(value="ipv4Prefixes")
    private final List<String> ipv4Prefixes;
    @JsonProperty(value="ipv6Addresses")
    private final List<String> ipv6Addresses;
    @JsonProperty(value="ipv6Prefixes")
    private final List<String> ipv6Prefixes;
    @JsonProperty(value="macAddress")
    private final String macAddress;
    @JsonProperty(value="networkInterfaceKey")
    private final String networkInterfaceKey;
    @JsonProperty(value="ownerKey")
    private final String ownerKey;
    @JsonProperty(value="privateIpAddresses")
    private final List<InstancePrivateIpAddress> privateIpAddresses;
    @JsonProperty(value="isSourceDestCheck")
    private final Boolean isSourceDestCheck;
    @JsonProperty(value="status")
    private final String status;
    @JsonProperty(value="subnetKey")
    private final String subnetKey;

    @Deprecated
    @ConstructorProperties(value={"association", "attachment", "description", "securityGroups", "interfaceType", "ipv4Prefixes", "ipv6Addresses", "ipv6Prefixes", "macAddress", "networkInterfaceKey", "ownerKey", "privateIpAddresses", "isSourceDestCheck", "status", "subnetKey"})
    public InstanceNetworkInterface(InstanceNetworkInterfaceAssociation association, InstanceNetworkInterfaceAttachment attachment, String description, List<GroupIdentifier> securityGroups, String interfaceType, List<String> ipv4Prefixes, List<String> ipv6Addresses, List<String> ipv6Prefixes, String macAddress, String networkInterfaceKey, String ownerKey, List<InstancePrivateIpAddress> privateIpAddresses, Boolean isSourceDestCheck, String status, String subnetKey) {
        this.association = association;
        this.attachment = attachment;
        this.description = description;
        this.securityGroups = securityGroups;
        this.interfaceType = interfaceType;
        this.ipv4Prefixes = ipv4Prefixes;
        this.ipv6Addresses = ipv6Addresses;
        this.ipv6Prefixes = ipv6Prefixes;
        this.macAddress = macAddress;
        this.networkInterfaceKey = networkInterfaceKey;
        this.ownerKey = ownerKey;
        this.privateIpAddresses = privateIpAddresses;
        this.isSourceDestCheck = isSourceDestCheck;
        this.status = status;
        this.subnetKey = subnetKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public InstanceNetworkInterfaceAssociation getAssociation() {
        return this.association;
    }

    public InstanceNetworkInterfaceAttachment getAttachment() {
        return this.attachment;
    }

    public String getDescription() {
        return this.description;
    }

    public List<GroupIdentifier> getSecurityGroups() {
        return this.securityGroups;
    }

    public String getInterfaceType() {
        return this.interfaceType;
    }

    public List<String> getIpv4Prefixes() {
        return this.ipv4Prefixes;
    }

    public List<String> getIpv6Addresses() {
        return this.ipv6Addresses;
    }

    public List<String> getIpv6Prefixes() {
        return this.ipv6Prefixes;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public String getNetworkInterfaceKey() {
        return this.networkInterfaceKey;
    }

    public String getOwnerKey() {
        return this.ownerKey;
    }

    public List<InstancePrivateIpAddress> getPrivateIpAddresses() {
        return this.privateIpAddresses;
    }

    public Boolean getIsSourceDestCheck() {
        return this.isSourceDestCheck;
    }

    public String getStatus() {
        return this.status;
    }

    public String getSubnetKey() {
        return this.subnetKey;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InstanceNetworkInterface(");
        sb.append("super=").append(super.toString());
        sb.append("association=").append(String.valueOf((Object)this.association));
        sb.append(", attachment=").append(String.valueOf((Object)this.attachment));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", securityGroups=").append(String.valueOf(this.securityGroups));
        sb.append(", interfaceType=").append(String.valueOf(this.interfaceType));
        sb.append(", ipv4Prefixes=").append(String.valueOf(this.ipv4Prefixes));
        sb.append(", ipv6Addresses=").append(String.valueOf(this.ipv6Addresses));
        sb.append(", ipv6Prefixes=").append(String.valueOf(this.ipv6Prefixes));
        sb.append(", macAddress=").append(String.valueOf(this.macAddress));
        sb.append(", networkInterfaceKey=").append(String.valueOf(this.networkInterfaceKey));
        sb.append(", ownerKey=").append(String.valueOf(this.ownerKey));
        sb.append(", privateIpAddresses=").append(String.valueOf(this.privateIpAddresses));
        sb.append(", isSourceDestCheck=").append(String.valueOf(this.isSourceDestCheck));
        sb.append(", status=").append(String.valueOf(this.status));
        sb.append(", subnetKey=").append(String.valueOf(this.subnetKey));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstanceNetworkInterface)) {
            return false;
        }
        InstanceNetworkInterface other = (InstanceNetworkInterface)((Object)o);
        return Objects.equals((Object)this.association, (Object)other.association) && Objects.equals((Object)this.attachment, (Object)other.attachment) && Objects.equals(this.description, other.description) && Objects.equals(this.securityGroups, other.securityGroups) && Objects.equals(this.interfaceType, other.interfaceType) && Objects.equals(this.ipv4Prefixes, other.ipv4Prefixes) && Objects.equals(this.ipv6Addresses, other.ipv6Addresses) && Objects.equals(this.ipv6Prefixes, other.ipv6Prefixes) && Objects.equals(this.macAddress, other.macAddress) && Objects.equals(this.networkInterfaceKey, other.networkInterfaceKey) && Objects.equals(this.ownerKey, other.ownerKey) && Objects.equals(this.privateIpAddresses, other.privateIpAddresses) && Objects.equals(this.isSourceDestCheck, other.isSourceDestCheck) && Objects.equals(this.status, other.status) && Objects.equals(this.subnetKey, other.subnetKey) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.association == null ? 43 : this.association.hashCode());
        result = result * 59 + (this.attachment == null ? 43 : this.attachment.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.securityGroups == null ? 43 : this.securityGroups.hashCode());
        result = result * 59 + (this.interfaceType == null ? 43 : this.interfaceType.hashCode());
        result = result * 59 + (this.ipv4Prefixes == null ? 43 : this.ipv4Prefixes.hashCode());
        result = result * 59 + (this.ipv6Addresses == null ? 43 : this.ipv6Addresses.hashCode());
        result = result * 59 + (this.ipv6Prefixes == null ? 43 : this.ipv6Prefixes.hashCode());
        result = result * 59 + (this.macAddress == null ? 43 : this.macAddress.hashCode());
        result = result * 59 + (this.networkInterfaceKey == null ? 43 : this.networkInterfaceKey.hashCode());
        result = result * 59 + (this.ownerKey == null ? 43 : this.ownerKey.hashCode());
        result = result * 59 + (this.privateIpAddresses == null ? 43 : this.privateIpAddresses.hashCode());
        result = result * 59 + (this.isSourceDestCheck == null ? 43 : this.isSourceDestCheck.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.subnetKey == null ? 43 : this.subnetKey.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="association")
        private InstanceNetworkInterfaceAssociation association;
        @JsonProperty(value="attachment")
        private InstanceNetworkInterfaceAttachment attachment;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="securityGroups")
        private List<GroupIdentifier> securityGroups;
        @JsonProperty(value="interfaceType")
        private String interfaceType;
        @JsonProperty(value="ipv4Prefixes")
        private List<String> ipv4Prefixes;
        @JsonProperty(value="ipv6Addresses")
        private List<String> ipv6Addresses;
        @JsonProperty(value="ipv6Prefixes")
        private List<String> ipv6Prefixes;
        @JsonProperty(value="macAddress")
        private String macAddress;
        @JsonProperty(value="networkInterfaceKey")
        private String networkInterfaceKey;
        @JsonProperty(value="ownerKey")
        private String ownerKey;
        @JsonProperty(value="privateIpAddresses")
        private List<InstancePrivateIpAddress> privateIpAddresses;
        @JsonProperty(value="isSourceDestCheck")
        private Boolean isSourceDestCheck;
        @JsonProperty(value="status")
        private String status;
        @JsonProperty(value="subnetKey")
        private String subnetKey;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder association(InstanceNetworkInterfaceAssociation association) {
            this.association = association;
            this.__explicitlySet__.add("association");
            return this;
        }

        public Builder attachment(InstanceNetworkInterfaceAttachment attachment) {
            this.attachment = attachment;
            this.__explicitlySet__.add("attachment");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder securityGroups(List<GroupIdentifier> securityGroups) {
            this.securityGroups = securityGroups;
            this.__explicitlySet__.add("securityGroups");
            return this;
        }

        public Builder interfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
            this.__explicitlySet__.add("interfaceType");
            return this;
        }

        public Builder ipv4Prefixes(List<String> ipv4Prefixes) {
            this.ipv4Prefixes = ipv4Prefixes;
            this.__explicitlySet__.add("ipv4Prefixes");
            return this;
        }

        public Builder ipv6Addresses(List<String> ipv6Addresses) {
            this.ipv6Addresses = ipv6Addresses;
            this.__explicitlySet__.add("ipv6Addresses");
            return this;
        }

        public Builder ipv6Prefixes(List<String> ipv6Prefixes) {
            this.ipv6Prefixes = ipv6Prefixes;
            this.__explicitlySet__.add("ipv6Prefixes");
            return this;
        }

        public Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            this.__explicitlySet__.add("macAddress");
            return this;
        }

        public Builder networkInterfaceKey(String networkInterfaceKey) {
            this.networkInterfaceKey = networkInterfaceKey;
            this.__explicitlySet__.add("networkInterfaceKey");
            return this;
        }

        public Builder ownerKey(String ownerKey) {
            this.ownerKey = ownerKey;
            this.__explicitlySet__.add("ownerKey");
            return this;
        }

        public Builder privateIpAddresses(List<InstancePrivateIpAddress> privateIpAddresses) {
            this.privateIpAddresses = privateIpAddresses;
            this.__explicitlySet__.add("privateIpAddresses");
            return this;
        }

        public Builder isSourceDestCheck(Boolean isSourceDestCheck) {
            this.isSourceDestCheck = isSourceDestCheck;
            this.__explicitlySet__.add("isSourceDestCheck");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder subnetKey(String subnetKey) {
            this.subnetKey = subnetKey;
            this.__explicitlySet__.add("subnetKey");
            return this;
        }

        public InstanceNetworkInterface build() {
            InstanceNetworkInterface model = new InstanceNetworkInterface(this.association, this.attachment, this.description, this.securityGroups, this.interfaceType, this.ipv4Prefixes, this.ipv6Addresses, this.ipv6Prefixes, this.macAddress, this.networkInterfaceKey, this.ownerKey, this.privateIpAddresses, this.isSourceDestCheck, this.status, this.subnetKey);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InstanceNetworkInterface model) {
            if (model.wasPropertyExplicitlySet("association")) {
                this.association(model.getAssociation());
            }
            if (model.wasPropertyExplicitlySet("attachment")) {
                this.attachment(model.getAttachment());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("securityGroups")) {
                this.securityGroups(model.getSecurityGroups());
            }
            if (model.wasPropertyExplicitlySet("interfaceType")) {
                this.interfaceType(model.getInterfaceType());
            }
            if (model.wasPropertyExplicitlySet("ipv4Prefixes")) {
                this.ipv4Prefixes(model.getIpv4Prefixes());
            }
            if (model.wasPropertyExplicitlySet("ipv6Addresses")) {
                this.ipv6Addresses(model.getIpv6Addresses());
            }
            if (model.wasPropertyExplicitlySet("ipv6Prefixes")) {
                this.ipv6Prefixes(model.getIpv6Prefixes());
            }
            if (model.wasPropertyExplicitlySet("macAddress")) {
                this.macAddress(model.getMacAddress());
            }
            if (model.wasPropertyExplicitlySet("networkInterfaceKey")) {
                this.networkInterfaceKey(model.getNetworkInterfaceKey());
            }
            if (model.wasPropertyExplicitlySet("ownerKey")) {
                this.ownerKey(model.getOwnerKey());
            }
            if (model.wasPropertyExplicitlySet("privateIpAddresses")) {
                this.privateIpAddresses(model.getPrivateIpAddresses());
            }
            if (model.wasPropertyExplicitlySet("isSourceDestCheck")) {
                this.isSourceDestCheck(model.getIsSourceDestCheck());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("subnetKey")) {
                this.subnetKey(model.getSubnetKey());
            }
            return this;
        }
    }
}

