/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InstanceNetworkInterfaceAttachment
extends ExplicitlySetBmcModel {
    @JsonProperty(value="attachmentKey")
    private final String attachmentKey;
    @JsonProperty(value="timeAttach")
    private final Date timeAttach;
    @JsonProperty(value="isDeleteOnTermination")
    private final Boolean isDeleteOnTermination;
    @JsonProperty(value="deviceIndex")
    private final Integer deviceIndex;
    @JsonProperty(value="networkCardIndex")
    private final Integer networkCardIndex;
    @JsonProperty(value="status")
    private final String status;

    @Deprecated
    @ConstructorProperties(value={"attachmentKey", "timeAttach", "isDeleteOnTermination", "deviceIndex", "networkCardIndex", "status"})
    public InstanceNetworkInterfaceAttachment(String attachmentKey, Date timeAttach, Boolean isDeleteOnTermination, Integer deviceIndex, Integer networkCardIndex, String status) {
        this.attachmentKey = attachmentKey;
        this.timeAttach = timeAttach;
        this.isDeleteOnTermination = isDeleteOnTermination;
        this.deviceIndex = deviceIndex;
        this.networkCardIndex = networkCardIndex;
        this.status = status;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAttachmentKey() {
        return this.attachmentKey;
    }

    public Date getTimeAttach() {
        return this.timeAttach;
    }

    public Boolean getIsDeleteOnTermination() {
        return this.isDeleteOnTermination;
    }

    public Integer getDeviceIndex() {
        return this.deviceIndex;
    }

    public Integer getNetworkCardIndex() {
        return this.networkCardIndex;
    }

    public String getStatus() {
        return this.status;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InstanceNetworkInterfaceAttachment(");
        sb.append("super=").append(super.toString());
        sb.append("attachmentKey=").append(String.valueOf(this.attachmentKey));
        sb.append(", timeAttach=").append(String.valueOf(this.timeAttach));
        sb.append(", isDeleteOnTermination=").append(String.valueOf(this.isDeleteOnTermination));
        sb.append(", deviceIndex=").append(String.valueOf(this.deviceIndex));
        sb.append(", networkCardIndex=").append(String.valueOf(this.networkCardIndex));
        sb.append(", status=").append(String.valueOf(this.status));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstanceNetworkInterfaceAttachment)) {
            return false;
        }
        InstanceNetworkInterfaceAttachment other = (InstanceNetworkInterfaceAttachment)((Object)o);
        return Objects.equals(this.attachmentKey, other.attachmentKey) && Objects.equals(this.timeAttach, other.timeAttach) && Objects.equals(this.isDeleteOnTermination, other.isDeleteOnTermination) && Objects.equals(this.deviceIndex, other.deviceIndex) && Objects.equals(this.networkCardIndex, other.networkCardIndex) && Objects.equals(this.status, other.status) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.attachmentKey == null ? 43 : this.attachmentKey.hashCode());
        result = result * 59 + (this.timeAttach == null ? 43 : this.timeAttach.hashCode());
        result = result * 59 + (this.isDeleteOnTermination == null ? 43 : this.isDeleteOnTermination.hashCode());
        result = result * 59 + (this.deviceIndex == null ? 43 : this.deviceIndex.hashCode());
        result = result * 59 + (this.networkCardIndex == null ? 43 : this.networkCardIndex.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="attachmentKey")
        private String attachmentKey;
        @JsonProperty(value="timeAttach")
        private Date timeAttach;
        @JsonProperty(value="isDeleteOnTermination")
        private Boolean isDeleteOnTermination;
        @JsonProperty(value="deviceIndex")
        private Integer deviceIndex;
        @JsonProperty(value="networkCardIndex")
        private Integer networkCardIndex;
        @JsonProperty(value="status")
        private String status;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder attachmentKey(String attachmentKey) {
            this.attachmentKey = attachmentKey;
            this.__explicitlySet__.add("attachmentKey");
            return this;
        }

        public Builder timeAttach(Date timeAttach) {
            this.timeAttach = timeAttach;
            this.__explicitlySet__.add("timeAttach");
            return this;
        }

        public Builder isDeleteOnTermination(Boolean isDeleteOnTermination) {
            this.isDeleteOnTermination = isDeleteOnTermination;
            this.__explicitlySet__.add("isDeleteOnTermination");
            return this;
        }

        public Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            this.__explicitlySet__.add("deviceIndex");
            return this;
        }

        public Builder networkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
            this.__explicitlySet__.add("networkCardIndex");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public InstanceNetworkInterfaceAttachment build() {
            InstanceNetworkInterfaceAttachment model = new InstanceNetworkInterfaceAttachment(this.attachmentKey, this.timeAttach, this.isDeleteOnTermination, this.deviceIndex, this.networkCardIndex, this.status);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InstanceNetworkInterfaceAttachment model) {
            if (model.wasPropertyExplicitlySet("attachmentKey")) {
                this.attachmentKey(model.getAttachmentKey());
            }
            if (model.wasPropertyExplicitlySet("timeAttach")) {
                this.timeAttach(model.getTimeAttach());
            }
            if (model.wasPropertyExplicitlySet("isDeleteOnTermination")) {
                this.isDeleteOnTermination(model.getIsDeleteOnTermination());
            }
            if (model.wasPropertyExplicitlySet("deviceIndex")) {
                this.deviceIndex(model.getDeviceIndex());
            }
            if (model.wasPropertyExplicitlySet("networkCardIndex")) {
                this.networkCardIndex(model.getNetworkCardIndex());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            return this;
        }
    }
}

