/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudbridge.model.InstanceNetworkInterfaceAssociation;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InstancePrivateIpAddress
extends ExplicitlySetBmcModel {
    @JsonProperty(value="association")
    private final InstanceNetworkInterfaceAssociation association;
    @JsonProperty(value="isPrimary")
    private final Boolean isPrimary;
    @JsonProperty(value="privateDnsName")
    private final String privateDnsName;
    @JsonProperty(value="privateIpAddress")
    private final String privateIpAddress;

    @Deprecated
    @ConstructorProperties(value={"association", "isPrimary", "privateDnsName", "privateIpAddress"})
    public InstancePrivateIpAddress(InstanceNetworkInterfaceAssociation association, Boolean isPrimary, String privateDnsName, String privateIpAddress) {
        this.association = association;
        this.isPrimary = isPrimary;
        this.privateDnsName = privateDnsName;
        this.privateIpAddress = privateIpAddress;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public InstanceNetworkInterfaceAssociation getAssociation() {
        return this.association;
    }

    public Boolean getIsPrimary() {
        return this.isPrimary;
    }

    public String getPrivateDnsName() {
        return this.privateDnsName;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InstancePrivateIpAddress(");
        sb.append("super=").append(super.toString());
        sb.append("association=").append(String.valueOf((Object)this.association));
        sb.append(", isPrimary=").append(String.valueOf(this.isPrimary));
        sb.append(", privateDnsName=").append(String.valueOf(this.privateDnsName));
        sb.append(", privateIpAddress=").append(String.valueOf(this.privateIpAddress));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstancePrivateIpAddress)) {
            return false;
        }
        InstancePrivateIpAddress other = (InstancePrivateIpAddress)((Object)o);
        return Objects.equals((Object)this.association, (Object)other.association) && Objects.equals(this.isPrimary, other.isPrimary) && Objects.equals(this.privateDnsName, other.privateDnsName) && Objects.equals(this.privateIpAddress, other.privateIpAddress) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.association == null ? 43 : this.association.hashCode());
        result = result * 59 + (this.isPrimary == null ? 43 : this.isPrimary.hashCode());
        result = result * 59 + (this.privateDnsName == null ? 43 : this.privateDnsName.hashCode());
        result = result * 59 + (this.privateIpAddress == null ? 43 : this.privateIpAddress.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="association")
        private InstanceNetworkInterfaceAssociation association;
        @JsonProperty(value="isPrimary")
        private Boolean isPrimary;
        @JsonProperty(value="privateDnsName")
        private String privateDnsName;
        @JsonProperty(value="privateIpAddress")
        private String privateIpAddress;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder association(InstanceNetworkInterfaceAssociation association) {
            this.association = association;
            this.__explicitlySet__.add("association");
            return this;
        }

        public Builder isPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary;
            this.__explicitlySet__.add("isPrimary");
            return this;
        }

        public Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            this.__explicitlySet__.add("privateDnsName");
            return this;
        }

        public Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            this.__explicitlySet__.add("privateIpAddress");
            return this;
        }

        public InstancePrivateIpAddress build() {
            InstancePrivateIpAddress model = new InstancePrivateIpAddress(this.association, this.isPrimary, this.privateDnsName, this.privateIpAddress);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InstancePrivateIpAddress model) {
            if (model.wasPropertyExplicitlySet("association")) {
                this.association(model.getAssociation());
            }
            if (model.wasPropertyExplicitlySet("isPrimary")) {
                this.isPrimary(model.getIsPrimary());
            }
            if (model.wasPropertyExplicitlySet("privateDnsName")) {
                this.privateDnsName(model.getPrivateDnsName());
            }
            if (model.wasPropertyExplicitlySet("privateIpAddress")) {
                this.privateIpAddress(model.getPrivateIpAddress());
            }
            return this;
        }
    }
}

