/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Placement
extends ExplicitlySetBmcModel {
    @JsonProperty(value="affinity")
    private final String affinity;
    @JsonProperty(value="availabilityZone")
    private final String availabilityZone;
    @JsonProperty(value="groupName")
    private final String groupName;
    @JsonProperty(value="hostKey")
    private final String hostKey;
    @JsonProperty(value="hostResourceGroupArn")
    private final String hostResourceGroupArn;
    @JsonProperty(value="partitionNumber")
    private final Integer partitionNumber;
    @JsonProperty(value="spreadDomain")
    private final String spreadDomain;
    @JsonProperty(value="tenancy")
    private final String tenancy;

    @Deprecated
    @ConstructorProperties(value={"affinity", "availabilityZone", "groupName", "hostKey", "hostResourceGroupArn", "partitionNumber", "spreadDomain", "tenancy"})
    public Placement(String affinity, String availabilityZone, String groupName, String hostKey, String hostResourceGroupArn, Integer partitionNumber, String spreadDomain, String tenancy) {
        this.affinity = affinity;
        this.availabilityZone = availabilityZone;
        this.groupName = groupName;
        this.hostKey = hostKey;
        this.hostResourceGroupArn = hostResourceGroupArn;
        this.partitionNumber = partitionNumber;
        this.spreadDomain = spreadDomain;
        this.tenancy = tenancy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAffinity() {
        return this.affinity;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getHostKey() {
        return this.hostKey;
    }

    public String getHostResourceGroupArn() {
        return this.hostResourceGroupArn;
    }

    public Integer getPartitionNumber() {
        return this.partitionNumber;
    }

    public String getSpreadDomain() {
        return this.spreadDomain;
    }

    public String getTenancy() {
        return this.tenancy;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Placement(");
        sb.append("super=").append(super.toString());
        sb.append("affinity=").append(String.valueOf(this.affinity));
        sb.append(", availabilityZone=").append(String.valueOf(this.availabilityZone));
        sb.append(", groupName=").append(String.valueOf(this.groupName));
        sb.append(", hostKey=").append(String.valueOf(this.hostKey));
        sb.append(", hostResourceGroupArn=").append(String.valueOf(this.hostResourceGroupArn));
        sb.append(", partitionNumber=").append(String.valueOf(this.partitionNumber));
        sb.append(", spreadDomain=").append(String.valueOf(this.spreadDomain));
        sb.append(", tenancy=").append(String.valueOf(this.tenancy));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Placement)) {
            return false;
        }
        Placement other = (Placement)((Object)o);
        return Objects.equals(this.affinity, other.affinity) && Objects.equals(this.availabilityZone, other.availabilityZone) && Objects.equals(this.groupName, other.groupName) && Objects.equals(this.hostKey, other.hostKey) && Objects.equals(this.hostResourceGroupArn, other.hostResourceGroupArn) && Objects.equals(this.partitionNumber, other.partitionNumber) && Objects.equals(this.spreadDomain, other.spreadDomain) && Objects.equals(this.tenancy, other.tenancy) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.affinity == null ? 43 : this.affinity.hashCode());
        result = result * 59 + (this.availabilityZone == null ? 43 : this.availabilityZone.hashCode());
        result = result * 59 + (this.groupName == null ? 43 : this.groupName.hashCode());
        result = result * 59 + (this.hostKey == null ? 43 : this.hostKey.hashCode());
        result = result * 59 + (this.hostResourceGroupArn == null ? 43 : this.hostResourceGroupArn.hashCode());
        result = result * 59 + (this.partitionNumber == null ? 43 : this.partitionNumber.hashCode());
        result = result * 59 + (this.spreadDomain == null ? 43 : this.spreadDomain.hashCode());
        result = result * 59 + (this.tenancy == null ? 43 : this.tenancy.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="affinity")
        private String affinity;
        @JsonProperty(value="availabilityZone")
        private String availabilityZone;
        @JsonProperty(value="groupName")
        private String groupName;
        @JsonProperty(value="hostKey")
        private String hostKey;
        @JsonProperty(value="hostResourceGroupArn")
        private String hostResourceGroupArn;
        @JsonProperty(value="partitionNumber")
        private Integer partitionNumber;
        @JsonProperty(value="spreadDomain")
        private String spreadDomain;
        @JsonProperty(value="tenancy")
        private String tenancy;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder affinity(String affinity) {
            this.affinity = affinity;
            this.__explicitlySet__.add("affinity");
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            this.__explicitlySet__.add("availabilityZone");
            return this;
        }

        public Builder groupName(String groupName) {
            this.groupName = groupName;
            this.__explicitlySet__.add("groupName");
            return this;
        }

        public Builder hostKey(String hostKey) {
            this.hostKey = hostKey;
            this.__explicitlySet__.add("hostKey");
            return this;
        }

        public Builder hostResourceGroupArn(String hostResourceGroupArn) {
            this.hostResourceGroupArn = hostResourceGroupArn;
            this.__explicitlySet__.add("hostResourceGroupArn");
            return this;
        }

        public Builder partitionNumber(Integer partitionNumber) {
            this.partitionNumber = partitionNumber;
            this.__explicitlySet__.add("partitionNumber");
            return this;
        }

        public Builder spreadDomain(String spreadDomain) {
            this.spreadDomain = spreadDomain;
            this.__explicitlySet__.add("spreadDomain");
            return this;
        }

        public Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            this.__explicitlySet__.add("tenancy");
            return this;
        }

        public Placement build() {
            Placement model = new Placement(this.affinity, this.availabilityZone, this.groupName, this.hostKey, this.hostResourceGroupArn, this.partitionNumber, this.spreadDomain, this.tenancy);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Placement model) {
            if (model.wasPropertyExplicitlySet("affinity")) {
                this.affinity(model.getAffinity());
            }
            if (model.wasPropertyExplicitlySet("availabilityZone")) {
                this.availabilityZone(model.getAvailabilityZone());
            }
            if (model.wasPropertyExplicitlySet("groupName")) {
                this.groupName(model.getGroupName());
            }
            if (model.wasPropertyExplicitlySet("hostKey")) {
                this.hostKey(model.getHostKey());
            }
            if (model.wasPropertyExplicitlySet("hostResourceGroupArn")) {
                this.hostResourceGroupArn(model.getHostResourceGroupArn());
            }
            if (model.wasPropertyExplicitlySet("partitionNumber")) {
                this.partitionNumber(model.getPartitionNumber());
            }
            if (model.wasPropertyExplicitlySet("spreadDomain")) {
                this.spreadDomain(model.getSpreadDomain());
            }
            if (model.wasPropertyExplicitlySet("tenancy")) {
                this.tenancy(model.getTenancy());
            }
            return this;
        }
    }
}

