/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.cloudbridge.model.UpdateAssetDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateAssetRequest
extends BmcRequest<UpdateAssetDetails> {
    private String assetId;
    private UpdateAssetDetails updateAssetDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getAssetId() {
        return this.assetId;
    }

    public UpdateAssetDetails getUpdateAssetDetails() {
        return this.updateAssetDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateAssetDetails getBody$() {
        return this.updateAssetDetails;
    }

    public Builder toBuilder() {
        return new Builder().assetId(this.assetId).updateAssetDetails(this.updateAssetDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",assetId=").append(String.valueOf(this.assetId));
        sb.append(",updateAssetDetails=").append(String.valueOf((Object)this.updateAssetDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateAssetRequest)) {
            return false;
        }
        UpdateAssetRequest other = (UpdateAssetRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.assetId, other.assetId) && Objects.equals((Object)this.updateAssetDetails, (Object)other.updateAssetDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.assetId == null ? 43 : this.assetId.hashCode());
        result = result * 59 + (this.updateAssetDetails == null ? 43 : this.updateAssetDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateAssetRequest, UpdateAssetDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String assetId = null;
        private UpdateAssetDetails updateAssetDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public Builder updateAssetDetails(UpdateAssetDetails updateAssetDetails) {
            this.updateAssetDetails = updateAssetDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateAssetRequest o) {
            this.assetId(o.getAssetId());
            this.updateAssetDetails(o.getUpdateAssetDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateAssetRequest build() {
            UpdateAssetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateAssetDetails body) {
            this.updateAssetDetails(body);
            return this;
        }

        public UpdateAssetRequest buildWithoutInvocationCallback() {
            UpdateAssetRequest request = new UpdateAssetRequest();
            request.assetId = this.assetId;
            request.updateAssetDetails = this.updateAssetDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

