/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.cloudguard.CloudGuard;
import com.oracle.bmc.cloudguard.CloudGuardPaginators;
import com.oracle.bmc.cloudguard.CloudGuardWaiters;
import com.oracle.bmc.cloudguard.model.ActivityProblemAggregationCollection;
import com.oracle.bmc.cloudguard.model.ConditionMetadataType;
import com.oracle.bmc.cloudguard.model.ConditionMetadataTypeCollection;
import com.oracle.bmc.cloudguard.model.Configuration;
import com.oracle.bmc.cloudguard.model.DataMaskRule;
import com.oracle.bmc.cloudguard.model.DataMaskRuleCollection;
import com.oracle.bmc.cloudguard.model.DataSource;
import com.oracle.bmc.cloudguard.model.DataSourceCollection;
import com.oracle.bmc.cloudguard.model.DataSourceEventCollection;
import com.oracle.bmc.cloudguard.model.Detector;
import com.oracle.bmc.cloudguard.model.DetectorCollection;
import com.oracle.bmc.cloudguard.model.DetectorRecipe;
import com.oracle.bmc.cloudguard.model.DetectorRecipeCollection;
import com.oracle.bmc.cloudguard.model.DetectorRecipeDetectorRule;
import com.oracle.bmc.cloudguard.model.DetectorRecipeDetectorRuleCollection;
import com.oracle.bmc.cloudguard.model.DetectorRule;
import com.oracle.bmc.cloudguard.model.DetectorRuleCollection;
import com.oracle.bmc.cloudguard.model.ImpactedResourceCollection;
import com.oracle.bmc.cloudguard.model.ManagedList;
import com.oracle.bmc.cloudguard.model.ManagedListCollection;
import com.oracle.bmc.cloudguard.model.ManagedListTypeCollection;
import com.oracle.bmc.cloudguard.model.PolicyCollection;
import com.oracle.bmc.cloudguard.model.Problem;
import com.oracle.bmc.cloudguard.model.ProblemAggregationCollection;
import com.oracle.bmc.cloudguard.model.ProblemCollection;
import com.oracle.bmc.cloudguard.model.ProblemEndpointCollection;
import com.oracle.bmc.cloudguard.model.ProblemEntityCollection;
import com.oracle.bmc.cloudguard.model.ProblemHistoryCollection;
import com.oracle.bmc.cloudguard.model.ProblemTrendAggregationCollection;
import com.oracle.bmc.cloudguard.model.RecommendationSummaryCollection;
import com.oracle.bmc.cloudguard.model.ResourceProfile;
import com.oracle.bmc.cloudguard.model.ResourceProfileCollection;
import com.oracle.bmc.cloudguard.model.ResourceProfileEndpointCollection;
import com.oracle.bmc.cloudguard.model.ResourceProfileImpactedResourceCollection;
import com.oracle.bmc.cloudguard.model.ResourceProfileRiskScoreAggregationSummaryCollection;
import com.oracle.bmc.cloudguard.model.ResourceRiskScoreAggregationCollection;
import com.oracle.bmc.cloudguard.model.ResourceTypeCollection;
import com.oracle.bmc.cloudguard.model.ResponderActivityCollection;
import com.oracle.bmc.cloudguard.model.ResponderExecution;
import com.oracle.bmc.cloudguard.model.ResponderExecutionAggregationCollection;
import com.oracle.bmc.cloudguard.model.ResponderExecutionCollection;
import com.oracle.bmc.cloudguard.model.ResponderExecutionTrendAggregationCollection;
import com.oracle.bmc.cloudguard.model.ResponderRecipe;
import com.oracle.bmc.cloudguard.model.ResponderRecipeCollection;
import com.oracle.bmc.cloudguard.model.ResponderRecipeResponderRule;
import com.oracle.bmc.cloudguard.model.ResponderRecipeResponderRuleCollection;
import com.oracle.bmc.cloudguard.model.ResponderRule;
import com.oracle.bmc.cloudguard.model.ResponderRuleCollection;
import com.oracle.bmc.cloudguard.model.RiskScoreAggregationCollection;
import com.oracle.bmc.cloudguard.model.SecurityPolicy;
import com.oracle.bmc.cloudguard.model.SecurityPolicyCollection;
import com.oracle.bmc.cloudguard.model.SecurityRecipe;
import com.oracle.bmc.cloudguard.model.SecurityRecipeCollection;
import com.oracle.bmc.cloudguard.model.SecurityScoreAggregationCollection;
import com.oracle.bmc.cloudguard.model.SecurityScoreTrendAggregationCollection;
import com.oracle.bmc.cloudguard.model.SecurityZone;
import com.oracle.bmc.cloudguard.model.SecurityZoneCollection;
import com.oracle.bmc.cloudguard.model.Sighting;
import com.oracle.bmc.cloudguard.model.SightingCollection;
import com.oracle.bmc.cloudguard.model.SightingEndpointCollection;
import com.oracle.bmc.cloudguard.model.SightingImpactedResourceCollection;
import com.oracle.bmc.cloudguard.model.TacticCollection;
import com.oracle.bmc.cloudguard.model.Target;
import com.oracle.bmc.cloudguard.model.TargetCollection;
import com.oracle.bmc.cloudguard.model.TargetDetectorRecipe;
import com.oracle.bmc.cloudguard.model.TargetDetectorRecipeCollection;
import com.oracle.bmc.cloudguard.model.TargetDetectorRecipeDetectorRule;
import com.oracle.bmc.cloudguard.model.TargetDetectorRecipeDetectorRuleCollection;
import com.oracle.bmc.cloudguard.model.TargetResponderRecipe;
import com.oracle.bmc.cloudguard.model.TargetResponderRecipeCollection;
import com.oracle.bmc.cloudguard.model.TargetResponderRecipeResponderRule;
import com.oracle.bmc.cloudguard.model.TargetResponderRecipeResponderRuleCollection;
import com.oracle.bmc.cloudguard.model.TechniqueCollection;
import com.oracle.bmc.cloudguard.model.WorkRequest;
import com.oracle.bmc.cloudguard.model.WorkRequestErrorCollection;
import com.oracle.bmc.cloudguard.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.cloudguard.model.WorkRequestSummaryCollection;
import com.oracle.bmc.cloudguard.requests.AddCompartmentRequest;
import com.oracle.bmc.cloudguard.requests.CancelWorkRequestRequest;
import com.oracle.bmc.cloudguard.requests.ChangeDataSourceCompartmentRequest;
import com.oracle.bmc.cloudguard.requests.ChangeDetectorRecipeCompartmentRequest;
import com.oracle.bmc.cloudguard.requests.ChangeManagedListCompartmentRequest;
import com.oracle.bmc.cloudguard.requests.ChangeResponderRecipeCompartmentRequest;
import com.oracle.bmc.cloudguard.requests.ChangeSecurityRecipeCompartmentRequest;
import com.oracle.bmc.cloudguard.requests.ChangeSecurityZoneCompartmentRequest;
import com.oracle.bmc.cloudguard.requests.CreateDataMaskRuleRequest;
import com.oracle.bmc.cloudguard.requests.CreateDataSourceRequest;
import com.oracle.bmc.cloudguard.requests.CreateDetectorRecipeDetectorRuleRequest;
import com.oracle.bmc.cloudguard.requests.CreateDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.CreateManagedListRequest;
import com.oracle.bmc.cloudguard.requests.CreateResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.CreateSecurityRecipeRequest;
import com.oracle.bmc.cloudguard.requests.CreateSecurityZoneRequest;
import com.oracle.bmc.cloudguard.requests.CreateTargetDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.CreateTargetRequest;
import com.oracle.bmc.cloudguard.requests.CreateTargetResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.DeleteDataMaskRuleRequest;
import com.oracle.bmc.cloudguard.requests.DeleteDataSourceRequest;
import com.oracle.bmc.cloudguard.requests.DeleteDetectorRecipeDetectorRuleDataSourceRequest;
import com.oracle.bmc.cloudguard.requests.DeleteDetectorRecipeDetectorRuleRequest;
import com.oracle.bmc.cloudguard.requests.DeleteDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.DeleteManagedListRequest;
import com.oracle.bmc.cloudguard.requests.DeleteResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.DeleteSecurityRecipeRequest;
import com.oracle.bmc.cloudguard.requests.DeleteSecurityZoneRequest;
import com.oracle.bmc.cloudguard.requests.DeleteTargetDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.DeleteTargetRequest;
import com.oracle.bmc.cloudguard.requests.DeleteTargetResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.ExecuteResponderExecutionRequest;
import com.oracle.bmc.cloudguard.requests.GetConditionMetadataTypeRequest;
import com.oracle.bmc.cloudguard.requests.GetConfigurationRequest;
import com.oracle.bmc.cloudguard.requests.GetDataMaskRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetDataSourceRequest;
import com.oracle.bmc.cloudguard.requests.GetDetectorRecipeDetectorRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.GetDetectorRequest;
import com.oracle.bmc.cloudguard.requests.GetDetectorRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetManagedListRequest;
import com.oracle.bmc.cloudguard.requests.GetProblemRequest;
import com.oracle.bmc.cloudguard.requests.GetResourceProfileRequest;
import com.oracle.bmc.cloudguard.requests.GetResponderExecutionRequest;
import com.oracle.bmc.cloudguard.requests.GetResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.GetResponderRecipeResponderRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetResponderRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetSecurityPolicyRequest;
import com.oracle.bmc.cloudguard.requests.GetSecurityRecipeRequest;
import com.oracle.bmc.cloudguard.requests.GetSecurityZoneRequest;
import com.oracle.bmc.cloudguard.requests.GetSightingRequest;
import com.oracle.bmc.cloudguard.requests.GetTargetDetectorRecipeDetectorRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetTargetDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.GetTargetRequest;
import com.oracle.bmc.cloudguard.requests.GetTargetResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.GetTargetResponderRecipeResponderRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetWorkRequestRequest;
import com.oracle.bmc.cloudguard.requests.ListConditionMetadataTypesRequest;
import com.oracle.bmc.cloudguard.requests.ListDataMaskRulesRequest;
import com.oracle.bmc.cloudguard.requests.ListDataSourceEventsRequest;
import com.oracle.bmc.cloudguard.requests.ListDataSourcesRequest;
import com.oracle.bmc.cloudguard.requests.ListDetectorRecipeDetectorRulesRequest;
import com.oracle.bmc.cloudguard.requests.ListDetectorRecipesRequest;
import com.oracle.bmc.cloudguard.requests.ListDetectorRulesRequest;
import com.oracle.bmc.cloudguard.requests.ListDetectorsRequest;
import com.oracle.bmc.cloudguard.requests.ListImpactedResourcesRequest;
import com.oracle.bmc.cloudguard.requests.ListManagedListTypesRequest;
import com.oracle.bmc.cloudguard.requests.ListManagedListsRequest;
import com.oracle.bmc.cloudguard.requests.ListPoliciesRequest;
import com.oracle.bmc.cloudguard.requests.ListProblemEndpointsRequest;
import com.oracle.bmc.cloudguard.requests.ListProblemEntitiesRequest;
import com.oracle.bmc.cloudguard.requests.ListProblemHistoriesRequest;
import com.oracle.bmc.cloudguard.requests.ListProblemsRequest;
import com.oracle.bmc.cloudguard.requests.ListRecommendationsRequest;
import com.oracle.bmc.cloudguard.requests.ListResourceProfileEndpointsRequest;
import com.oracle.bmc.cloudguard.requests.ListResourceProfileImpactedResourcesRequest;
import com.oracle.bmc.cloudguard.requests.ListResourceProfilesRequest;
import com.oracle.bmc.cloudguard.requests.ListResourceTypesRequest;
import com.oracle.bmc.cloudguard.requests.ListResponderActivitiesRequest;
import com.oracle.bmc.cloudguard.requests.ListResponderExecutionsRequest;
import com.oracle.bmc.cloudguard.requests.ListResponderRecipeResponderRulesRequest;
import com.oracle.bmc.cloudguard.requests.ListResponderRecipesRequest;
import com.oracle.bmc.cloudguard.requests.ListResponderRulesRequest;
import com.oracle.bmc.cloudguard.requests.ListSecurityPoliciesRequest;
import com.oracle.bmc.cloudguard.requests.ListSecurityRecipesRequest;
import com.oracle.bmc.cloudguard.requests.ListSecurityZonesRequest;
import com.oracle.bmc.cloudguard.requests.ListSightingEndpointsRequest;
import com.oracle.bmc.cloudguard.requests.ListSightingImpactedResourcesRequest;
import com.oracle.bmc.cloudguard.requests.ListSightingsRequest;
import com.oracle.bmc.cloudguard.requests.ListTacticsRequest;
import com.oracle.bmc.cloudguard.requests.ListTargetDetectorRecipeDetectorRulesRequest;
import com.oracle.bmc.cloudguard.requests.ListTargetDetectorRecipesRequest;
import com.oracle.bmc.cloudguard.requests.ListTargetResponderRecipeResponderRulesRequest;
import com.oracle.bmc.cloudguard.requests.ListTargetResponderRecipesRequest;
import com.oracle.bmc.cloudguard.requests.ListTargetsRequest;
import com.oracle.bmc.cloudguard.requests.ListTechniquesRequest;
import com.oracle.bmc.cloudguard.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.cloudguard.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.cloudguard.requests.ListWorkRequestsRequest;
import com.oracle.bmc.cloudguard.requests.RemoveCompartmentRequest;
import com.oracle.bmc.cloudguard.requests.RequestRiskScoresRequest;
import com.oracle.bmc.cloudguard.requests.RequestSecurityScoreSummarizedTrendRequest;
import com.oracle.bmc.cloudguard.requests.RequestSecurityScoresRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedActivityProblemsRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedProblemsRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedResponderExecutionsRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedRiskScoresRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedSecurityScoresRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedTopTrendResourceProfileRiskScoresRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedTrendProblemsRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedTrendResourceRiskScoresRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedTrendResponderExecutionsRequest;
import com.oracle.bmc.cloudguard.requests.RequestSummarizedTrendSecurityScoresRequest;
import com.oracle.bmc.cloudguard.requests.SkipBulkResponderExecutionRequest;
import com.oracle.bmc.cloudguard.requests.SkipResponderExecutionRequest;
import com.oracle.bmc.cloudguard.requests.TriggerResponderRequest;
import com.oracle.bmc.cloudguard.requests.UpdateBulkProblemStatusRequest;
import com.oracle.bmc.cloudguard.requests.UpdateConfigurationRequest;
import com.oracle.bmc.cloudguard.requests.UpdateDataMaskRuleRequest;
import com.oracle.bmc.cloudguard.requests.UpdateDataSourceRequest;
import com.oracle.bmc.cloudguard.requests.UpdateDetectorRecipeDetectorRuleRequest;
import com.oracle.bmc.cloudguard.requests.UpdateDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.UpdateManagedListRequest;
import com.oracle.bmc.cloudguard.requests.UpdateProblemStatusRequest;
import com.oracle.bmc.cloudguard.requests.UpdateResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.UpdateResponderRecipeResponderRuleRequest;
import com.oracle.bmc.cloudguard.requests.UpdateSecurityRecipeRequest;
import com.oracle.bmc.cloudguard.requests.UpdateSecurityZoneRequest;
import com.oracle.bmc.cloudguard.requests.UpdateTargetDetectorRecipeDetectorRuleRequest;
import com.oracle.bmc.cloudguard.requests.UpdateTargetDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.UpdateTargetRequest;
import com.oracle.bmc.cloudguard.requests.UpdateTargetResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.UpdateTargetResponderRecipeResponderRuleRequest;
import com.oracle.bmc.cloudguard.responses.AddCompartmentResponse;
import com.oracle.bmc.cloudguard.responses.CancelWorkRequestResponse;
import com.oracle.bmc.cloudguard.responses.ChangeDataSourceCompartmentResponse;
import com.oracle.bmc.cloudguard.responses.ChangeDetectorRecipeCompartmentResponse;
import com.oracle.bmc.cloudguard.responses.ChangeManagedListCompartmentResponse;
import com.oracle.bmc.cloudguard.responses.ChangeResponderRecipeCompartmentResponse;
import com.oracle.bmc.cloudguard.responses.ChangeSecurityRecipeCompartmentResponse;
import com.oracle.bmc.cloudguard.responses.ChangeSecurityZoneCompartmentResponse;
import com.oracle.bmc.cloudguard.responses.CreateDataMaskRuleResponse;
import com.oracle.bmc.cloudguard.responses.CreateDataSourceResponse;
import com.oracle.bmc.cloudguard.responses.CreateDetectorRecipeDetectorRuleResponse;
import com.oracle.bmc.cloudguard.responses.CreateDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.CreateManagedListResponse;
import com.oracle.bmc.cloudguard.responses.CreateResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.CreateSecurityRecipeResponse;
import com.oracle.bmc.cloudguard.responses.CreateSecurityZoneResponse;
import com.oracle.bmc.cloudguard.responses.CreateTargetDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.CreateTargetResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.CreateTargetResponse;
import com.oracle.bmc.cloudguard.responses.DeleteDataMaskRuleResponse;
import com.oracle.bmc.cloudguard.responses.DeleteDataSourceResponse;
import com.oracle.bmc.cloudguard.responses.DeleteDetectorRecipeDetectorRuleDataSourceResponse;
import com.oracle.bmc.cloudguard.responses.DeleteDetectorRecipeDetectorRuleResponse;
import com.oracle.bmc.cloudguard.responses.DeleteDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.DeleteManagedListResponse;
import com.oracle.bmc.cloudguard.responses.DeleteResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.DeleteSecurityRecipeResponse;
import com.oracle.bmc.cloudguard.responses.DeleteSecurityZoneResponse;
import com.oracle.bmc.cloudguard.responses.DeleteTargetDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.DeleteTargetResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.DeleteTargetResponse;
import com.oracle.bmc.cloudguard.responses.ExecuteResponderExecutionResponse;
import com.oracle.bmc.cloudguard.responses.GetConditionMetadataTypeResponse;
import com.oracle.bmc.cloudguard.responses.GetConfigurationResponse;
import com.oracle.bmc.cloudguard.responses.GetDataMaskRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetDataSourceResponse;
import com.oracle.bmc.cloudguard.responses.GetDetectorRecipeDetectorRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.GetDetectorResponse;
import com.oracle.bmc.cloudguard.responses.GetDetectorRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetManagedListResponse;
import com.oracle.bmc.cloudguard.responses.GetProblemResponse;
import com.oracle.bmc.cloudguard.responses.GetResourceProfileResponse;
import com.oracle.bmc.cloudguard.responses.GetResponderExecutionResponse;
import com.oracle.bmc.cloudguard.responses.GetResponderRecipeResponderRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.GetResponderRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetSecurityPolicyResponse;
import com.oracle.bmc.cloudguard.responses.GetSecurityRecipeResponse;
import com.oracle.bmc.cloudguard.responses.GetSecurityZoneResponse;
import com.oracle.bmc.cloudguard.responses.GetSightingResponse;
import com.oracle.bmc.cloudguard.responses.GetTargetDetectorRecipeDetectorRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetTargetDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.GetTargetResponderRecipeResponderRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetTargetResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.GetTargetResponse;
import com.oracle.bmc.cloudguard.responses.GetWorkRequestResponse;
import com.oracle.bmc.cloudguard.responses.ListConditionMetadataTypesResponse;
import com.oracle.bmc.cloudguard.responses.ListDataMaskRulesResponse;
import com.oracle.bmc.cloudguard.responses.ListDataSourceEventsResponse;
import com.oracle.bmc.cloudguard.responses.ListDataSourcesResponse;
import com.oracle.bmc.cloudguard.responses.ListDetectorRecipeDetectorRulesResponse;
import com.oracle.bmc.cloudguard.responses.ListDetectorRecipesResponse;
import com.oracle.bmc.cloudguard.responses.ListDetectorRulesResponse;
import com.oracle.bmc.cloudguard.responses.ListDetectorsResponse;
import com.oracle.bmc.cloudguard.responses.ListImpactedResourcesResponse;
import com.oracle.bmc.cloudguard.responses.ListManagedListTypesResponse;
import com.oracle.bmc.cloudguard.responses.ListManagedListsResponse;
import com.oracle.bmc.cloudguard.responses.ListPoliciesResponse;
import com.oracle.bmc.cloudguard.responses.ListProblemEndpointsResponse;
import com.oracle.bmc.cloudguard.responses.ListProblemEntitiesResponse;
import com.oracle.bmc.cloudguard.responses.ListProblemHistoriesResponse;
import com.oracle.bmc.cloudguard.responses.ListProblemsResponse;
import com.oracle.bmc.cloudguard.responses.ListRecommendationsResponse;
import com.oracle.bmc.cloudguard.responses.ListResourceProfileEndpointsResponse;
import com.oracle.bmc.cloudguard.responses.ListResourceProfileImpactedResourcesResponse;
import com.oracle.bmc.cloudguard.responses.ListResourceProfilesResponse;
import com.oracle.bmc.cloudguard.responses.ListResourceTypesResponse;
import com.oracle.bmc.cloudguard.responses.ListResponderActivitiesResponse;
import com.oracle.bmc.cloudguard.responses.ListResponderExecutionsResponse;
import com.oracle.bmc.cloudguard.responses.ListResponderRecipeResponderRulesResponse;
import com.oracle.bmc.cloudguard.responses.ListResponderRecipesResponse;
import com.oracle.bmc.cloudguard.responses.ListResponderRulesResponse;
import com.oracle.bmc.cloudguard.responses.ListSecurityPoliciesResponse;
import com.oracle.bmc.cloudguard.responses.ListSecurityRecipesResponse;
import com.oracle.bmc.cloudguard.responses.ListSecurityZonesResponse;
import com.oracle.bmc.cloudguard.responses.ListSightingEndpointsResponse;
import com.oracle.bmc.cloudguard.responses.ListSightingImpactedResourcesResponse;
import com.oracle.bmc.cloudguard.responses.ListSightingsResponse;
import com.oracle.bmc.cloudguard.responses.ListTacticsResponse;
import com.oracle.bmc.cloudguard.responses.ListTargetDetectorRecipeDetectorRulesResponse;
import com.oracle.bmc.cloudguard.responses.ListTargetDetectorRecipesResponse;
import com.oracle.bmc.cloudguard.responses.ListTargetResponderRecipeResponderRulesResponse;
import com.oracle.bmc.cloudguard.responses.ListTargetResponderRecipesResponse;
import com.oracle.bmc.cloudguard.responses.ListTargetsResponse;
import com.oracle.bmc.cloudguard.responses.ListTechniquesResponse;
import com.oracle.bmc.cloudguard.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.cloudguard.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.cloudguard.responses.ListWorkRequestsResponse;
import com.oracle.bmc.cloudguard.responses.RemoveCompartmentResponse;
import com.oracle.bmc.cloudguard.responses.RequestRiskScoresResponse;
import com.oracle.bmc.cloudguard.responses.RequestSecurityScoreSummarizedTrendResponse;
import com.oracle.bmc.cloudguard.responses.RequestSecurityScoresResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedActivityProblemsResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedProblemsResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedResponderExecutionsResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedRiskScoresResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedSecurityScoresResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedTopTrendResourceProfileRiskScoresResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedTrendProblemsResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedTrendResourceRiskScoresResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedTrendResponderExecutionsResponse;
import com.oracle.bmc.cloudguard.responses.RequestSummarizedTrendSecurityScoresResponse;
import com.oracle.bmc.cloudguard.responses.SkipBulkResponderExecutionResponse;
import com.oracle.bmc.cloudguard.responses.SkipResponderExecutionResponse;
import com.oracle.bmc.cloudguard.responses.TriggerResponderResponse;
import com.oracle.bmc.cloudguard.responses.UpdateBulkProblemStatusResponse;
import com.oracle.bmc.cloudguard.responses.UpdateConfigurationResponse;
import com.oracle.bmc.cloudguard.responses.UpdateDataMaskRuleResponse;
import com.oracle.bmc.cloudguard.responses.UpdateDataSourceResponse;
import com.oracle.bmc.cloudguard.responses.UpdateDetectorRecipeDetectorRuleResponse;
import com.oracle.bmc.cloudguard.responses.UpdateDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.UpdateManagedListResponse;
import com.oracle.bmc.cloudguard.responses.UpdateProblemStatusResponse;
import com.oracle.bmc.cloudguard.responses.UpdateResponderRecipeResponderRuleResponse;
import com.oracle.bmc.cloudguard.responses.UpdateResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.UpdateSecurityRecipeResponse;
import com.oracle.bmc.cloudguard.responses.UpdateSecurityZoneResponse;
import com.oracle.bmc.cloudguard.responses.UpdateTargetDetectorRecipeDetectorRuleResponse;
import com.oracle.bmc.cloudguard.responses.UpdateTargetDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.UpdateTargetResponderRecipeResponderRuleResponse;
import com.oracle.bmc.cloudguard.responses.UpdateTargetResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.UpdateTargetResponse;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudGuardClient
extends BaseSyncClient
implements CloudGuard {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("CLOUDGUARD").serviceEndpointPrefix("").serviceEndpointTemplate("https://cloudguard-cp-api.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(CloudGuardClient.class);
    private final CloudGuardWaiters waiters;
    private final CloudGuardPaginators paginators;

    CloudGuardClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("CloudGuard-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new CloudGuardWaiters(executorService, this);
        this.paginators = new CloudGuardPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AddCompartmentResponse addCompartment(AddCompartmentRequest request) {
        Validate.notBlank((String)request.getSecurityZoneId(), (String)"securityZoneId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddCompartmentDetails(), "addCompartmentDetails is required");
        return (AddCompartmentResponse)this.clientCall(request, AddCompartmentResponse::builder).logger(LOG, "addCompartment").serviceDetails("CloudGuard", "AddCompartment", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/SecurityZone/AddCompartment").method(Method.POST).requestBuilder(AddCompartmentRequest::builder).basePath("/20200131").appendPathParam("securityZones").appendPathParam(request.getSecurityZoneId()).appendPathParam("actions").appendPathParam("addCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SecurityZone.class, AddCompartmentResponse.Builder::securityZone).handleResponseHeaderString("etag", AddCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AddCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (CancelWorkRequestResponse)this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("CloudGuard", "CancelWorkRequest", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/WorkRequest/CancelWorkRequest").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20200131").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeDataSourceCompartmentResponse changeDataSourceCompartment(ChangeDataSourceCompartmentRequest request) {
        Validate.notBlank((String)request.getDataSourceId(), (String)"dataSourceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDataSourceCompartmentDetails(), "changeDataSourceCompartmentDetails is required");
        return (ChangeDataSourceCompartmentResponse)this.clientCall(request, ChangeDataSourceCompartmentResponse::builder).logger(LOG, "changeDataSourceCompartment").serviceDetails("CloudGuard", "ChangeDataSourceCompartment", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DataSource/ChangeDataSourceCompartment").method(Method.POST).requestBuilder(ChangeDataSourceCompartmentRequest::builder).basePath("/20200131").appendPathParam("dataSources").appendPathParam(request.getDataSourceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeDataSourceCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeDataSourceCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeDetectorRecipeCompartmentResponse changeDetectorRecipeCompartment(ChangeDetectorRecipeCompartmentRequest request) {
        Validate.notBlank((String)request.getDetectorRecipeId(), (String)"detectorRecipeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDetectorRecipeCompartmentDetails(), "changeDetectorRecipeCompartmentDetails is required");
        return (ChangeDetectorRecipeCompartmentResponse)this.clientCall(request, ChangeDetectorRecipeCompartmentResponse::builder).logger(LOG, "changeDetectorRecipeCompartment").serviceDetails("CloudGuard", "ChangeDetectorRecipeCompartment", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DetectorRecipe/ChangeDetectorRecipeCompartment").method(Method.POST).requestBuilder(ChangeDetectorRecipeCompartmentRequest::builder).basePath("/20200131").appendPathParam("detectorRecipes").appendPathParam(request.getDetectorRecipeId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeDetectorRecipeCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeManagedListCompartmentResponse changeManagedListCompartment(ChangeManagedListCompartmentRequest request) {
        Validate.notBlank((String)request.getManagedListId(), (String)"managedListId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeManagedListCompartmentDetails(), "changeManagedListCompartmentDetails is required");
        return (ChangeManagedListCompartmentResponse)this.clientCall(request, ChangeManagedListCompartmentResponse::builder).logger(LOG, "changeManagedListCompartment").serviceDetails("CloudGuard", "ChangeManagedListCompartment", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ManagedList/ChangeManagedListCompartment").method(Method.POST).requestBuilder(ChangeManagedListCompartmentRequest::builder).basePath("/20200131").appendPathParam("managedLists").appendPathParam(request.getManagedListId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeManagedListCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeResponderRecipeCompartmentResponse changeResponderRecipeCompartment(ChangeResponderRecipeCompartmentRequest request) {
        Validate.notBlank((String)request.getResponderRecipeId(), (String)"responderRecipeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeResponderRecipeCompartmentDetails(), "changeResponderRecipeCompartmentDetails is required");
        return (ChangeResponderRecipeCompartmentResponse)this.clientCall(request, ChangeResponderRecipeCompartmentResponse::builder).logger(LOG, "changeResponderRecipeCompartment").serviceDetails("CloudGuard", "ChangeResponderRecipeCompartment", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResponderRecipe/ChangeResponderRecipeCompartment").method(Method.POST).requestBuilder(ChangeResponderRecipeCompartmentRequest::builder).basePath("/20200131").appendPathParam("responderRecipes").appendPathParam(request.getResponderRecipeId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeResponderRecipeCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeSecurityRecipeCompartmentResponse changeSecurityRecipeCompartment(ChangeSecurityRecipeCompartmentRequest request) {
        Validate.notBlank((String)request.getSecurityRecipeId(), (String)"securityRecipeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeSecurityRecipeCompartmentDetails(), "changeSecurityRecipeCompartmentDetails is required");
        return (ChangeSecurityRecipeCompartmentResponse)this.clientCall(request, ChangeSecurityRecipeCompartmentResponse::builder).logger(LOG, "changeSecurityRecipeCompartment").serviceDetails("CloudGuard", "ChangeSecurityRecipeCompartment", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/SecurityRecipe/ChangeSecurityRecipeCompartment").method(Method.POST).requestBuilder(ChangeSecurityRecipeCompartmentRequest::builder).basePath("/20200131").appendPathParam("securityRecipes").appendPathParam(request.getSecurityRecipeId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeSecurityRecipeCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeSecurityZoneCompartmentResponse changeSecurityZoneCompartment(ChangeSecurityZoneCompartmentRequest request) {
        Validate.notBlank((String)request.getSecurityZoneId(), (String)"securityZoneId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeSecurityZoneCompartmentDetails(), "changeSecurityZoneCompartmentDetails is required");
        return (ChangeSecurityZoneCompartmentResponse)this.clientCall(request, ChangeSecurityZoneCompartmentResponse::builder).logger(LOG, "changeSecurityZoneCompartment").serviceDetails("CloudGuard", "ChangeSecurityZoneCompartment", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/SecurityZone/ChangeSecurityZoneCompartment").method(Method.POST).requestBuilder(ChangeSecurityZoneCompartmentRequest::builder).basePath("/20200131").appendPathParam("securityZones").appendPathParam(request.getSecurityZoneId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeSecurityZoneCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDataMaskRuleResponse createDataMaskRule(CreateDataMaskRuleRequest request) {
        Objects.requireNonNull(request.getCreateDataMaskRuleDetails(), "createDataMaskRuleDetails is required");
        return (CreateDataMaskRuleResponse)this.clientCall(request, CreateDataMaskRuleResponse::builder).logger(LOG, "createDataMaskRule").serviceDetails("CloudGuard", "CreateDataMaskRule", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DataMaskRule/CreateDataMaskRule").method(Method.POST).requestBuilder(CreateDataMaskRuleRequest::builder).basePath("/20200131").appendPathParam("dataMaskRules").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DataMaskRule.class, CreateDataMaskRuleResponse.Builder::dataMaskRule).handleResponseHeaderString("etag", CreateDataMaskRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDataMaskRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDataSourceResponse createDataSource(CreateDataSourceRequest request) {
        Objects.requireNonNull(request.getCreateDataSourceDetails(), "createDataSourceDetails is required");
        return (CreateDataSourceResponse)this.clientCall(request, CreateDataSourceResponse::builder).logger(LOG, "createDataSource").serviceDetails("CloudGuard", "CreateDataSource", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DataSource/CreateDataSource").method(Method.POST).requestBuilder(CreateDataSourceRequest::builder).basePath("/20200131").appendPathParam("dataSources").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateDataSourceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDataSourceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDetectorRecipeResponse createDetectorRecipe(CreateDetectorRecipeRequest request) {
        Objects.requireNonNull(request.getCreateDetectorRecipeDetails(), "createDetectorRecipeDetails is required");
        return (CreateDetectorRecipeResponse)this.clientCall(request, CreateDetectorRecipeResponse::builder).logger(LOG, "createDetectorRecipe").serviceDetails("CloudGuard", "CreateDetectorRecipe", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DetectorRecipe/CreateDetectorRecipe").method(Method.POST).requestBuilder(CreateDetectorRecipeRequest::builder).basePath("/20200131").appendPathParam("detectorRecipes").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DetectorRecipe.class, CreateDetectorRecipeResponse.Builder::detectorRecipe).handleResponseHeaderString("etag", CreateDetectorRecipeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDetectorRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDetectorRecipeDetectorRuleResponse createDetectorRecipeDetectorRule(CreateDetectorRecipeDetectorRuleRequest request) {
        Validate.notBlank((String)request.getDetectorRecipeId(), (String)"detectorRecipeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateDetectorRecipeDetectorRuleDetails(), "createDetectorRecipeDetectorRuleDetails is required");
        return (CreateDetectorRecipeDetectorRuleResponse)this.clientCall(request, CreateDetectorRecipeDetectorRuleResponse::builder).logger(LOG, "createDetectorRecipeDetectorRule").serviceDetails("CloudGuard", "CreateDetectorRecipeDetectorRule", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DetectorRecipeDetectorRule/CreateDetectorRecipeDetectorRule").method(Method.POST).requestBuilder(CreateDetectorRecipeDetectorRuleRequest::builder).basePath("/20200131").appendPathParam("detectorRecipes").appendPathParam(request.getDetectorRecipeId()).appendPathParam("detectorRules").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DetectorRecipeDetectorRule.class, CreateDetectorRecipeDetectorRuleResponse.Builder::detectorRecipeDetectorRule).handleResponseHeaderString("etag", CreateDetectorRecipeDetectorRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDetectorRecipeDetectorRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateManagedListResponse createManagedList(CreateManagedListRequest request) {
        Objects.requireNonNull(request.getCreateManagedListDetails(), "createManagedListDetails is required");
        return (CreateManagedListResponse)this.clientCall(request, CreateManagedListResponse::builder).logger(LOG, "createManagedList").serviceDetails("CloudGuard", "CreateManagedList", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ManagedList/CreateManagedList").method(Method.POST).requestBuilder(CreateManagedListRequest::builder).basePath("/20200131").appendPathParam("managedLists").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ManagedList.class, CreateManagedListResponse.Builder::managedList).handleResponseHeaderString("etag", CreateManagedListResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateManagedListResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateResponderRecipeResponse createResponderRecipe(CreateResponderRecipeRequest request) {
        Objects.requireNonNull(request.getCreateResponderRecipeDetails(), "createResponderRecipeDetails is required");
        return (CreateResponderRecipeResponse)this.clientCall(request, CreateResponderRecipeResponse::builder).logger(LOG, "createResponderRecipe").serviceDetails("CloudGuard", "CreateResponderRecipe", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResponderRecipe/CreateResponderRecipe").method(Method.POST).requestBuilder(CreateResponderRecipeRequest::builder).basePath("/20200131").appendPathParam("responderRecipes").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ResponderRecipe.class, CreateResponderRecipeResponse.Builder::responderRecipe).handleResponseHeaderString("etag", CreateResponderRecipeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateResponderRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateSecurityRecipeResponse createSecurityRecipe(CreateSecurityRecipeRequest request) {
        Objects.requireNonNull(request.getCreateSecurityRecipeDetails(), "createSecurityRecipeDetails is required");
        return (CreateSecurityRecipeResponse)this.clientCall(request, CreateSecurityRecipeResponse::builder).logger(LOG, "createSecurityRecipe").serviceDetails("CloudGuard", "CreateSecurityRecipe", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/SecurityRecipe/CreateSecurityRecipe").method(Method.POST).requestBuilder(CreateSecurityRecipeRequest::builder).basePath("/20200131").appendPathParam("securityRecipes").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SecurityRecipe.class, CreateSecurityRecipeResponse.Builder::securityRecipe).handleResponseHeaderString("etag", CreateSecurityRecipeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateSecurityRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateSecurityZoneResponse createSecurityZone(CreateSecurityZoneRequest request) {
        Objects.requireNonNull(request.getCreateSecurityZoneDetails(), "createSecurityZoneDetails is required");
        return (CreateSecurityZoneResponse)this.clientCall(request, CreateSecurityZoneResponse::builder).logger(LOG, "createSecurityZone").serviceDetails("CloudGuard", "CreateSecurityZone", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/SecurityZone/CreateSecurityZone").method(Method.POST).requestBuilder(CreateSecurityZoneRequest::builder).basePath("/20200131").appendPathParam("securityZones").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SecurityZone.class, CreateSecurityZoneResponse.Builder::securityZone).handleResponseHeaderString("etag", CreateSecurityZoneResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateSecurityZoneResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateTargetResponse createTarget(CreateTargetRequest request) {
        Objects.requireNonNull(request.getCreateTargetDetails(), "createTargetDetails is required");
        return (CreateTargetResponse)this.clientCall(request, CreateTargetResponse::builder).logger(LOG, "createTarget").serviceDetails("CloudGuard", "CreateTarget", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/Target/CreateTarget").method(Method.POST).requestBuilder(CreateTargetRequest::builder).basePath("/20200131").appendPathParam("targets").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Target.class, CreateTargetResponse.Builder::target).handleResponseHeaderString("etag", CreateTargetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateTargetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateTargetDetectorRecipeResponse createTargetDetectorRecipe(CreateTargetDetectorRecipeRequest request) {
        Validate.notBlank((String)request.getTargetId(), (String)"targetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAttachTargetDetectorRecipeDetails(), "attachTargetDetectorRecipeDetails is required");
        return (CreateTargetDetectorRecipeResponse)this.clientCall(request, CreateTargetDetectorRecipeResponse::builder).logger(LOG, "createTargetDetectorRecipe").serviceDetails("CloudGuard", "CreateTargetDetectorRecipe", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/TargetDetectorRecipe/CreateTargetDetectorRecipe").method(Method.POST).requestBuilder(CreateTargetDetectorRecipeRequest::builder).basePath("/20200131").appendPathParam("targets").appendPathParam(request.getTargetId()).appendPathParam("targetDetectorRecipes").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TargetDetectorRecipe.class, CreateTargetDetectorRecipeResponse.Builder::targetDetectorRecipe).handleResponseHeaderString("etag", CreateTargetDetectorRecipeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateTargetDetectorRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateTargetResponderRecipeResponse createTargetResponderRecipe(CreateTargetResponderRecipeRequest request) {
        Validate.notBlank((String)request.getTargetId(), (String)"targetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAttachTargetResponderRecipeDetails(), "attachTargetResponderRecipeDetails is required");
        return (CreateTargetResponderRecipeResponse)this.clientCall(request, CreateTargetResponderRecipeResponse::builder).logger(LOG, "createTargetResponderRecipe").serviceDetails("CloudGuard", "CreateTargetResponderRecipe", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/TargetResponderRecipe/CreateTargetResponderRecipe").method(Method.POST).requestBuilder(CreateTargetResponderRecipeRequest::builder).basePath("/20200131").appendPathParam("targets").appendPathParam(request.getTargetId()).appendPathParam("targetResponderRecipes").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TargetResponderRecipe.class, CreateTargetResponderRecipeResponse.Builder::targetResponderRecipe).handleResponseHeaderString("etag", CreateTargetResponderRecipeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateTargetResponderRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDataMaskRuleResponse deleteDataMaskRule(DeleteDataMaskRuleRequest request) {
        Validate.notBlank((String)request.getDataMaskRuleId(), (String)"dataMaskRuleId must not be blank", (Object[])new Object[0]);
        return (DeleteDataMaskRuleResponse)this.clientCall(request, DeleteDataMaskRuleResponse::builder).logger(LOG, "deleteDataMaskRule").serviceDetails("CloudGuard", "DeleteDataMaskRule", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DataMaskRule/DeleteDataMaskRule").method(Method.DELETE).requestBuilder(DeleteDataMaskRuleRequest::builder).basePath("/20200131").appendPathParam("dataMaskRules").appendPathParam(request.getDataMaskRuleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDataMaskRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDataSourceResponse deleteDataSource(DeleteDataSourceRequest request) {
        Validate.notBlank((String)request.getDataSourceId(), (String)"dataSourceId must not be blank", (Object[])new Object[0]);
        return (DeleteDataSourceResponse)this.clientCall(request, DeleteDataSourceResponse::builder).logger(LOG, "deleteDataSource").serviceDetails("CloudGuard", "DeleteDataSource", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DataSource/DeleteDataSource").method(Method.DELETE).requestBuilder(DeleteDataSourceRequest::builder).basePath("/20200131").appendPathParam("dataSources").appendPathParam(request.getDataSourceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", DeleteDataSourceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDataSourceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDetectorRecipeResponse deleteDetectorRecipe(DeleteDetectorRecipeRequest request) {
        Validate.notBlank((String)request.getDetectorRecipeId(), (String)"detectorRecipeId must not be blank", (Object[])new Object[0]);
        return (DeleteDetectorRecipeResponse)this.clientCall(request, DeleteDetectorRecipeResponse::builder).logger(LOG, "deleteDetectorRecipe").serviceDetails("CloudGuard", "DeleteDetectorRecipe", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DetectorRecipe/DeleteDetectorRecipe").method(Method.DELETE).requestBuilder(DeleteDetectorRecipeRequest::builder).basePath("/20200131").appendPathParam("detectorRecipes").appendPathParam(request.getDetectorRecipeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", DeleteDetectorRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDetectorRecipeDetectorRuleResponse deleteDetectorRecipeDetectorRule(DeleteDetectorRecipeDetectorRuleRequest request) {
        Validate.notBlank((String)request.getDetectorRecipeId(), (String)"detectorRecipeId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDetectorRuleId(), (String)"detectorRuleId must not be blank", (Object[])new Object[0]);
        return (DeleteDetectorRecipeDetectorRuleResponse)this.clientCall(request, DeleteDetectorRecipeDetectorRuleResponse::builder).logger(LOG, "deleteDetectorRecipeDetectorRule").serviceDetails("CloudGuard", "DeleteDetectorRecipeDetectorRule", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DetectorRecipeDetectorRule/DeleteDetectorRecipeDetectorRule").method(Method.DELETE).requestBuilder(DeleteDetectorRecipeDetectorRuleRequest::builder).basePath("/20200131").appendPathParam("detectorRecipes").appendPathParam(request.getDetectorRecipeId()).appendPathParam("detectorRules").appendPathParam(request.getDetectorRuleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDetectorRecipeDetectorRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDetectorRecipeDetectorRuleDataSourceResponse deleteDetectorRecipeDetectorRuleDataSource(DeleteDetectorRecipeDetectorRuleDataSourceRequest request) {
        Validate.notBlank((String)request.getDetectorRecipeId(), (String)"detectorRecipeId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDetectorRuleId(), (String)"detectorRuleId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataSourceId(), (String)"dataSourceId must not be blank", (Object[])new Object[0]);
        return (DeleteDetectorRecipeDetectorRuleDataSourceResponse)this.clientCall(request, DeleteDetectorRecipeDetectorRuleDataSourceResponse::builder).logger(LOG, "deleteDetectorRecipeDetectorRuleDataSource").serviceDetails("CloudGuard", "DeleteDetectorRecipeDetectorRuleDataSource", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DetectorRecipeDetectorRule/DeleteDetectorRecipeDetectorRuleDataSource").method(Method.DELETE).requestBuilder(DeleteDetectorRecipeDetectorRuleDataSourceRequest::builder).basePath("/20200131").appendPathParam("detectorRecipes").appendPathParam(request.getDetectorRecipeId()).appendPathParam("detectorRules").appendPathParam(request.getDetectorRuleId()).appendPathParam("dataSources").appendPathParam(request.getDataSourceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDetectorRecipeDetectorRuleDataSourceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteManagedListResponse deleteManagedList(DeleteManagedListRequest request) {
        Validate.notBlank((String)request.getManagedListId(), (String)"managedListId must not be blank", (Object[])new Object[0]);
        return (DeleteManagedListResponse)this.clientCall(request, DeleteManagedListResponse::builder).logger(LOG, "deleteManagedList").serviceDetails("CloudGuard", "DeleteManagedList", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ManagedList/DeleteManagedList").method(Method.DELETE).requestBuilder(DeleteManagedListRequest::builder).basePath("/20200131").appendPathParam("managedLists").appendPathParam(request.getManagedListId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", DeleteManagedListResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteResponderRecipeResponse deleteResponderRecipe(DeleteResponderRecipeRequest request) {
        Validate.notBlank((String)request.getResponderRecipeId(), (String)"responderRecipeId must not be blank", (Object[])new Object[0]);
        return (DeleteResponderRecipeResponse)this.clientCall(request, DeleteResponderRecipeResponse::builder).logger(LOG, "deleteResponderRecipe").serviceDetails("CloudGuard", "DeleteResponderRecipe", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResponderRecipe/DeleteResponderRecipe").method(Method.DELETE).requestBuilder(DeleteResponderRecipeRequest::builder).basePath("/20200131").appendPathParam("responderRecipes").appendPathParam(request.getResponderRecipeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteResponderRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteSecurityRecipeResponse deleteSecurityRecipe(DeleteSecurityRecipeRequest request) {
        Validate.notBlank((String)request.getSecurityRecipeId(), (String)"securityRecipeId must not be blank", (Object[])new Object[0]);
        return (DeleteSecurityRecipeResponse)this.clientCall(request, DeleteSecurityRecipeResponse::builder).logger(LOG, "deleteSecurityRecipe").serviceDetails("CloudGuard", "DeleteSecurityRecipe", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/SecurityRecipe/DeleteSecurityRecipe").method(Method.DELETE).requestBuilder(DeleteSecurityRecipeRequest::builder).basePath("/20200131").appendPathParam("securityRecipes").appendPathParam(request.getSecurityRecipeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteSecurityRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteSecurityZoneResponse deleteSecurityZone(DeleteSecurityZoneRequest request) {
        Validate.notBlank((String)request.getSecurityZoneId(), (String)"securityZoneId must not be blank", (Object[])new Object[0]);
        return (DeleteSecurityZoneResponse)this.clientCall(request, DeleteSecurityZoneResponse::builder).logger(LOG, "deleteSecurityZone").serviceDetails("CloudGuard", "DeleteSecurityZone", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/SecurityZone/DeleteSecurityZone").method(Method.DELETE).requestBuilder(DeleteSecurityZoneRequest::builder).basePath("/20200131").appendPathParam("securityZones").appendPathParam(request.getSecurityZoneId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteSecurityZoneResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteTargetResponse deleteTarget(DeleteTargetRequest request) {
        Validate.notBlank((String)request.getTargetId(), (String)"targetId must not be blank", (Object[])new Object[0]);
        return (DeleteTargetResponse)this.clientCall(request, DeleteTargetResponse::builder).logger(LOG, "deleteTarget").serviceDetails("CloudGuard", "DeleteTarget", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/Target/DeleteTarget").method(Method.DELETE).requestBuilder(DeleteTargetRequest::builder).basePath("/20200131").appendPathParam("targets").appendPathParam(request.getTargetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteTargetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteTargetDetectorRecipeResponse deleteTargetDetectorRecipe(DeleteTargetDetectorRecipeRequest request) {
        Validate.notBlank((String)request.getTargetId(), (String)"targetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTargetDetectorRecipeId(), (String)"targetDetectorRecipeId must not be blank", (Object[])new Object[0]);
        return (DeleteTargetDetectorRecipeResponse)this.clientCall(request, DeleteTargetDetectorRecipeResponse::builder).logger(LOG, "deleteTargetDetectorRecipe").serviceDetails("CloudGuard", "DeleteTargetDetectorRecipe", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/TargetDetectorRecipe/DeleteTargetDetectorRecipe").method(Method.DELETE).requestBuilder(DeleteTargetDetectorRecipeRequest::builder).basePath("/20200131").appendPathParam("targets").appendPathParam(request.getTargetId()).appendPathParam("targetDetectorRecipes").appendPathParam(request.getTargetDetectorRecipeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteTargetDetectorRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteTargetResponderRecipeResponse deleteTargetResponderRecipe(DeleteTargetResponderRecipeRequest request) {
        Validate.notBlank((String)request.getTargetId(), (String)"targetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTargetResponderRecipeId(), (String)"targetResponderRecipeId must not be blank", (Object[])new Object[0]);
        return (DeleteTargetResponderRecipeResponse)this.clientCall(request, DeleteTargetResponderRecipeResponse::builder).logger(LOG, "deleteTargetResponderRecipe").serviceDetails("CloudGuard", "DeleteTargetResponderRecipe", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/TargetResponderRecipe/DeleteTargetResponderRecipe").method(Method.DELETE).requestBuilder(DeleteTargetResponderRecipeRequest::builder).basePath("/20200131").appendPathParam("targets").appendPathParam(request.getTargetId()).appendPathParam("targetResponderRecipes").appendPathParam(request.getTargetResponderRecipeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteTargetResponderRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ExecuteResponderExecutionResponse executeResponderExecution(ExecuteResponderExecutionRequest request) {
        Validate.notBlank((String)request.getResponderExecutionId(), (String)"responderExecutionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ExecuteResponderExecutionResponse)this.clientCall(request, ExecuteResponderExecutionResponse::builder).logger(LOG, "executeResponderExecution").serviceDetails("CloudGuard", "ExecuteResponderExecution", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResponderExecution/ExecuteResponderExecution").method(Method.POST).requestBuilder(ExecuteResponderExecutionRequest::builder).basePath("/20200131").appendPathParam("responderExecutions").appendPathParam(request.getResponderExecutionId()).appendPathParam("actions").appendPathParam("execute").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ExecuteResponderExecutionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetConditionMetadataTypeResponse getConditionMetadataType(GetConditionMetadataTypeRequest request) {
        Validate.notBlank((String)request.getConditionMetadataTypeId().getValue(), (String)"conditionMetadataTypeId must not be blank", (Object[])new Object[0]);
        return (GetConditionMetadataTypeResponse)this.clientCall(request, GetConditionMetadataTypeResponse::builder).logger(LOG, "getConditionMetadataType").serviceDetails("CloudGuard", "GetConditionMetadataType", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ConditionMetadataType/GetConditionMetadataType").method(Method.GET).requestBuilder(GetConditionMetadataTypeRequest::builder).basePath("/20200131").appendPathParam("conditionMetadataTypes").appendPathParam(request.getConditionMetadataTypeId().getValue()).appendQueryParam("serviceType", (Object)request.getServiceType()).appendQueryParam("resourceType", (Object)request.getResourceType()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConditionMetadataType.class, GetConditionMetadataTypeResponse.Builder::conditionMetadataType).handleResponseHeaderString("etag", GetConditionMetadataTypeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetConditionMetadataTypeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetConfigurationResponse getConfiguration(GetConfigurationRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (GetConfigurationResponse)this.clientCall(request, GetConfigurationResponse::builder).logger(LOG, "getConfiguration").serviceDetails("CloudGuard", "GetConfiguration", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/Configuration/GetConfiguration").method(Method.GET).requestBuilder(GetConfigurationRequest::builder).basePath("/20200131").appendPathParam("configuration").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Configuration.class, GetConfigurationResponse.Builder::configuration).handleResponseHeaderString("etag", GetConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetConfigurationResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetConfigurationResponse.Builder::retryAfter).callSync();
    }

    @Override
    public GetDataMaskRuleResponse getDataMaskRule(GetDataMaskRuleRequest request) {
        Validate.notBlank((String)request.getDataMaskRuleId(), (String)"dataMaskRuleId must not be blank", (Object[])new Object[0]);
        return (GetDataMaskRuleResponse)this.clientCall(request, GetDataMaskRuleResponse::builder).logger(LOG, "getDataMaskRule").serviceDetails("CloudGuard", "GetDataMaskRule", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DataMaskRule/GetDataMaskRule").method(Method.GET).requestBuilder(GetDataMaskRuleRequest::builder).basePath("/20200131").appendPathParam("dataMaskRules").appendPathParam(request.getDataMaskRuleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataMaskRule.class, GetDataMaskRuleResponse.Builder::dataMaskRule).handleResponseHeaderString("etag", GetDataMaskRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDataMaskRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDataSourceResponse getDataSource(GetDataSourceRequest request) {
        Validate.notBlank((String)request.getDataSourceId(), (String)"dataSourceId must not be blank", (Object[])new Object[0]);
        return (GetDataSourceResponse)this.clientCall(request, GetDataSourceResponse::builder).logger(LOG, "getDataSource").serviceDetails("CloudGuard", "GetDataSource", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DataSource/GetDataSource").method(Method.GET).requestBuilder(GetDataSourceRequest::builder).basePath("/20200131").appendPathParam("dataSources").appendPathParam(request.getDataSourceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataSource.class, GetDataSourceResponse.Builder::dataSource).handleResponseHeaderString("etag", GetDataSourceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDataSourceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDetectorResponse getDetector(GetDetectorRequest request) {
        Validate.notBlank((String)request.getDetectorId(), (String)"detectorId must not be blank", (Object[])new Object[0]);
        return (GetDetectorResponse)this.clientCall(request, GetDetectorResponse::builder).logger(LOG, "getDetector").serviceDetails("CloudGuard", "GetDetector", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/Detector/GetDetector").method(Method.GET).requestBuilder(GetDetectorRequest::builder).basePath("/20200131").appendPathParam("detectors").appendPathParam(request.getDetectorId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Detector.class, GetDetectorResponse.Builder::detector).handleResponseHeaderString("opc-request-id", GetDetectorResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", GetDetectorResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public GetDetectorRecipeResponse getDetectorRecipe(GetDetectorRecipeRequest request) {
        Validate.notBlank((String)request.getDetectorRecipeId(), (String)"detectorRecipeId must not be blank", (Object[])new Object[0]);
        return (GetDetectorRecipeResponse)this.clientCall(request, GetDetectorRecipeResponse::builder).logger(LOG, "getDetectorRecipe").serviceDetails("CloudGuard", "GetDetectorRecipe", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DetectorRecipe/GetDetectorRecipe").method(Method.GET).requestBuilder(GetDetectorRecipeRequest::builder).basePath("/20200131").appendPathParam("detectorRecipes").appendPathParam(request.getDetectorRecipeId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DetectorRecipe.class, GetDetectorRecipeResponse.Builder::detectorRecipe).handleResponseHeaderString("etag", GetDetectorRecipeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDetectorRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDetectorRecipeDetectorRuleResponse getDetectorRecipeDetectorRule(GetDetectorRecipeDetectorRuleRequest request) {
        Validate.notBlank((String)request.getDetectorRecipeId(), (String)"detectorRecipeId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDetectorRuleId(), (String)"detectorRuleId must not be blank", (Object[])new Object[0]);
        return (GetDetectorRecipeDetectorRuleResponse)this.clientCall(request, GetDetectorRecipeDetectorRuleResponse::builder).logger(LOG, "getDetectorRecipeDetectorRule").serviceDetails("CloudGuard", "GetDetectorRecipeDetectorRule", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DetectorRecipeDetectorRule/GetDetectorRecipeDetectorRule").method(Method.GET).requestBuilder(GetDetectorRecipeDetectorRuleRequest::builder).basePath("/20200131").appendPathParam("detectorRecipes").appendPathParam(request.getDetectorRecipeId()).appendPathParam("detectorRules").appendPathParam(request.getDetectorRuleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DetectorRecipeDetectorRule.class, GetDetectorRecipeDetectorRuleResponse.Builder::detectorRecipeDetectorRule).handleResponseHeaderString("etag", GetDetectorRecipeDetectorRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDetectorRecipeDetectorRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDetectorRuleResponse getDetectorRule(GetDetectorRuleRequest request) {
        Validate.notBlank((String)request.getDetectorId(), (String)"detectorId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDetectorRuleId(), (String)"detectorRuleId must not be blank", (Object[])new Object[0]);
        return (GetDetectorRuleResponse)this.clientCall(request, GetDetectorRuleResponse::builder).logger(LOG, "getDetectorRule").serviceDetails("CloudGuard", "GetDetectorRule", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DetectorRule/GetDetectorRule").method(Method.GET).requestBuilder(GetDetectorRuleRequest::builder).basePath("/20200131").appendPathParam("detectors").appendPathParam(request.getDetectorId()).appendPathParam("detectorRules").appendPathParam(request.getDetectorRuleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DetectorRule.class, GetDetectorRuleResponse.Builder::detectorRule).handleResponseHeaderString("etag", GetDetectorRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDetectorRuleResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", GetDetectorRuleResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public GetManagedListResponse getManagedList(GetManagedListRequest request) {
        Validate.notBlank((String)request.getManagedListId(), (String)"managedListId must not be blank", (Object[])new Object[0]);
        return (GetManagedListResponse)this.clientCall(request, GetManagedListResponse::builder).logger(LOG, "getManagedList").serviceDetails("CloudGuard", "GetManagedList", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ManagedList/GetManagedList").method(Method.GET).requestBuilder(GetManagedListRequest::builder).basePath("/20200131").appendPathParam("managedLists").appendPathParam(request.getManagedListId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagedList.class, GetManagedListResponse.Builder::managedList).handleResponseHeaderString("opc-request-id", GetManagedListResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetManagedListResponse.Builder::etag).callSync();
    }

    @Override
    public GetProblemResponse getProblem(GetProblemRequest request) {
        Validate.notBlank((String)request.getProblemId(), (String)"problemId must not be blank", (Object[])new Object[0]);
        return (GetProblemResponse)this.clientCall(request, GetProblemResponse::builder).logger(LOG, "getProblem").serviceDetails("CloudGuard", "GetProblem", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/Problem/GetProblem").method(Method.GET).requestBuilder(GetProblemRequest::builder).basePath("/20200131").appendPathParam("problems").appendPathParam(request.getProblemId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Problem.class, GetProblemResponse.Builder::problem).handleResponseHeaderString("opc-request-id", GetProblemResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetProblemResponse.Builder::etag).callSync();
    }

    @Override
    public GetResourceProfileResponse getResourceProfile(GetResourceProfileRequest request) {
        Validate.notBlank((String)request.getResourceProfileId(), (String)"resourceProfileId must not be blank", (Object[])new Object[0]);
        return (GetResourceProfileResponse)this.clientCall(request, GetResourceProfileResponse::builder).logger(LOG, "getResourceProfile").serviceDetails("CloudGuard", "GetResourceProfile", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResourceProfile/GetResourceProfile").method(Method.GET).requestBuilder(GetResourceProfileRequest::builder).basePath("/20200131").appendPathParam("resourceProfiles").appendPathParam(request.getResourceProfileId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResourceProfile.class, GetResourceProfileResponse.Builder::resourceProfile).handleResponseHeaderString("opc-request-id", GetResourceProfileResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetResourceProfileResponse.Builder::etag).callSync();
    }

    @Override
    public GetResponderExecutionResponse getResponderExecution(GetResponderExecutionRequest request) {
        Validate.notBlank((String)request.getResponderExecutionId(), (String)"responderExecutionId must not be blank", (Object[])new Object[0]);
        return (GetResponderExecutionResponse)this.clientCall(request, GetResponderExecutionResponse::builder).logger(LOG, "getResponderExecution").serviceDetails("CloudGuard", "GetResponderExecution", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResponderExecution/GetResponderExecution").method(Method.GET).requestBuilder(GetResponderExecutionRequest::builder).basePath("/20200131").appendPathParam("responderExecutions").appendPathParam(request.getResponderExecutionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResponderExecution.class, GetResponderExecutionResponse.Builder::responderExecution).handleResponseHeaderString("etag", GetResponderExecutionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetResponderExecutionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetResponderRecipeResponse getResponderRecipe(GetResponderRecipeRequest request) {
        Validate.notBlank((String)request.getResponderRecipeId(), (String)"responderRecipeId must not be blank", (Object[])new Object[0]);
        return (GetResponderRecipeResponse)this.clientCall(request, GetResponderRecipeResponse::builder).logger(LOG, "getResponderRecipe").serviceDetails("CloudGuard", "GetResponderRecipe", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResponderRecipe/GetResponderRecipe").method(Method.GET).requestBuilder(GetResponderRecipeRequest::builder).basePath("/20200131").appendPathParam("responderRecipes").appendPathParam(request.getResponderRecipeId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResponderRecipe.class, GetResponderRecipeResponse.Builder::responderRecipe).handleResponseHeaderString("etag", GetResponderRecipeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetResponderRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetResponderRecipeResponderRuleResponse getResponderRecipeResponderRule(GetResponderRecipeResponderRuleRequest request) {
        Validate.notBlank((String)request.getResponderRecipeId(), (String)"responderRecipeId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getResponderRuleId(), (String)"responderRuleId must not be blank", (Object[])new Object[0]);
        return (GetResponderRecipeResponderRuleResponse)this.clientCall(request, GetResponderRecipeResponderRuleResponse::builder).logger(LOG, "getResponderRecipeResponderRule").serviceDetails("CloudGuard", "GetResponderRecipeResponderRule", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResponderRecipeResponderRule/GetResponderRecipeResponderRule").method(Method.GET).requestBuilder(GetResponderRecipeResponderRuleRequest::builder).basePath("/20200131").appendPathParam("responderRecipes").appendPathParam(request.getResponderRecipeId()).appendPathParam("responderRules").appendPathParam(request.getResponderRuleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResponderRecipeResponderRule.class, GetResponderRecipeResponderRuleResponse.Builder::responderRecipeResponderRule).handleResponseHeaderString("etag", GetResponderRecipeResponderRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetResponderRecipeResponderRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetResponderRuleResponse getResponderRule(GetResponderRuleRequest request) {
        Validate.notBlank((String)request.getResponderRuleId(), (String)"responderRuleId must not be blank", (Object[])new Object[0]);
        return (GetResponderRuleResponse)this.clientCall(request, GetResponderRuleResponse::builder).logger(LOG, "getResponderRule").serviceDetails("CloudGuard", "GetResponderRule", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResponderRule/GetResponderRule").method(Method.GET).requestBuilder(GetResponderRuleRequest::builder).basePath("/20200131").appendPathParam("responderRules").appendPathParam(request.getResponderRuleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResponderRule.class, GetResponderRuleResponse.Builder::responderRule).handleResponseHeaderString("etag", GetResponderRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetResponderRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetSecurityPolicyResponse getSecurityPolicy(GetSecurityPolicyRequest request) {
        Validate.notBlank((String)request.getSecurityPolicyId(), (String)"securityPolicyId must not be blank", (Object[])new Object[0]);
        return (GetSecurityPolicyResponse)this.clientCall(request, GetSecurityPolicyResponse::builder).logger(LOG, "getSecurityPolicy").serviceDetails("CloudGuard", "GetSecurityPolicy", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/SecurityPolicy/GetSecurityPolicy").method(Method.GET).requestBuilder(GetSecurityPolicyRequest::builder).basePath("/20200131").appendPathParam("securityPolicies").appendPathParam(request.getSecurityPolicyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SecurityPolicy.class, GetSecurityPolicyResponse.Builder::securityPolicy).handleResponseHeaderString("etag", GetSecurityPolicyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSecurityPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetSecurityRecipeResponse getSecurityRecipe(GetSecurityRecipeRequest request) {
        Validate.notBlank((String)request.getSecurityRecipeId(), (String)"securityRecipeId must not be blank", (Object[])new Object[0]);
        return (GetSecurityRecipeResponse)this.clientCall(request, GetSecurityRecipeResponse::builder).logger(LOG, "getSecurityRecipe").serviceDetails("CloudGuard", "GetSecurityRecipe", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/SecurityRecipe/GetSecurityRecipe").method(Method.GET).requestBuilder(GetSecurityRecipeRequest::builder).basePath("/20200131").appendPathParam("securityRecipes").appendPathParam(request.getSecurityRecipeId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SecurityRecipe.class, GetSecurityRecipeResponse.Builder::securityRecipe).handleResponseHeaderString("etag", GetSecurityRecipeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSecurityRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetSecurityZoneResponse getSecurityZone(GetSecurityZoneRequest request) {
        Validate.notBlank((String)request.getSecurityZoneId(), (String)"securityZoneId must not be blank", (Object[])new Object[0]);
        return (GetSecurityZoneResponse)this.clientCall(request, GetSecurityZoneResponse::builder).logger(LOG, "getSecurityZone").serviceDetails("CloudGuard", "GetSecurityZone", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/SecurityZone/GetSecurityZone").method(Method.GET).requestBuilder(GetSecurityZoneRequest::builder).basePath("/20200131").appendPathParam("securityZones").appendPathParam(request.getSecurityZoneId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SecurityZone.class, GetSecurityZoneResponse.Builder::securityZone).handleResponseHeaderString("etag", GetSecurityZoneResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSecurityZoneResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetSightingResponse getSighting(GetSightingRequest request) {
        Validate.notBlank((String)request.getSightingId(), (String)"sightingId must not be blank", (Object[])new Object[0]);
        return (GetSightingResponse)this.clientCall(request, GetSightingResponse::builder).logger(LOG, "getSighting").serviceDetails("CloudGuard", "GetSighting", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/Sighting/GetSighting").method(Method.GET).requestBuilder(GetSightingRequest::builder).basePath("/20200131").appendPathParam("sightings").appendPathParam(request.getSightingId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Sighting.class, GetSightingResponse.Builder::sighting).handleResponseHeaderString("opc-request-id", GetSightingResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetSightingResponse.Builder::etag).callSync();
    }

    @Override
    public GetTargetResponse getTarget(GetTargetRequest request) {
        Validate.notBlank((String)request.getTargetId(), (String)"targetId must not be blank", (Object[])new Object[0]);
        return (GetTargetResponse)this.clientCall(request, GetTargetResponse::builder).logger(LOG, "getTarget").serviceDetails("CloudGuard", "GetTarget", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/Target/GetTarget").method(Method.GET).requestBuilder(GetTargetRequest::builder).basePath("/20200131").appendPathParam("targets").appendPathParam(request.getTargetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Target.class, GetTargetResponse.Builder::target).handleResponseHeaderString("etag", GetTargetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetTargetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetTargetDetectorRecipeResponse getTargetDetectorRecipe(GetTargetDetectorRecipeRequest request) {
        Validate.notBlank((String)request.getTargetId(), (String)"targetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTargetDetectorRecipeId(), (String)"targetDetectorRecipeId must not be blank", (Object[])new Object[0]);
        return (GetTargetDetectorRecipeResponse)this.clientCall(request, GetTargetDetectorRecipeResponse::builder).logger(LOG, "getTargetDetectorRecipe").serviceDetails("CloudGuard", "GetTargetDetectorRecipe", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/TargetDetectorRecipe/GetTargetDetectorRecipe").method(Method.GET).requestBuilder(GetTargetDetectorRecipeRequest::builder).basePath("/20200131").appendPathParam("targets").appendPathParam(request.getTargetId()).appendPathParam("targetDetectorRecipes").appendPathParam(request.getTargetDetectorRecipeId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TargetDetectorRecipe.class, GetTargetDetectorRecipeResponse.Builder::targetDetectorRecipe).handleResponseHeaderString("etag", GetTargetDetectorRecipeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetTargetDetectorRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetTargetDetectorRecipeDetectorRuleResponse getTargetDetectorRecipeDetectorRule(GetTargetDetectorRecipeDetectorRuleRequest request) {
        Validate.notBlank((String)request.getTargetId(), (String)"targetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTargetDetectorRecipeId(), (String)"targetDetectorRecipeId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDetectorRuleId(), (String)"detectorRuleId must not be blank", (Object[])new Object[0]);
        return (GetTargetDetectorRecipeDetectorRuleResponse)this.clientCall(request, GetTargetDetectorRecipeDetectorRuleResponse::builder).logger(LOG, "getTargetDetectorRecipeDetectorRule").serviceDetails("CloudGuard", "GetTargetDetectorRecipeDetectorRule", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/TargetDetectorRecipeDetectorRule/GetTargetDetectorRecipeDetectorRule").method(Method.GET).requestBuilder(GetTargetDetectorRecipeDetectorRuleRequest::builder).basePath("/20200131").appendPathParam("targets").appendPathParam(request.getTargetId()).appendPathParam("targetDetectorRecipes").appendPathParam(request.getTargetDetectorRecipeId()).appendPathParam("detectorRules").appendPathParam(request.getDetectorRuleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TargetDetectorRecipeDetectorRule.class, GetTargetDetectorRecipeDetectorRuleResponse.Builder::targetDetectorRecipeDetectorRule).handleResponseHeaderString("etag", GetTargetDetectorRecipeDetectorRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetTargetDetectorRecipeDetectorRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetTargetResponderRecipeResponse getTargetResponderRecipe(GetTargetResponderRecipeRequest request) {
        Validate.notBlank((String)request.getTargetId(), (String)"targetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTargetResponderRecipeId(), (String)"targetResponderRecipeId must not be blank", (Object[])new Object[0]);
        return (GetTargetResponderRecipeResponse)this.clientCall(request, GetTargetResponderRecipeResponse::builder).logger(LOG, "getTargetResponderRecipe").serviceDetails("CloudGuard", "GetTargetResponderRecipe", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/TargetResponderRecipe/GetTargetResponderRecipe").method(Method.GET).requestBuilder(GetTargetResponderRecipeRequest::builder).basePath("/20200131").appendPathParam("targets").appendPathParam(request.getTargetId()).appendPathParam("targetResponderRecipes").appendPathParam(request.getTargetResponderRecipeId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TargetResponderRecipe.class, GetTargetResponderRecipeResponse.Builder::targetResponderRecipe).handleResponseHeaderString("etag", GetTargetResponderRecipeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetTargetResponderRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetTargetResponderRecipeResponderRuleResponse getTargetResponderRecipeResponderRule(GetTargetResponderRecipeResponderRuleRequest request) {
        Validate.notBlank((String)request.getTargetId(), (String)"targetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTargetResponderRecipeId(), (String)"targetResponderRecipeId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getResponderRuleId(), (String)"responderRuleId must not be blank", (Object[])new Object[0]);
        return (GetTargetResponderRecipeResponderRuleResponse)this.clientCall(request, GetTargetResponderRecipeResponderRuleResponse::builder).logger(LOG, "getTargetResponderRecipeResponderRule").serviceDetails("CloudGuard", "GetTargetResponderRecipeResponderRule", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/TargetResponderRecipeResponderRule/GetTargetResponderRecipeResponderRule").method(Method.GET).requestBuilder(GetTargetResponderRecipeResponderRuleRequest::builder).basePath("/20200131").appendPathParam("targets").appendPathParam(request.getTargetId()).appendPathParam("targetResponderRecipes").appendPathParam(request.getTargetResponderRecipeId()).appendPathParam("responderRules").appendPathParam(request.getResponderRuleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TargetResponderRecipeResponderRule.class, GetTargetResponderRecipeResponderRuleResponse.Builder::targetResponderRecipeResponderRule).handleResponseHeaderString("etag", GetTargetResponderRecipeResponderRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetTargetResponderRecipeResponderRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("CloudGuard", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20200131").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListConditionMetadataTypesResponse listConditionMetadataTypes(ListConditionMetadataTypesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListConditionMetadataTypesResponse)this.clientCall(request, ListConditionMetadataTypesResponse::builder).logger(LOG, "listConditionMetadataTypes").serviceDetails("CloudGuard", "ListConditionMetadataTypes", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ConditionMetadataType/ListConditionMetadataTypes").method(Method.GET).requestBuilder(ListConditionMetadataTypesRequest::builder).basePath("/20200131").appendPathParam("conditionMetadataTypes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConditionMetadataTypeCollection.class, ListConditionMetadataTypesResponse.Builder::conditionMetadataTypeCollection).handleResponseHeaderString("opc-request-id", ListConditionMetadataTypesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListConditionMetadataTypesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDataMaskRulesResponse listDataMaskRules(ListDataMaskRulesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDataMaskRulesResponse)this.clientCall(request, ListDataMaskRulesResponse::builder).logger(LOG, "listDataMaskRules").serviceDetails("CloudGuard", "ListDataMaskRules", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DataMaskRule/ListDataMaskRules").method(Method.GET).requestBuilder(ListDataMaskRulesRequest::builder).basePath("/20200131").appendPathParam("dataMaskRules").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("accessLevel", (BmcEnum)request.getAccessLevel()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("dataMaskRuleStatus", (BmcEnum)request.getDataMaskRuleStatus()).appendQueryParam("targetId", (Object)request.getTargetId()).appendQueryParam("iamGroupId", (Object)request.getIamGroupId()).appendQueryParam("targetType", (Object)request.getTargetType()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataMaskRuleCollection.class, ListDataMaskRulesResponse.Builder::dataMaskRuleCollection).handleResponseHeaderString("opc-request-id", ListDataMaskRulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDataMaskRulesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDataSourceEventsResponse listDataSourceEvents(ListDataSourceEventsRequest request) {
        Validate.notBlank((String)request.getDataSourceId(), (String)"dataSourceId must not be blank", (Object[])new Object[0]);
        return (ListDataSourceEventsResponse)this.clientCall(request, ListDataSourceEventsResponse::builder).logger(LOG, "listDataSourceEvents").serviceDetails("CloudGuard", "ListDataSourceEvents", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DataSource/ListDataSourceEvents").method(Method.GET).requestBuilder(ListDataSourceEventsRequest::builder).basePath("/20200131").appendPathParam("dataSources").appendPathParam(request.getDataSourceId()).appendPathParam("events").appendQueryParam("region", (Object)request.getRegion()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataSourceEventCollection.class, ListDataSourceEventsResponse.Builder::dataSourceEventCollection).handleResponseHeaderString("opc-request-id", ListDataSourceEventsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDataSourceEventsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDataSourcesResponse listDataSources(ListDataSourcesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDataSourcesResponse)this.clientCall(request, ListDataSourcesResponse::builder).logger(LOG, "listDataSources").serviceDetails("CloudGuard", "ListDataSources", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DataSource/ListDataSources").method(Method.GET).requestBuilder(ListDataSourcesRequest::builder).basePath("/20200131").appendPathParam("dataSources").appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("dataSourceFeedProvider", (BmcEnum)request.getDataSourceFeedProvider()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("loggingQueryType", (BmcEnum)request.getLoggingQueryType()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendEnumQueryParam("accessLevel", (BmcEnum)request.getAccessLevel()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataSourceCollection.class, ListDataSourcesResponse.Builder::dataSourceCollection).handleResponseHeaderString("opc-request-id", ListDataSourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDataSourcesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDetectorRecipeDetectorRulesResponse listDetectorRecipeDetectorRules(ListDetectorRecipeDetectorRulesRequest request) {
        Validate.notBlank((String)request.getDetectorRecipeId(), (String)"detectorRecipeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDetectorRecipeDetectorRulesResponse)this.clientCall(request, ListDetectorRecipeDetectorRulesResponse::builder).logger(LOG, "listDetectorRecipeDetectorRules").serviceDetails("CloudGuard", "ListDetectorRecipeDetectorRules", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DetectorRecipeDetectorRule/ListDetectorRecipeDetectorRules").method(Method.GET).requestBuilder(ListDetectorRecipeDetectorRulesRequest::builder).basePath("/20200131").appendPathParam("detectorRecipes").appendPathParam(request.getDetectorRecipeId()).appendPathParam("detectorRules").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DetectorRecipeDetectorRuleCollection.class, ListDetectorRecipeDetectorRulesResponse.Builder::detectorRecipeDetectorRuleCollection).handleResponseHeaderString("opc-request-id", ListDetectorRecipeDetectorRulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDetectorRecipeDetectorRulesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDetectorRecipesResponse listDetectorRecipes(ListDetectorRecipesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDetectorRecipesResponse)this.clientCall(request, ListDetectorRecipesResponse::builder).logger(LOG, "listDetectorRecipes").serviceDetails("CloudGuard", "ListDetectorRecipes", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DetectorRecipe/ListDetectorRecipes").method(Method.GET).requestBuilder(ListDetectorRecipesRequest::builder).basePath("/20200131").appendPathParam("detectorRecipes").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("resourceMetadataOnly", (Object)request.getResourceMetadataOnly()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendEnumQueryParam("accessLevel", (BmcEnum)request.getAccessLevel()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DetectorRecipeCollection.class, ListDetectorRecipesResponse.Builder::detectorRecipeCollection).handleResponseHeaderString("opc-request-id", ListDetectorRecipesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDetectorRecipesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDetectorRulesResponse listDetectorRules(ListDetectorRulesRequest request) {
        Validate.notBlank((String)request.getDetectorId(), (String)"detectorId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDetectorRulesResponse)this.clientCall(request, ListDetectorRulesResponse::builder).logger(LOG, "listDetectorRules").serviceDetails("CloudGuard", "ListDetectorRules", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DetectorRule/ListDetectorRules").method(Method.GET).requestBuilder(ListDetectorRulesRequest::builder).basePath("/20200131").appendPathParam("detectors").appendPathParam(request.getDetectorId()).appendPathParam("detectorRules").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DetectorRuleCollection.class, ListDetectorRulesResponse.Builder::detectorRuleCollection).handleResponseHeaderString("opc-request-id", ListDetectorRulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDetectorRulesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDetectorsResponse listDetectors(ListDetectorsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDetectorsResponse)this.clientCall(request, ListDetectorsResponse::builder).logger(LOG, "listDetectors").serviceDetails("CloudGuard", "ListDetectors", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/Detector/ListDetectors").method(Method.GET).requestBuilder(ListDetectorsRequest::builder).basePath("/20200131").appendPathParam("detectors").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DetectorCollection.class, ListDetectorsResponse.Builder::detectorCollection).handleResponseHeaderString("opc-request-id", ListDetectorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDetectorsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListImpactedResourcesResponse listImpactedResources(ListImpactedResourcesRequest request) {
        Validate.notBlank((String)request.getProblemId(), (String)"problemId must not be blank", (Object[])new Object[0]);
        return (ListImpactedResourcesResponse)this.clientCall(request, ListImpactedResourcesResponse::builder).logger(LOG, "listImpactedResources").serviceDetails("CloudGuard", "ListImpactedResources", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ImpactedResourceSummary/ListImpactedResources").method(Method.GET).requestBuilder(ListImpactedResourcesRequest::builder).basePath("/20200131").appendPathParam("problems").appendPathParam(request.getProblemId()).appendPathParam("impactedResources").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ImpactedResourceCollection.class, ListImpactedResourcesResponse.Builder::impactedResourceCollection).handleResponseHeaderString("opc-request-id", ListImpactedResourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListImpactedResourcesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListManagedListTypesResponse listManagedListTypes(ListManagedListTypesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListManagedListTypesResponse)this.clientCall(request, ListManagedListTypesResponse::builder).logger(LOG, "listManagedListTypes").serviceDetails("CloudGuard", "ListManagedListTypes", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ManagedListTypeSummary/ListManagedListTypes").method(Method.GET).requestBuilder(ListManagedListTypesRequest::builder).basePath("/20200131").appendPathParam("managedListTypes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagedListTypeCollection.class, ListManagedListTypesResponse.Builder::managedListTypeCollection).handleResponseHeaderString("opc-request-id", ListManagedListTypesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedListTypesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListManagedListsResponse listManagedLists(ListManagedListsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListManagedListsResponse)this.clientCall(request, ListManagedListsResponse::builder).logger(LOG, "listManagedLists").serviceDetails("CloudGuard", "ListManagedLists", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ManagedList/ListManagedLists").method(Method.GET).requestBuilder(ListManagedListsRequest::builder).basePath("/20200131").appendPathParam("managedLists").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("resourceMetadataOnly", (Object)request.getResourceMetadataOnly()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("listType", (BmcEnum)request.getListType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendEnumQueryParam("accessLevel", (BmcEnum)request.getAccessLevel()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagedListCollection.class, ListManagedListsResponse.Builder::managedListCollection).handleResponseHeaderString("opc-request-id", ListManagedListsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedListsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListPoliciesResponse listPolicies(ListPoliciesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListPoliciesResponse)this.clientCall(request, ListPoliciesResponse::builder).logger(LOG, "listPolicies").serviceDetails("CloudGuard", "ListPolicies", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/PolicySummary/ListPolicies").method(Method.GET).requestBuilder(ListPoliciesRequest::builder).basePath("/20200131").appendPathParam("policies").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PolicyCollection.class, ListPoliciesResponse.Builder::policyCollection).handleResponseHeaderString("opc-request-id", ListPoliciesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPoliciesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListProblemEndpointsResponse listProblemEndpoints(ListProblemEndpointsRequest request) {
        Validate.notBlank((String)request.getProblemId(), (String)"problemId must not be blank", (Object[])new Object[0]);
        return (ListProblemEndpointsResponse)this.clientCall(request, ListProblemEndpointsResponse::builder).logger(LOG, "listProblemEndpoints").serviceDetails("CloudGuard", "ListProblemEndpoints", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ProblemEndpointSummary/ListProblemEndpoints").method(Method.GET).requestBuilder(ListProblemEndpointsRequest::builder).basePath("/20200131").appendPathParam("problems").appendPathParam(request.getProblemId()).appendPathParam("endpoints").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProblemEndpointCollection.class, ListProblemEndpointsResponse.Builder::problemEndpointCollection).handleResponseHeaderString("opc-request-id", ListProblemEndpointsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProblemEndpointsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListProblemEntitiesResponse listProblemEntities(ListProblemEntitiesRequest request) {
        Validate.notBlank((String)request.getProblemId(), (String)"problemId must not be blank", (Object[])new Object[0]);
        return (ListProblemEntitiesResponse)this.clientCall(request, ListProblemEntitiesResponse::builder).logger(LOG, "listProblemEntities").serviceDetails("CloudGuard", "ListProblemEntities", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/Problem/ListProblemEntities").method(Method.GET).requestBuilder(ListProblemEntitiesRequest::builder).basePath("/20200131").appendPathParam("problems").appendPathParam(request.getProblemId()).appendPathParam("entities").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProblemEntityCollection.class, ListProblemEntitiesResponse.Builder::problemEntityCollection).handleResponseHeaderString("opc-request-id", ListProblemEntitiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProblemEntitiesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListProblemHistoriesResponse listProblemHistories(ListProblemHistoriesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getProblemId(), (String)"problemId must not be blank", (Object[])new Object[0]);
        return (ListProblemHistoriesResponse)this.clientCall(request, ListProblemHistoriesResponse::builder).logger(LOG, "listProblemHistories").serviceDetails("CloudGuard", "ListProblemHistories", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/Problem/ListProblemHistories").method(Method.GET).requestBuilder(ListProblemHistoriesRequest::builder).basePath("/20200131").appendPathParam("problems").appendPathParam(request.getProblemId()).appendPathParam("histories").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProblemHistoryCollection.class, ListProblemHistoriesResponse.Builder::problemHistoryCollection).handleResponseHeaderString("opc-request-id", ListProblemHistoriesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProblemHistoriesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListProblemsResponse listProblems(ListProblemsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListProblemsResponse)this.clientCall(request, ListProblemsResponse::builder).logger(LOG, "listProblems").serviceDetails("CloudGuard", "ListProblems", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/Problem/ListProblems").method(Method.GET).requestBuilder(ListProblemsRequest::builder).basePath("/20200131").appendPathParam("problems").appendQueryParam("timeLastDetectedGreaterThanOrEqualTo", (Object)request.getTimeLastDetectedGreaterThanOrEqualTo()).appendQueryParam("timeLastDetectedLessThanOrEqualTo", (Object)request.getTimeLastDetectedLessThanOrEqualTo()).appendQueryParam("timeFirstDetectedGreaterThanOrEqualTo", (Object)request.getTimeFirstDetectedGreaterThanOrEqualTo()).appendQueryParam("timeFirstDetectedLessThanOrEqualTo", (Object)request.getTimeFirstDetectedLessThanOrEqualTo()).appendEnumQueryParam("lifecycleDetail", (BmcEnum)request.getLifecycleDetail()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("region", (Object)request.getRegion()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("riskLevel", (Object)request.getRiskLevel()).appendQueryParam("resourceType", (Object)request.getResourceType()).appendQueryParam("city", (Object)request.getCity()).appendQueryParam("state", (Object)request.getState()).appendQueryParam("country", (Object)request.getCountry()).appendQueryParam("label", (Object)request.getLabel()).appendListQueryParam("detectorRuleIdList", request.getDetectorRuleIdList(), CollectionFormatType.Multi).appendEnumQueryParam("detectorType", (BmcEnum)request.getDetectorType()).appendQueryParam("targetId", (Object)request.getTargetId()).appendEnumQueryParam("problemCategory", (BmcEnum)request.getProblemCategory()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendEnumQueryParam("accessLevel", (BmcEnum)request.getAccessLevel()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProblemCollection.class, ListProblemsResponse.Builder::problemCollection).handleResponseHeaderString("opc-request-id", ListProblemsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProblemsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListRecommendationsResponse listRecommendations(ListRecommendationsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListRecommendationsResponse)this.clientCall(request, ListRecommendationsResponse::builder).logger(LOG, "listRecommendations").serviceDetails("CloudGuard", "ListRecommendations", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/RecommendationSummary/ListRecommendations").method(Method.GET).requestBuilder(ListRecommendationsRequest::builder).basePath("/20200131").appendPathParam("recommendations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("targetId", (Object)request.getTargetId()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendEnumQueryParam("accessLevel", (BmcEnum)request.getAccessLevel()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("lifecycleDetail", (BmcEnum)request.getLifecycleDetail()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RecommendationSummaryCollection.class, ListRecommendationsResponse.Builder::recommendationSummaryCollection).handleResponseHeaderString("opc-request-id", ListRecommendationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRecommendationsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListResourceProfileEndpointsResponse listResourceProfileEndpoints(ListResourceProfileEndpointsRequest request) {
        Validate.notBlank((String)request.getResourceProfileId(), (String)"resourceProfileId must not be blank", (Object[])new Object[0]);
        return (ListResourceProfileEndpointsResponse)this.clientCall(request, ListResourceProfileEndpointsResponse::builder).logger(LOG, "listResourceProfileEndpoints").serviceDetails("CloudGuard", "ListResourceProfileEndpoints", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResourceProfileEndpointSummary/ListResourceProfileEndpoints").method(Method.GET).requestBuilder(ListResourceProfileEndpointsRequest::builder).basePath("/20200131").appendPathParam("resourceProfiles").appendPathParam(request.getResourceProfileId()).appendPathParam("endpoints").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResourceProfileEndpointCollection.class, ListResourceProfileEndpointsResponse.Builder::resourceProfileEndpointCollection).handleResponseHeaderString("opc-request-id", ListResourceProfileEndpointsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListResourceProfileEndpointsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListResourceProfileImpactedResourcesResponse listResourceProfileImpactedResources(ListResourceProfileImpactedResourcesRequest request) {
        Validate.notBlank((String)request.getResourceProfileId(), (String)"resourceProfileId must not be blank", (Object[])new Object[0]);
        return (ListResourceProfileImpactedResourcesResponse)this.clientCall(request, ListResourceProfileImpactedResourcesResponse::builder).logger(LOG, "listResourceProfileImpactedResources").serviceDetails("CloudGuard", "ListResourceProfileImpactedResources", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResourceProfileImpactedResourceSummary/ListResourceProfileImpactedResources").method(Method.GET).requestBuilder(ListResourceProfileImpactedResourcesRequest::builder).basePath("/20200131").appendPathParam("resourceProfiles").appendPathParam(request.getResourceProfileId()).appendPathParam("impactedResources").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResourceProfileImpactedResourceCollection.class, ListResourceProfileImpactedResourcesResponse.Builder::resourceProfileImpactedResourceCollection).handleResponseHeaderString("opc-request-id", ListResourceProfileImpactedResourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListResourceProfileImpactedResourcesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListResourceProfilesResponse listResourceProfiles(ListResourceProfilesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListResourceProfilesResponse)this.clientCall(request, ListResourceProfilesResponse::builder).logger(LOG, "listResourceProfiles").serviceDetails("CloudGuard", "ListResourceProfiles", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResourceProfileSummary/ListResourceProfiles").method(Method.GET).requestBuilder(ListResourceProfilesRequest::builder).basePath("/20200131").appendPathParam("resourceProfiles").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("timeLastDetectedGreaterThanOrEqualTo", (Object)request.getTimeLastDetectedGreaterThanOrEqualTo()).appendQueryParam("timeLastDetectedLessThanOrEqualTo", (Object)request.getTimeLastDetectedLessThanOrEqualTo()).appendQueryParam("timeFirstDetectedGreaterThanOrEqualTo", (Object)request.getTimeFirstDetectedGreaterThanOrEqualTo()).appendQueryParam("timeFirstDetectedLessThanOrEqualTo", (Object)request.getTimeFirstDetectedLessThanOrEqualTo()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendEnumQueryParam("accessLevel", (BmcEnum)request.getAccessLevel()).appendListQueryParam("resourceTypes", request.getResourceTypes(), CollectionFormatType.Multi).appendQueryParam("riskScoreGreaterThanOrEqualTo", (Object)request.getRiskScoreGreaterThanOrEqualTo()).appendQueryParam("riskScoreLessThanOrEqualTo", (Object)request.getRiskScoreLessThanOrEqualTo()).appendListQueryParam("techniques", request.getTechniques(), CollectionFormatType.Multi).appendListQueryParam("tactics", request.getTactics(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResourceProfileCollection.class, ListResourceProfilesResponse.Builder::resourceProfileCollection).handleResponseHeaderString("opc-request-id", ListResourceProfilesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListResourceProfilesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListResourceTypesResponse listResourceTypes(ListResourceTypesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListResourceTypesResponse)this.clientCall(request, ListResourceTypesResponse::builder).logger(LOG, "listResourceTypes").serviceDetails("CloudGuard", "ListResourceTypes", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResourceTypeSummary/ListResourceTypes").method(Method.GET).requestBuilder(ListResourceTypesRequest::builder).basePath("/20200131").appendPathParam("resourceTypes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("detectorId", (BmcEnum)request.getDetectorId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResourceTypeCollection.class, ListResourceTypesResponse.Builder::resourceTypeCollection).handleResponseHeaderString("opc-request-id", ListResourceTypesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListResourceTypesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListResponderActivitiesResponse listResponderActivities(ListResponderActivitiesRequest request) {
        Validate.notBlank((String)request.getProblemId(), (String)"problemId must not be blank", (Object[])new Object[0]);
        return (ListResponderActivitiesResponse)this.clientCall(request, ListResponderActivitiesResponse::builder).logger(LOG, "listResponderActivities").serviceDetails("CloudGuard", "ListResponderActivities", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResponderActivitySummary/ListResponderActivities").method(Method.GET).requestBuilder(ListResponderActivitiesRequest::builder).basePath("/20200131").appendPathParam("problems").appendPathParam(request.getProblemId()).appendPathParam("responderActivities").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResponderActivityCollection.class, ListResponderActivitiesResponse.Builder::responderActivityCollection).handleResponseHeaderString("opc-request-id", ListResponderActivitiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListResponderActivitiesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListResponderExecutionsResponse listResponderExecutions(ListResponderExecutionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListResponderExecutionsResponse)this.clientCall(request, ListResponderExecutionsResponse::builder).logger(LOG, "listResponderExecutions").serviceDetails("CloudGuard", "ListResponderExecutions", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResponderExecutionSummary/ListResponderExecutions").method(Method.GET).requestBuilder(ListResponderExecutionsRequest::builder).basePath("/20200131").appendPathParam("responderExecutions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendEnumQueryParam("accessLevel", (BmcEnum)request.getAccessLevel()).appendListQueryParam("responderRuleIds", request.getResponderRuleIds(), CollectionFormatType.Multi).appendQueryParam("timeCreatedGreaterThanOrEqualTo", (Object)request.getTimeCreatedGreaterThanOrEqualTo()).appendQueryParam("timeCreatedLessThanOrEqualTo", (Object)request.getTimeCreatedLessThanOrEqualTo()).appendQueryParam("timeCompletedGreaterThanOrEqualTo", (Object)request.getTimeCompletedGreaterThanOrEqualTo()).appendQueryParam("timeCompletedLessThanOrEqualTo", (Object)request.getTimeCompletedLessThanOrEqualTo()).appendQueryParam("targetId", (Object)request.getTargetId()).appendQueryParam("resourceType", (Object)request.getResourceType()).appendEnumQueryParam("responderType", (BmcEnum)request.getResponderType()).appendEnumQueryParam("responderExecutionStatus", (BmcEnum)request.getResponderExecutionStatus()).appendEnumQueryParam("responderExecutionMode", (BmcEnum)request.getResponderExecutionMode()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResponderExecutionCollection.class, ListResponderExecutionsResponse.Builder::responderExecutionCollection).handleResponseHeaderString("opc-request-id", ListResponderExecutionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListResponderExecutionsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListResponderRecipeResponderRulesResponse listResponderRecipeResponderRules(ListResponderRecipeResponderRulesRequest request) {
        Validate.notBlank((String)request.getResponderRecipeId(), (String)"responderRecipeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListResponderRecipeResponderRulesResponse)this.clientCall(request, ListResponderRecipeResponderRulesResponse::builder).logger(LOG, "listResponderRecipeResponderRules").serviceDetails("CloudGuard", "ListResponderRecipeResponderRules", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResponderRecipeResponderRule/ListResponderRecipeResponderRules").method(Method.GET).requestBuilder(ListResponderRecipeResponderRulesRequest::builder).basePath("/20200131").appendPathParam("responderRecipes").appendPathParam(request.getResponderRecipeId()).appendPathParam("responderRules").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResponderRecipeResponderRuleCollection.class, ListResponderRecipeResponderRulesResponse.Builder::responderRecipeResponderRuleCollection).handleResponseHeaderString("opc-request-id", ListResponderRecipeResponderRulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListResponderRecipeResponderRulesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListResponderRecipesResponse listResponderRecipes(ListResponderRecipesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListResponderRecipesResponse)this.clientCall(request, ListResponderRecipesResponse::builder).logger(LOG, "listResponderRecipes").serviceDetails("CloudGuard", "ListResponderRecipes", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResponderRecipe/ListResponderRecipes").method(Method.GET).requestBuilder(ListResponderRecipesRequest::builder).basePath("/20200131").appendPathParam("responderRecipes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("resourceMetadataOnly", (Object)request.getResourceMetadataOnly()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendEnumQueryParam("accessLevel", (BmcEnum)request.getAccessLevel()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResponderRecipeCollection.class, ListResponderRecipesResponse.Builder::responderRecipeCollection).handleResponseHeaderString("opc-request-id", ListResponderRecipesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListResponderRecipesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListResponderRulesResponse listResponderRules(ListResponderRulesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListResponderRulesResponse)this.clientCall(request, ListResponderRulesResponse::builder).logger(LOG, "listResponderRules").serviceDetails("CloudGuard", "ListResponderRules", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResponderRule/ListResponderRules").method(Method.GET).requestBuilder(ListResponderRulesRequest::builder).basePath("/20200131").appendPathParam("responderRules").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResponderRuleCollection.class, ListResponderRulesResponse.Builder::responderRuleCollection).handleResponseHeaderString("opc-request-id", ListResponderRulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListResponderRulesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListSecurityPoliciesResponse listSecurityPolicies(ListSecurityPoliciesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListSecurityPoliciesResponse)this.clientCall(request, ListSecurityPoliciesResponse::builder).logger(LOG, "listSecurityPolicies").serviceDetails("CloudGuard", "ListSecurityPolicies", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/SecurityPolicyCollection/ListSecurityPolicies").method(Method.GET).requestBuilder(ListSecurityPoliciesRequest::builder).basePath("/20200131").appendPathParam("securityPolicies").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SecurityPolicyCollection.class, ListSecurityPoliciesResponse.Builder::securityPolicyCollection).handleResponseHeaderString("opc-request-id", ListSecurityPoliciesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSecurityPoliciesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListSecurityRecipesResponse listSecurityRecipes(ListSecurityRecipesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListSecurityRecipesResponse)this.clientCall(request, ListSecurityRecipesResponse::builder).logger(LOG, "listSecurityRecipes").serviceDetails("CloudGuard", "ListSecurityRecipes", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/SecurityRecipeCollection/ListSecurityRecipes").method(Method.GET).requestBuilder(ListSecurityRecipesRequest::builder).basePath("/20200131").appendPathParam("securityRecipes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SecurityRecipeCollection.class, ListSecurityRecipesResponse.Builder::securityRecipeCollection).handleResponseHeaderString("opc-request-id", ListSecurityRecipesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSecurityRecipesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListSecurityZonesResponse listSecurityZones(ListSecurityZonesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListSecurityZonesResponse)this.clientCall(request, ListSecurityZonesResponse::builder).logger(LOG, "listSecurityZones").serviceDetails("CloudGuard", "ListSecurityZones", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/SecurityZoneCollection/ListSecurityZones").method(Method.GET).requestBuilder(ListSecurityZonesRequest::builder).basePath("/20200131").appendPathParam("securityZones").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("securityRecipeId", (Object)request.getSecurityRecipeId()).appendQueryParam("isRequiredSecurityZonesInSubtree", (Object)request.getIsRequiredSecurityZonesInSubtree()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SecurityZoneCollection.class, ListSecurityZonesResponse.Builder::securityZoneCollection).handleResponseHeaderString("opc-request-id", ListSecurityZonesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSecurityZonesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListSightingEndpointsResponse listSightingEndpoints(ListSightingEndpointsRequest request) {
        Validate.notBlank((String)request.getSightingId(), (String)"sightingId must not be blank", (Object[])new Object[0]);
        return (ListSightingEndpointsResponse)this.clientCall(request, ListSightingEndpointsResponse::builder).logger(LOG, "listSightingEndpoints").serviceDetails("CloudGuard", "ListSightingEndpoints", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/SightingEndpointSummary/ListSightingEndpoints").method(Method.GET).requestBuilder(ListSightingEndpointsRequest::builder).basePath("/20200131").appendPathParam("sightings").appendPathParam(request.getSightingId()).appendPathParam("endpoints").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SightingEndpointCollection.class, ListSightingEndpointsResponse.Builder::sightingEndpointCollection).handleResponseHeaderString("opc-request-id", ListSightingEndpointsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSightingEndpointsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListSightingImpactedResourcesResponse listSightingImpactedResources(ListSightingImpactedResourcesRequest request) {
        Validate.notBlank((String)request.getSightingId(), (String)"sightingId must not be blank", (Object[])new Object[0]);
        return (ListSightingImpactedResourcesResponse)this.clientCall(request, ListSightingImpactedResourcesResponse::builder).logger(LOG, "listSightingImpactedResources").serviceDetails("CloudGuard", "ListSightingImpactedResources", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/SightingImpactedResourceSummary/ListSightingImpactedResources").method(Method.GET).requestBuilder(ListSightingImpactedResourcesRequest::builder).basePath("/20200131").appendPathParam("sightings").appendPathParam(request.getSightingId()).appendPathParam("impactedResources").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SightingImpactedResourceCollection.class, ListSightingImpactedResourcesResponse.Builder::sightingImpactedResourceCollection).handleResponseHeaderString("opc-request-id", ListSightingImpactedResourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSightingImpactedResourcesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListSightingsResponse listSightings(ListSightingsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListSightingsResponse)this.clientCall(request, ListSightingsResponse::builder).logger(LOG, "listSightings").serviceDetails("CloudGuard", "ListSightings", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/SightingSummary/ListSightings").method(Method.GET).requestBuilder(ListSightingsRequest::builder).basePath("/20200131").appendPathParam("sightings").appendQueryParam("problemId", (Object)request.getProblemId()).appendQueryParam("resourceProfileId", (Object)request.getResourceProfileId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendEnumQueryParam("accessLevel", (BmcEnum)request.getAccessLevel()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("timeLastDetectedGreaterThanOrEqualTo", (Object)request.getTimeLastDetectedGreaterThanOrEqualTo()).appendQueryParam("timeLastDetectedLessThanOrEqualTo", (Object)request.getTimeLastDetectedLessThanOrEqualTo()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SightingCollection.class, ListSightingsResponse.Builder::sightingCollection).handleResponseHeaderString("opc-request-id", ListSightingsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSightingsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListTacticsResponse listTactics(ListTacticsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListTacticsResponse)this.clientCall(request, ListTacticsResponse::builder).logger(LOG, "listTactics").serviceDetails("CloudGuard", "ListTactics", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/TacticSummary/ListTactics").method(Method.GET).requestBuilder(ListTacticsRequest::builder).basePath("/20200131").appendPathParam("tactics").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TacticCollection.class, ListTacticsResponse.Builder::tacticCollection).handleResponseHeaderString("opc-request-id", ListTacticsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTacticsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListTargetDetectorRecipeDetectorRulesResponse listTargetDetectorRecipeDetectorRules(ListTargetDetectorRecipeDetectorRulesRequest request) {
        Validate.notBlank((String)request.getTargetId(), (String)"targetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTargetDetectorRecipeId(), (String)"targetDetectorRecipeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListTargetDetectorRecipeDetectorRulesResponse)this.clientCall(request, ListTargetDetectorRecipeDetectorRulesResponse::builder).logger(LOG, "listTargetDetectorRecipeDetectorRules").serviceDetails("CloudGuard", "ListTargetDetectorRecipeDetectorRules", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/TargetDetectorRecipeDetectorRule/ListTargetDetectorRecipeDetectorRules").method(Method.GET).requestBuilder(ListTargetDetectorRecipeDetectorRulesRequest::builder).basePath("/20200131").appendPathParam("targets").appendPathParam(request.getTargetId()).appendPathParam("targetDetectorRecipes").appendPathParam(request.getTargetDetectorRecipeId()).appendPathParam("detectorRules").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TargetDetectorRecipeDetectorRuleCollection.class, ListTargetDetectorRecipeDetectorRulesResponse.Builder::targetDetectorRecipeDetectorRuleCollection).handleResponseHeaderString("opc-request-id", ListTargetDetectorRecipeDetectorRulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTargetDetectorRecipeDetectorRulesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListTargetDetectorRecipesResponse listTargetDetectorRecipes(ListTargetDetectorRecipesRequest request) {
        Validate.notBlank((String)request.getTargetId(), (String)"targetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListTargetDetectorRecipesResponse)this.clientCall(request, ListTargetDetectorRecipesResponse::builder).logger(LOG, "listTargetDetectorRecipes").serviceDetails("CloudGuard", "ListTargetDetectorRecipes", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/TargetDetectorRecipe/ListTargetDetectorRecipes").method(Method.GET).requestBuilder(ListTargetDetectorRecipesRequest::builder).basePath("/20200131").appendPathParam("targets").appendPathParam(request.getTargetId()).appendPathParam("targetDetectorRecipes").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TargetDetectorRecipeCollection.class, ListTargetDetectorRecipesResponse.Builder::targetDetectorRecipeCollection).handleResponseHeaderString("opc-request-id", ListTargetDetectorRecipesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTargetDetectorRecipesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListTargetResponderRecipeResponderRulesResponse listTargetResponderRecipeResponderRules(ListTargetResponderRecipeResponderRulesRequest request) {
        Validate.notBlank((String)request.getTargetId(), (String)"targetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTargetResponderRecipeId(), (String)"targetResponderRecipeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListTargetResponderRecipeResponderRulesResponse)this.clientCall(request, ListTargetResponderRecipeResponderRulesResponse::builder).logger(LOG, "listTargetResponderRecipeResponderRules").serviceDetails("CloudGuard", "ListTargetResponderRecipeResponderRules", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/TargetResponderRecipeResponderRule/ListTargetResponderRecipeResponderRules").method(Method.GET).requestBuilder(ListTargetResponderRecipeResponderRulesRequest::builder).basePath("/20200131").appendPathParam("targets").appendPathParam(request.getTargetId()).appendPathParam("targetResponderRecipes").appendPathParam(request.getTargetResponderRecipeId()).appendPathParam("responderRules").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TargetResponderRecipeResponderRuleCollection.class, ListTargetResponderRecipeResponderRulesResponse.Builder::targetResponderRecipeResponderRuleCollection).handleResponseHeaderString("opc-request-id", ListTargetResponderRecipeResponderRulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTargetResponderRecipeResponderRulesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListTargetResponderRecipesResponse listTargetResponderRecipes(ListTargetResponderRecipesRequest request) {
        Validate.notBlank((String)request.getTargetId(), (String)"targetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListTargetResponderRecipesResponse)this.clientCall(request, ListTargetResponderRecipesResponse::builder).logger(LOG, "listTargetResponderRecipes").serviceDetails("CloudGuard", "ListTargetResponderRecipes", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/TargetResponderRecipe/ListTargetResponderRecipes").method(Method.GET).requestBuilder(ListTargetResponderRecipesRequest::builder).basePath("/20200131").appendPathParam("targets").appendPathParam(request.getTargetId()).appendPathParam("targetResponderRecipes").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TargetResponderRecipeCollection.class, ListTargetResponderRecipesResponse.Builder::targetResponderRecipeCollection).handleResponseHeaderString("opc-request-id", ListTargetResponderRecipesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTargetResponderRecipesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListTargetsResponse listTargets(ListTargetsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListTargetsResponse)this.clientCall(request, ListTargetsResponse::builder).logger(LOG, "listTargets").serviceDetails("CloudGuard", "ListTargets", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/Target/ListTargets").method(Method.GET).requestBuilder(ListTargetsRequest::builder).basePath("/20200131").appendPathParam("targets").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("isNonSecurityZoneTargetsOnlyQuery", (Object)request.getIsNonSecurityZoneTargetsOnlyQuery()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendEnumQueryParam("accessLevel", (BmcEnum)request.getAccessLevel()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TargetCollection.class, ListTargetsResponse.Builder::targetCollection).handleResponseHeaderString("opc-request-id", ListTargetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTargetsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListTechniquesResponse listTechniques(ListTechniquesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListTechniquesResponse)this.clientCall(request, ListTechniquesResponse::builder).logger(LOG, "listTechniques").serviceDetails("CloudGuard", "ListTechniques", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/TechniqueSummary/ListTechniques").method(Method.GET).requestBuilder(ListTechniquesRequest::builder).basePath("/20200131").appendPathParam("techniques").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("tactics", request.getTactics(), CollectionFormatType.Multi).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TechniqueCollection.class, ListTechniquesResponse.Builder::techniqueCollection).handleResponseHeaderString("opc-request-id", ListTechniquesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTechniquesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("CloudGuard", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20200131").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("CloudGuard", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20200131").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("CloudGuard", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20200131").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RemoveCompartmentResponse removeCompartment(RemoveCompartmentRequest request) {
        Validate.notBlank((String)request.getSecurityZoneId(), (String)"securityZoneId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveCompartmentDetails(), "removeCompartmentDetails is required");
        return (RemoveCompartmentResponse)this.clientCall(request, RemoveCompartmentResponse::builder).logger(LOG, "removeCompartment").serviceDetails("CloudGuard", "RemoveCompartment", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/SecurityZone/RemoveCompartment").method(Method.POST).requestBuilder(RemoveCompartmentRequest::builder).basePath("/20200131").appendPathParam("securityZones").appendPathParam(request.getSecurityZoneId()).appendPathParam("actions").appendPathParam("removeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SecurityZone.class, RemoveCompartmentResponse.Builder::securityZone).handleResponseHeaderString("etag", RemoveCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RemoveCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RequestRiskScoresResponse requestRiskScores(RequestRiskScoresRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (RequestRiskScoresResponse)this.clientCall(request, RequestRiskScoresResponse::builder).logger(LOG, "requestRiskScores").serviceDetails("CloudGuard", "RequestRiskScores", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/RiskScoreAggregation/RequestRiskScores").method(Method.POST).requestBuilder(RequestRiskScoresRequest::builder).basePath("/20200131").appendPathParam("riskScores").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RiskScoreAggregationCollection.class, RequestRiskScoresResponse.Builder::riskScoreAggregationCollection).handleResponseHeaderString("opc-request-id", RequestRiskScoresResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", RequestRiskScoresResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RequestSecurityScoreSummarizedTrendResponse requestSecurityScoreSummarizedTrend(RequestSecurityScoreSummarizedTrendRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (RequestSecurityScoreSummarizedTrendResponse)this.clientCall(request, RequestSecurityScoreSummarizedTrendResponse::builder).logger(LOG, "requestSecurityScoreSummarizedTrend").serviceDetails("CloudGuard", "RequestSecurityScoreSummarizedTrend", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/SecurityScoreTrendAggregation/RequestSecurityScoreSummarizedTrend").method(Method.POST).requestBuilder(RequestSecurityScoreSummarizedTrendRequest::builder).basePath("/20200131").appendPathParam("securityScores").appendPathParam("actions").appendPathParam("summarizeTrend").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("timeScoreComputedGreaterThanOrEqualTo", (Object)request.getTimeScoreComputedGreaterThanOrEqualTo()).appendQueryParam("timeScoreComputedLessThanOrEqualTo", (Object)request.getTimeScoreComputedLessThanOrEqualTo()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SecurityScoreTrendAggregationCollection.class, RequestSecurityScoreSummarizedTrendResponse.Builder::securityScoreTrendAggregationCollection).handleResponseHeaderString("opc-request-id", RequestSecurityScoreSummarizedTrendResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", RequestSecurityScoreSummarizedTrendResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RequestSecurityScoresResponse requestSecurityScores(RequestSecurityScoresRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (RequestSecurityScoresResponse)this.clientCall(request, RequestSecurityScoresResponse::builder).logger(LOG, "requestSecurityScores").serviceDetails("CloudGuard", "RequestSecurityScores", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/SecurityScoreAggregation/RequestSecurityScores").method(Method.POST).requestBuilder(RequestSecurityScoresRequest::builder).basePath("/20200131").appendPathParam("securityScores").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SecurityScoreAggregationCollection.class, RequestSecurityScoresResponse.Builder::securityScoreAggregationCollection).handleResponseHeaderString("opc-request-id", RequestSecurityScoresResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", RequestSecurityScoresResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RequestSummarizedActivityProblemsResponse requestSummarizedActivityProblems(RequestSummarizedActivityProblemsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (RequestSummarizedActivityProblemsResponse)this.clientCall(request, RequestSummarizedActivityProblemsResponse::builder).logger(LOG, "requestSummarizedActivityProblems").serviceDetails("CloudGuard", "RequestSummarizedActivityProblems", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ActivityProblemAggregation/RequestSummarizedActivityProblems").method(Method.POST).requestBuilder(RequestSummarizedActivityProblemsRequest::builder).basePath("/20200131").appendPathParam("problems").appendPathParam("actions").appendPathParam("summarizeActivityProblems").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendEnumQueryParam("accessLevel", (BmcEnum)request.getAccessLevel()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("includeUnknownLocations", (Object)request.getIncludeUnknownLocations()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ActivityProblemAggregationCollection.class, RequestSummarizedActivityProblemsResponse.Builder::activityProblemAggregationCollection).handleResponseHeaderString("opc-request-id", RequestSummarizedActivityProblemsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", RequestSummarizedActivityProblemsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RequestSummarizedProblemsResponse requestSummarizedProblems(RequestSummarizedProblemsRequest request) {
        Objects.requireNonNull(request.getListDimensions(), "listDimensions is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (RequestSummarizedProblemsResponse)this.clientCall(request, RequestSummarizedProblemsResponse::builder).logger(LOG, "requestSummarizedProblems").serviceDetails("CloudGuard", "RequestSummarizedProblems", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ProblemAggregation/RequestSummarizedProblems").method(Method.POST).requestBuilder(RequestSummarizedProblemsRequest::builder).basePath("/20200131").appendPathParam("problems").appendPathParam("actions").appendPathParam("summarize").appendListQueryParam("listDimensions", request.getListDimensions(), CollectionFormatType.Multi).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendEnumQueryParam("accessLevel", (BmcEnum)request.getAccessLevel()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProblemAggregationCollection.class, RequestSummarizedProblemsResponse.Builder::problemAggregationCollection).handleResponseHeaderString("opc-request-id", RequestSummarizedProblemsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", RequestSummarizedProblemsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RequestSummarizedResponderExecutionsResponse requestSummarizedResponderExecutions(RequestSummarizedResponderExecutionsRequest request) {
        Objects.requireNonNull(request.getResponderExecutionsDimensions(), "responderExecutionsDimensions is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (RequestSummarizedResponderExecutionsResponse)this.clientCall(request, RequestSummarizedResponderExecutionsResponse::builder).logger(LOG, "requestSummarizedResponderExecutions").serviceDetails("CloudGuard", "RequestSummarizedResponderExecutions", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResponderExecutionAggregation/RequestSummarizedResponderExecutions").method(Method.POST).requestBuilder(RequestSummarizedResponderExecutionsRequest::builder).basePath("/20200131").appendPathParam("responderExecutions").appendPathParam("actions").appendPathParam("summarize").appendListQueryParam("responderExecutionsDimensions", request.getResponderExecutionsDimensions(), CollectionFormatType.Multi).appendListQueryParam("responderTypeFilter", request.getResponderTypeFilter(), CollectionFormatType.Multi).appendListQueryParam("responderExecutionStatusFilter", request.getResponderExecutionStatusFilter(), CollectionFormatType.Multi).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendEnumQueryParam("accessLevel", (BmcEnum)request.getAccessLevel()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResponderExecutionAggregationCollection.class, RequestSummarizedResponderExecutionsResponse.Builder::responderExecutionAggregationCollection).handleResponseHeaderString("opc-request-id", RequestSummarizedResponderExecutionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", RequestSummarizedResponderExecutionsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RequestSummarizedRiskScoresResponse requestSummarizedRiskScores(RequestSummarizedRiskScoresRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (RequestSummarizedRiskScoresResponse)this.clientCall(request, RequestSummarizedRiskScoresResponse::builder).logger(LOG, "requestSummarizedRiskScores").serviceDetails("CloudGuard", "RequestSummarizedRiskScores", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/RiskScoreAggregation/RequestSummarizedRiskScores").method(Method.POST).requestBuilder(RequestSummarizedRiskScoresRequest::builder).basePath("/20200131").appendPathParam("problems").appendPathParam("actions").appendPathParam("summarizeRiskScore").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RiskScoreAggregationCollection.class, RequestSummarizedRiskScoresResponse.Builder::riskScoreAggregationCollection).handleResponseHeaderString("opc-request-id", RequestSummarizedRiskScoresResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", RequestSummarizedRiskScoresResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RequestSummarizedSecurityScoresResponse requestSummarizedSecurityScores(RequestSummarizedSecurityScoresRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (RequestSummarizedSecurityScoresResponse)this.clientCall(request, RequestSummarizedSecurityScoresResponse::builder).logger(LOG, "requestSummarizedSecurityScores").serviceDetails("CloudGuard", "RequestSummarizedSecurityScores", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/SecurityScoreAggregation/RequestSummarizedSecurityScores").method(Method.POST).requestBuilder(RequestSummarizedSecurityScoresRequest::builder).basePath("/20200131").appendPathParam("problems").appendPathParam("actions").appendPathParam("summarizeSecurityScore").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SecurityScoreAggregationCollection.class, RequestSummarizedSecurityScoresResponse.Builder::securityScoreAggregationCollection).handleResponseHeaderString("opc-request-id", RequestSummarizedSecurityScoresResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", RequestSummarizedSecurityScoresResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RequestSummarizedTopTrendResourceProfileRiskScoresResponse requestSummarizedTopTrendResourceProfileRiskScores(RequestSummarizedTopTrendResourceProfileRiskScoresRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (RequestSummarizedTopTrendResourceProfileRiskScoresResponse)this.clientCall(request, RequestSummarizedTopTrendResourceProfileRiskScoresResponse::builder).logger(LOG, "requestSummarizedTopTrendResourceProfileRiskScores").serviceDetails("CloudGuard", "RequestSummarizedTopTrendResourceProfileRiskScores", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResourceProfileRiskScoreAggregationSummary/RequestSummarizedTopTrendResourceProfileRiskScores").method(Method.POST).requestBuilder(RequestSummarizedTopTrendResourceProfileRiskScoresRequest::builder).basePath("/20200131").appendPathParam("resourceProfileRiskScores").appendPathParam("actions").appendPathParam("summarizeTopTrends").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("timeScoreComputedGreaterThanOrEqualTo", (Object)request.getTimeScoreComputedGreaterThanOrEqualTo()).appendQueryParam("timeScoreComputedLessThanOrEqualTo", (Object)request.getTimeScoreComputedLessThanOrEqualTo()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("count", (Object)request.getCount()).appendEnumQueryParam("accessLevel", (BmcEnum)request.getAccessLevel()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResourceProfileRiskScoreAggregationSummaryCollection.class, RequestSummarizedTopTrendResourceProfileRiskScoresResponse.Builder::resourceProfileRiskScoreAggregationSummaryCollection).handleResponseHeaderString("opc-request-id", RequestSummarizedTopTrendResourceProfileRiskScoresResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", RequestSummarizedTopTrendResourceProfileRiskScoresResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RequestSummarizedTrendProblemsResponse requestSummarizedTrendProblems(RequestSummarizedTrendProblemsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (RequestSummarizedTrendProblemsResponse)this.clientCall(request, RequestSummarizedTrendProblemsResponse::builder).logger(LOG, "requestSummarizedTrendProblems").serviceDetails("CloudGuard", "RequestSummarizedTrendProblems", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ProblemTrendAggregation/RequestSummarizedTrendProblems").method(Method.POST).requestBuilder(RequestSummarizedTrendProblemsRequest::builder).basePath("/20200131").appendPathParam("problems").appendPathParam("actions").appendPathParam("summarizeTrend").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("timeFirstDetectedGreaterThanOrEqualTo", (Object)request.getTimeFirstDetectedGreaterThanOrEqualTo()).appendQueryParam("timeFirstDetectedLessThanOrEqualTo", (Object)request.getTimeFirstDetectedLessThanOrEqualTo()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendEnumQueryParam("accessLevel", (BmcEnum)request.getAccessLevel()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProblemTrendAggregationCollection.class, RequestSummarizedTrendProblemsResponse.Builder::problemTrendAggregationCollection).handleResponseHeaderString("opc-request-id", RequestSummarizedTrendProblemsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", RequestSummarizedTrendProblemsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RequestSummarizedTrendResourceRiskScoresResponse requestSummarizedTrendResourceRiskScores(RequestSummarizedTrendResourceRiskScoresRequest request) {
        Objects.requireNonNull(request.getRequestSummarizedTrendResourceRiskScoresDetails(), "requestSummarizedTrendResourceRiskScoresDetails is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (RequestSummarizedTrendResourceRiskScoresResponse)this.clientCall(request, RequestSummarizedTrendResourceRiskScoresResponse::builder).logger(LOG, "requestSummarizedTrendResourceRiskScores").serviceDetails("CloudGuard", "RequestSummarizedTrendResourceRiskScores", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResourceRiskScoreAggregation/RequestSummarizedTrendResourceRiskScores").method(Method.POST).requestBuilder(RequestSummarizedTrendResourceRiskScoresRequest::builder).basePath("/20200131").appendPathParam("resourceRiskScores").appendPathParam("actions").appendPathParam("summarizeTrend").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("timeScoreComputedGreaterThanOrEqualTo", (Object)request.getTimeScoreComputedGreaterThanOrEqualTo()).appendQueryParam("timeScoreComputedLessThanOrEqualTo", (Object)request.getTimeScoreComputedLessThanOrEqualTo()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendEnumQueryParam("accessLevel", (BmcEnum)request.getAccessLevel()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ResourceRiskScoreAggregationCollection.class, RequestSummarizedTrendResourceRiskScoresResponse.Builder::resourceRiskScoreAggregationCollection).handleResponseHeaderString("opc-request-id", RequestSummarizedTrendResourceRiskScoresResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", RequestSummarizedTrendResourceRiskScoresResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RequestSummarizedTrendResponderExecutionsResponse requestSummarizedTrendResponderExecutions(RequestSummarizedTrendResponderExecutionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (RequestSummarizedTrendResponderExecutionsResponse)this.clientCall(request, RequestSummarizedTrendResponderExecutionsResponse::builder).logger(LOG, "requestSummarizedTrendResponderExecutions").serviceDetails("CloudGuard", "RequestSummarizedTrendResponderExecutions", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResponderExecutionTrendAggregation/RequestSummarizedTrendResponderExecutions").method(Method.POST).requestBuilder(RequestSummarizedTrendResponderExecutionsRequest::builder).basePath("/20200131").appendPathParam("responderExecutions").appendPathParam("actions").appendPathParam("summarizeTrend").appendQueryParam("timeCompletedGreaterThanOrEqualTo", (Object)request.getTimeCompletedGreaterThanOrEqualTo()).appendQueryParam("timeCompletedLessThanOrEqualTo", (Object)request.getTimeCompletedLessThanOrEqualTo()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendEnumQueryParam("accessLevel", (BmcEnum)request.getAccessLevel()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResponderExecutionTrendAggregationCollection.class, RequestSummarizedTrendResponderExecutionsResponse.Builder::responderExecutionTrendAggregationCollection).handleResponseHeaderString("opc-request-id", RequestSummarizedTrendResponderExecutionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", RequestSummarizedTrendResponderExecutionsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RequestSummarizedTrendSecurityScoresResponse requestSummarizedTrendSecurityScores(RequestSummarizedTrendSecurityScoresRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (RequestSummarizedTrendSecurityScoresResponse)this.clientCall(request, RequestSummarizedTrendSecurityScoresResponse::builder).logger(LOG, "requestSummarizedTrendSecurityScores").serviceDetails("CloudGuard", "RequestSummarizedTrendSecurityScores", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/SecurityScoreTrendAggregation/RequestSummarizedTrendSecurityScores").method(Method.POST).requestBuilder(RequestSummarizedTrendSecurityScoresRequest::builder).basePath("/20200131").appendPathParam("problems").appendPathParam("actions").appendPathParam("summarizeSecurityScoreTrend").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("timeScoreComputedGreaterThanOrEqualTo", (Object)request.getTimeScoreComputedGreaterThanOrEqualTo()).appendQueryParam("timeScoreComputedLessThanOrEqualTo", (Object)request.getTimeScoreComputedLessThanOrEqualTo()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SecurityScoreTrendAggregationCollection.class, RequestSummarizedTrendSecurityScoresResponse.Builder::securityScoreTrendAggregationCollection).handleResponseHeaderString("opc-request-id", RequestSummarizedTrendSecurityScoresResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", RequestSummarizedTrendSecurityScoresResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SkipBulkResponderExecutionResponse skipBulkResponderExecution(SkipBulkResponderExecutionRequest request) {
        Objects.requireNonNull(request.getSkipBulkResponderExecutionDetails(), "skipBulkResponderExecutionDetails is required");
        return (SkipBulkResponderExecutionResponse)this.clientCall(request, SkipBulkResponderExecutionResponse::builder).logger(LOG, "skipBulkResponderExecution").serviceDetails("CloudGuard", "SkipBulkResponderExecution", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResponderExecution/SkipBulkResponderExecution").method(Method.POST).requestBuilder(SkipBulkResponderExecutionRequest::builder).basePath("/20200131").appendPathParam("responderExecutions").appendPathParam("actions").appendPathParam("bulkSkip").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", SkipBulkResponderExecutionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public SkipResponderExecutionResponse skipResponderExecution(SkipResponderExecutionRequest request) {
        Validate.notBlank((String)request.getResponderExecutionId(), (String)"responderExecutionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (SkipResponderExecutionResponse)this.clientCall(request, SkipResponderExecutionResponse::builder).logger(LOG, "skipResponderExecution").serviceDetails("CloudGuard", "SkipResponderExecution", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResponderExecution/SkipResponderExecution").method(Method.POST).requestBuilder(SkipResponderExecutionRequest::builder).basePath("/20200131").appendPathParam("responderExecutions").appendPathParam(request.getResponderExecutionId()).appendPathParam("actions").appendPathParam("skip").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", SkipResponderExecutionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public TriggerResponderResponse triggerResponder(TriggerResponderRequest request) {
        Validate.notBlank((String)request.getProblemId(), (String)"problemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getTriggerResponderDetails(), "triggerResponderDetails is required");
        return (TriggerResponderResponse)this.clientCall(request, TriggerResponderResponse::builder).logger(LOG, "triggerResponder").serviceDetails("CloudGuard", "TriggerResponder", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/Problem/TriggerResponder").method(Method.POST).requestBuilder(TriggerResponderRequest::builder).basePath("/20200131").appendPathParam("problems").appendPathParam(request.getProblemId()).appendPathParam("actions").appendPathParam("triggerResponder").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", TriggerResponderResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateBulkProblemStatusResponse updateBulkProblemStatus(UpdateBulkProblemStatusRequest request) {
        Objects.requireNonNull(request.getUpdateBulkProblemStatusDetails(), "updateBulkProblemStatusDetails is required");
        return (UpdateBulkProblemStatusResponse)this.clientCall(request, UpdateBulkProblemStatusResponse::builder).logger(LOG, "updateBulkProblemStatus").serviceDetails("CloudGuard", "UpdateBulkProblemStatus", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/Problem/UpdateBulkProblemStatus").method(Method.POST).requestBuilder(UpdateBulkProblemStatusRequest::builder).basePath("/20200131").appendPathParam("problems").appendPathParam("actions").appendPathParam("bulkUpdateStatus").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateBulkProblemStatusResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateConfigurationResponse updateConfiguration(UpdateConfigurationRequest request) {
        Objects.requireNonNull(request.getUpdateConfigurationDetails(), "updateConfigurationDetails is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (UpdateConfigurationResponse)this.clientCall(request, UpdateConfigurationResponse::builder).logger(LOG, "updateConfiguration").serviceDetails("CloudGuard", "UpdateConfiguration", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/Configuration/UpdateConfiguration").method(Method.PUT).requestBuilder(UpdateConfigurationRequest::builder).basePath("/20200131").appendPathParam("configuration").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Configuration.class, UpdateConfigurationResponse.Builder::configuration).handleResponseHeaderString("etag", UpdateConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateConfigurationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDataMaskRuleResponse updateDataMaskRule(UpdateDataMaskRuleRequest request) {
        Validate.notBlank((String)request.getDataMaskRuleId(), (String)"dataMaskRuleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDataMaskRuleDetails(), "updateDataMaskRuleDetails is required");
        return (UpdateDataMaskRuleResponse)this.clientCall(request, UpdateDataMaskRuleResponse::builder).logger(LOG, "updateDataMaskRule").serviceDetails("CloudGuard", "UpdateDataMaskRule", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DataMaskRule/UpdateDataMaskRule").method(Method.PUT).requestBuilder(UpdateDataMaskRuleRequest::builder).basePath("/20200131").appendPathParam("dataMaskRules").appendPathParam(request.getDataMaskRuleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DataMaskRule.class, UpdateDataMaskRuleResponse.Builder::dataMaskRule).handleResponseHeaderString("etag", UpdateDataMaskRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDataMaskRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDataSourceResponse updateDataSource(UpdateDataSourceRequest request) {
        Validate.notBlank((String)request.getDataSourceId(), (String)"dataSourceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDataSourceDetails(), "updateDataSourceDetails is required");
        return (UpdateDataSourceResponse)this.clientCall(request, UpdateDataSourceResponse::builder).logger(LOG, "updateDataSource").serviceDetails("CloudGuard", "UpdateDataSource", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DataSource/UpdateDataSource").method(Method.PUT).requestBuilder(UpdateDataSourceRequest::builder).basePath("/20200131").appendPathParam("dataSources").appendPathParam(request.getDataSourceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateDataSourceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDataSourceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDetectorRecipeResponse updateDetectorRecipe(UpdateDetectorRecipeRequest request) {
        Validate.notBlank((String)request.getDetectorRecipeId(), (String)"detectorRecipeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDetectorRecipeDetails(), "updateDetectorRecipeDetails is required");
        return (UpdateDetectorRecipeResponse)this.clientCall(request, UpdateDetectorRecipeResponse::builder).logger(LOG, "updateDetectorRecipe").serviceDetails("CloudGuard", "UpdateDetectorRecipe", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DetectorRecipe/UpdateDetectorRecipe").method(Method.PUT).requestBuilder(UpdateDetectorRecipeRequest::builder).basePath("/20200131").appendPathParam("detectorRecipes").appendPathParam(request.getDetectorRecipeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DetectorRecipe.class, UpdateDetectorRecipeResponse.Builder::detectorRecipe).handleResponseHeaderString("etag", UpdateDetectorRecipeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDetectorRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDetectorRecipeDetectorRuleResponse updateDetectorRecipeDetectorRule(UpdateDetectorRecipeDetectorRuleRequest request) {
        Validate.notBlank((String)request.getDetectorRecipeId(), (String)"detectorRecipeId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDetectorRuleId(), (String)"detectorRuleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDetectorRecipeDetectorRuleDetails(), "updateDetectorRecipeDetectorRuleDetails is required");
        return (UpdateDetectorRecipeDetectorRuleResponse)this.clientCall(request, UpdateDetectorRecipeDetectorRuleResponse::builder).logger(LOG, "updateDetectorRecipeDetectorRule").serviceDetails("CloudGuard", "UpdateDetectorRecipeDetectorRule", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/DetectorRecipeDetectorRule/UpdateDetectorRecipeDetectorRule").method(Method.PUT).requestBuilder(UpdateDetectorRecipeDetectorRuleRequest::builder).basePath("/20200131").appendPathParam("detectorRecipes").appendPathParam(request.getDetectorRecipeId()).appendPathParam("detectorRules").appendPathParam(request.getDetectorRuleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DetectorRecipeDetectorRule.class, UpdateDetectorRecipeDetectorRuleResponse.Builder::detectorRecipeDetectorRule).handleResponseHeaderString("etag", UpdateDetectorRecipeDetectorRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDetectorRecipeDetectorRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateManagedListResponse updateManagedList(UpdateManagedListRequest request) {
        Validate.notBlank((String)request.getManagedListId(), (String)"managedListId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateManagedListDetails(), "updateManagedListDetails is required");
        return (UpdateManagedListResponse)this.clientCall(request, UpdateManagedListResponse::builder).logger(LOG, "updateManagedList").serviceDetails("CloudGuard", "UpdateManagedList", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ManagedList/UpdateManagedList").method(Method.PUT).requestBuilder(UpdateManagedListRequest::builder).basePath("/20200131").appendPathParam("managedLists").appendPathParam(request.getManagedListId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ManagedList.class, UpdateManagedListResponse.Builder::managedList).handleResponseHeaderString("etag", UpdateManagedListResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateManagedListResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateProblemStatusResponse updateProblemStatus(UpdateProblemStatusRequest request) {
        Validate.notBlank((String)request.getProblemId(), (String)"problemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateProblemStatusDetails(), "updateProblemStatusDetails is required");
        return (UpdateProblemStatusResponse)this.clientCall(request, UpdateProblemStatusResponse::builder).logger(LOG, "updateProblemStatus").serviceDetails("CloudGuard", "UpdateProblemStatus", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/Problem/UpdateProblemStatus").method(Method.POST).requestBuilder(UpdateProblemStatusRequest::builder).basePath("/20200131").appendPathParam("problems").appendPathParam(request.getProblemId()).appendPathParam("actions").appendPathParam("updateStatus").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Problem.class, UpdateProblemStatusResponse.Builder::problem).handleResponseHeaderString("etag", UpdateProblemStatusResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateProblemStatusResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateResponderRecipeResponse updateResponderRecipe(UpdateResponderRecipeRequest request) {
        Validate.notBlank((String)request.getResponderRecipeId(), (String)"responderRecipeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateResponderRecipeDetails(), "updateResponderRecipeDetails is required");
        return (UpdateResponderRecipeResponse)this.clientCall(request, UpdateResponderRecipeResponse::builder).logger(LOG, "updateResponderRecipe").serviceDetails("CloudGuard", "UpdateResponderRecipe", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResponderRecipe/UpdateResponderRecipe").method(Method.PUT).requestBuilder(UpdateResponderRecipeRequest::builder).basePath("/20200131").appendPathParam("responderRecipes").appendPathParam(request.getResponderRecipeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ResponderRecipe.class, UpdateResponderRecipeResponse.Builder::responderRecipe).handleResponseHeaderString("etag", UpdateResponderRecipeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateResponderRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateResponderRecipeResponderRuleResponse updateResponderRecipeResponderRule(UpdateResponderRecipeResponderRuleRequest request) {
        Validate.notBlank((String)request.getResponderRecipeId(), (String)"responderRecipeId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getResponderRuleId(), (String)"responderRuleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateResponderRecipeResponderRuleDetails(), "updateResponderRecipeResponderRuleDetails is required");
        return (UpdateResponderRecipeResponderRuleResponse)this.clientCall(request, UpdateResponderRecipeResponderRuleResponse::builder).logger(LOG, "updateResponderRecipeResponderRule").serviceDetails("CloudGuard", "UpdateResponderRecipeResponderRule", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/ResponderRecipeResponderRule/UpdateResponderRecipeResponderRule").method(Method.PUT).requestBuilder(UpdateResponderRecipeResponderRuleRequest::builder).basePath("/20200131").appendPathParam("responderRecipes").appendPathParam(request.getResponderRecipeId()).appendPathParam("responderRules").appendPathParam(request.getResponderRuleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ResponderRecipeResponderRule.class, UpdateResponderRecipeResponderRuleResponse.Builder::responderRecipeResponderRule).handleResponseHeaderString("etag", UpdateResponderRecipeResponderRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateResponderRecipeResponderRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateSecurityRecipeResponse updateSecurityRecipe(UpdateSecurityRecipeRequest request) {
        Validate.notBlank((String)request.getSecurityRecipeId(), (String)"securityRecipeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSecurityRecipeDetails(), "updateSecurityRecipeDetails is required");
        return (UpdateSecurityRecipeResponse)this.clientCall(request, UpdateSecurityRecipeResponse::builder).logger(LOG, "updateSecurityRecipe").serviceDetails("CloudGuard", "UpdateSecurityRecipe", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/SecurityRecipe/UpdateSecurityRecipe").method(Method.PUT).requestBuilder(UpdateSecurityRecipeRequest::builder).basePath("/20200131").appendPathParam("securityRecipes").appendPathParam(request.getSecurityRecipeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SecurityRecipe.class, UpdateSecurityRecipeResponse.Builder::securityRecipe).handleResponseHeaderString("etag", UpdateSecurityRecipeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateSecurityRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateSecurityZoneResponse updateSecurityZone(UpdateSecurityZoneRequest request) {
        Validate.notBlank((String)request.getSecurityZoneId(), (String)"securityZoneId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSecurityZoneDetails(), "updateSecurityZoneDetails is required");
        return (UpdateSecurityZoneResponse)this.clientCall(request, UpdateSecurityZoneResponse::builder).logger(LOG, "updateSecurityZone").serviceDetails("CloudGuard", "UpdateSecurityZone", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/SecurityZone/UpdateSecurityZone").method(Method.PUT).requestBuilder(UpdateSecurityZoneRequest::builder).basePath("/20200131").appendPathParam("securityZones").appendPathParam(request.getSecurityZoneId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SecurityZone.class, UpdateSecurityZoneResponse.Builder::securityZone).handleResponseHeaderString("etag", UpdateSecurityZoneResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateSecurityZoneResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateTargetResponse updateTarget(UpdateTargetRequest request) {
        Validate.notBlank((String)request.getTargetId(), (String)"targetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTargetDetails(), "updateTargetDetails is required");
        return (UpdateTargetResponse)this.clientCall(request, UpdateTargetResponse::builder).logger(LOG, "updateTarget").serviceDetails("CloudGuard", "UpdateTarget", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/Target/UpdateTarget").method(Method.PUT).requestBuilder(UpdateTargetRequest::builder).basePath("/20200131").appendPathParam("targets").appendPathParam(request.getTargetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Target.class, UpdateTargetResponse.Builder::target).handleResponseHeaderString("etag", UpdateTargetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateTargetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateTargetDetectorRecipeResponse updateTargetDetectorRecipe(UpdateTargetDetectorRecipeRequest request) {
        Validate.notBlank((String)request.getTargetId(), (String)"targetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTargetDetectorRecipeId(), (String)"targetDetectorRecipeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTargetDetectorRecipeDetails(), "updateTargetDetectorRecipeDetails is required");
        return (UpdateTargetDetectorRecipeResponse)this.clientCall(request, UpdateTargetDetectorRecipeResponse::builder).logger(LOG, "updateTargetDetectorRecipe").serviceDetails("CloudGuard", "UpdateTargetDetectorRecipe", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/TargetDetectorRecipe/UpdateTargetDetectorRecipe").method(Method.PUT).requestBuilder(UpdateTargetDetectorRecipeRequest::builder).basePath("/20200131").appendPathParam("targets").appendPathParam(request.getTargetId()).appendPathParam("targetDetectorRecipes").appendPathParam(request.getTargetDetectorRecipeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TargetDetectorRecipe.class, UpdateTargetDetectorRecipeResponse.Builder::targetDetectorRecipe).handleResponseHeaderString("etag", UpdateTargetDetectorRecipeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateTargetDetectorRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateTargetDetectorRecipeDetectorRuleResponse updateTargetDetectorRecipeDetectorRule(UpdateTargetDetectorRecipeDetectorRuleRequest request) {
        Validate.notBlank((String)request.getTargetId(), (String)"targetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTargetDetectorRecipeId(), (String)"targetDetectorRecipeId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDetectorRuleId(), (String)"detectorRuleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTargetDetectorRecipeDetectorRuleDetails(), "updateTargetDetectorRecipeDetectorRuleDetails is required");
        return (UpdateTargetDetectorRecipeDetectorRuleResponse)this.clientCall(request, UpdateTargetDetectorRecipeDetectorRuleResponse::builder).logger(LOG, "updateTargetDetectorRecipeDetectorRule").serviceDetails("CloudGuard", "UpdateTargetDetectorRecipeDetectorRule", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/TargetDetectorRecipeDetectorRule/UpdateTargetDetectorRecipeDetectorRule").method(Method.PUT).requestBuilder(UpdateTargetDetectorRecipeDetectorRuleRequest::builder).basePath("/20200131").appendPathParam("targets").appendPathParam(request.getTargetId()).appendPathParam("targetDetectorRecipes").appendPathParam(request.getTargetDetectorRecipeId()).appendPathParam("detectorRules").appendPathParam(request.getDetectorRuleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TargetDetectorRecipeDetectorRule.class, UpdateTargetDetectorRecipeDetectorRuleResponse.Builder::targetDetectorRecipeDetectorRule).handleResponseHeaderString("etag", UpdateTargetDetectorRecipeDetectorRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateTargetDetectorRecipeDetectorRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateTargetResponderRecipeResponse updateTargetResponderRecipe(UpdateTargetResponderRecipeRequest request) {
        Validate.notBlank((String)request.getTargetId(), (String)"targetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTargetResponderRecipeId(), (String)"targetResponderRecipeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTargetResponderRecipeDetails(), "updateTargetResponderRecipeDetails is required");
        return (UpdateTargetResponderRecipeResponse)this.clientCall(request, UpdateTargetResponderRecipeResponse::builder).logger(LOG, "updateTargetResponderRecipe").serviceDetails("CloudGuard", "UpdateTargetResponderRecipe", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/TargetResponderRecipe/UpdateTargetResponderRecipe").method(Method.PUT).requestBuilder(UpdateTargetResponderRecipeRequest::builder).basePath("/20200131").appendPathParam("targets").appendPathParam(request.getTargetId()).appendPathParam("targetResponderRecipes").appendPathParam(request.getTargetResponderRecipeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TargetResponderRecipe.class, UpdateTargetResponderRecipeResponse.Builder::targetResponderRecipe).handleResponseHeaderString("etag", UpdateTargetResponderRecipeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateTargetResponderRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateTargetResponderRecipeResponderRuleResponse updateTargetResponderRecipeResponderRule(UpdateTargetResponderRecipeResponderRuleRequest request) {
        Validate.notBlank((String)request.getTargetId(), (String)"targetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTargetResponderRecipeId(), (String)"targetResponderRecipeId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getResponderRuleId(), (String)"responderRuleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTargetResponderRecipeResponderRuleDetails(), "updateTargetResponderRecipeResponderRuleDetails is required");
        return (UpdateTargetResponderRecipeResponderRuleResponse)this.clientCall(request, UpdateTargetResponderRecipeResponderRuleResponse::builder).logger(LOG, "updateTargetResponderRecipeResponderRule").serviceDetails("CloudGuard", "UpdateTargetResponderRecipeResponderRule", "https://docs.oracle.com/iaas/api/#/en/cloud-guard/20200131/TargetResponderRecipeResponderRule/UpdateTargetResponderRecipeResponderRule").method(Method.PUT).requestBuilder(UpdateTargetResponderRecipeResponderRuleRequest::builder).basePath("/20200131").appendPathParam("targets").appendPathParam(request.getTargetId()).appendPathParam("targetResponderRecipes").appendPathParam(request.getTargetResponderRecipeId()).appendPathParam("responderRules").appendPathParam(request.getResponderRuleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TargetResponderRecipeResponderRule.class, UpdateTargetResponderRecipeResponderRuleResponse.Builder::targetResponderRecipeResponderRule).handleResponseHeaderString("etag", UpdateTargetResponderRecipeResponderRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateTargetResponderRecipeResponderRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CloudGuardWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public CloudGuardPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public CloudGuardClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)CloudGuardClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public CloudGuardClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(CloudGuardClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public CloudGuardClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)CloudGuardClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public CloudGuardClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)CloudGuardClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public CloudGuardClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)CloudGuardClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public CloudGuardClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)CloudGuardClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public CloudGuardClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)CloudGuardClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public CloudGuardClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)CloudGuardClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, CloudGuardClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public CloudGuardClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new CloudGuardClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

