/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.DataSourceEventInfo;
import com.oracle.bmc.cloudguard.model.DataSourceEventInfoStatus;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DataSourceEventSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="region")
    private final String region;
    @JsonProperty(value="eventDate")
    private final Date eventDate;
    @JsonProperty(value="dataSourceId")
    private final String dataSourceId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="status")
    private final DataSourceEventInfoStatus status;
    @JsonProperty(value="comments")
    private final String comments;
    @JsonProperty(value="eventInfo")
    private final DataSourceEventInfo eventInfo;

    @Deprecated
    @ConstructorProperties(value={"region", "eventDate", "dataSourceId", "timeCreated", "status", "comments", "eventInfo"})
    public DataSourceEventSummary(String region, Date eventDate, String dataSourceId, Date timeCreated, DataSourceEventInfoStatus status, String comments, DataSourceEventInfo eventInfo) {
        this.region = region;
        this.eventDate = eventDate;
        this.dataSourceId = dataSourceId;
        this.timeCreated = timeCreated;
        this.status = status;
        this.comments = comments;
        this.eventInfo = eventInfo;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getRegion() {
        return this.region;
    }

    public Date getEventDate() {
        return this.eventDate;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public DataSourceEventInfoStatus getStatus() {
        return this.status;
    }

    public String getComments() {
        return this.comments;
    }

    public DataSourceEventInfo getEventInfo() {
        return this.eventInfo;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataSourceEventSummary(");
        sb.append("super=").append(super.toString());
        sb.append("region=").append(String.valueOf(this.region));
        sb.append(", eventDate=").append(String.valueOf(this.eventDate));
        sb.append(", dataSourceId=").append(String.valueOf(this.dataSourceId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", comments=").append(String.valueOf(this.comments));
        sb.append(", eventInfo=").append(String.valueOf((Object)this.eventInfo));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataSourceEventSummary)) {
            return false;
        }
        DataSourceEventSummary other = (DataSourceEventSummary)((Object)o);
        return Objects.equals(this.region, other.region) && Objects.equals(this.eventDate, other.eventDate) && Objects.equals(this.dataSourceId, other.dataSourceId) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.comments, other.comments) && Objects.equals((Object)this.eventInfo, (Object)other.eventInfo) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.region == null ? 43 : this.region.hashCode());
        result = result * 59 + (this.eventDate == null ? 43 : this.eventDate.hashCode());
        result = result * 59 + (this.dataSourceId == null ? 43 : this.dataSourceId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.comments == null ? 43 : this.comments.hashCode());
        result = result * 59 + (this.eventInfo == null ? 43 : this.eventInfo.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="region")
        private String region;
        @JsonProperty(value="eventDate")
        private Date eventDate;
        @JsonProperty(value="dataSourceId")
        private String dataSourceId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="status")
        private DataSourceEventInfoStatus status;
        @JsonProperty(value="comments")
        private String comments;
        @JsonProperty(value="eventInfo")
        private DataSourceEventInfo eventInfo;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder region(String region) {
            this.region = region;
            this.__explicitlySet__.add("region");
            return this;
        }

        public Builder eventDate(Date eventDate) {
            this.eventDate = eventDate;
            this.__explicitlySet__.add("eventDate");
            return this;
        }

        public Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            this.__explicitlySet__.add("dataSourceId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder status(DataSourceEventInfoStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder comments(String comments) {
            this.comments = comments;
            this.__explicitlySet__.add("comments");
            return this;
        }

        public Builder eventInfo(DataSourceEventInfo eventInfo) {
            this.eventInfo = eventInfo;
            this.__explicitlySet__.add("eventInfo");
            return this;
        }

        public DataSourceEventSummary build() {
            DataSourceEventSummary model = new DataSourceEventSummary(this.region, this.eventDate, this.dataSourceId, this.timeCreated, this.status, this.comments, this.eventInfo);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DataSourceEventSummary model) {
            if (model.wasPropertyExplicitlySet("region")) {
                this.region(model.getRegion());
            }
            if (model.wasPropertyExplicitlySet("eventDate")) {
                this.eventDate(model.getEventDate());
            }
            if (model.wasPropertyExplicitlySet("dataSourceId")) {
                this.dataSourceId(model.getDataSourceId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("comments")) {
                this.comments(model.getComments());
            }
            if (model.wasPropertyExplicitlySet("eventInfo")) {
                this.eventInfo(model.getEventInfo());
            }
            return this;
        }
    }
}

