/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.ConfigValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DetectorConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="configKey")
    private final String configKey;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="value")
    private final String value;
    @JsonProperty(value="dataType")
    private final String dataType;
    @JsonProperty(value="values")
    private final List<ConfigValue> values;

    @Deprecated
    @ConstructorProperties(value={"configKey", "name", "value", "dataType", "values"})
    public DetectorConfiguration(String configKey, String name, String value, String dataType, List<ConfigValue> values) {
        this.configKey = configKey;
        this.name = name;
        this.value = value;
        this.dataType = dataType;
        this.values = values;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getDataType() {
        return this.dataType;
    }

    public List<ConfigValue> getValues() {
        return this.values;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DetectorConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("configKey=").append(String.valueOf(this.configKey));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", value=").append(String.valueOf(this.value));
        sb.append(", dataType=").append(String.valueOf(this.dataType));
        sb.append(", values=").append(String.valueOf(this.values));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DetectorConfiguration)) {
            return false;
        }
        DetectorConfiguration other = (DetectorConfiguration)((Object)o);
        return Objects.equals(this.configKey, other.configKey) && Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value) && Objects.equals(this.dataType, other.dataType) && Objects.equals(this.values, other.values) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.configKey == null ? 43 : this.configKey.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + (this.dataType == null ? 43 : this.dataType.hashCode());
        result = result * 59 + (this.values == null ? 43 : this.values.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="configKey")
        private String configKey;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="value")
        private String value;
        @JsonProperty(value="dataType")
        private String dataType;
        @JsonProperty(value="values")
        private List<ConfigValue> values;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder configKey(String configKey) {
            this.configKey = configKey;
            this.__explicitlySet__.add("configKey");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder dataType(String dataType) {
            this.dataType = dataType;
            this.__explicitlySet__.add("dataType");
            return this;
        }

        public Builder values(List<ConfigValue> values) {
            this.values = values;
            this.__explicitlySet__.add("values");
            return this;
        }

        public DetectorConfiguration build() {
            DetectorConfiguration model = new DetectorConfiguration(this.configKey, this.name, this.value, this.dataType, this.values);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DetectorConfiguration model) {
            if (model.wasPropertyExplicitlySet("configKey")) {
                this.configKey(model.getConfigKey());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            if (model.wasPropertyExplicitlySet("dataType")) {
                this.dataType(model.getDataType());
            }
            if (model.wasPropertyExplicitlySet("values")) {
                this.values(model.getValues());
            }
            return this;
        }
    }
}

