/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.EntityType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EntitiesMapping
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="queryField")
    private final String queryField;
    @JsonProperty(value="entityType")
    private final EntityType entityType;

    @Deprecated
    @ConstructorProperties(value={"displayName", "queryField", "entityType"})
    public EntitiesMapping(String displayName, String queryField, EntityType entityType) {
        this.displayName = displayName;
        this.queryField = queryField;
        this.entityType = entityType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getQueryField() {
        return this.queryField;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EntitiesMapping(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", queryField=").append(String.valueOf(this.queryField));
        sb.append(", entityType=").append(String.valueOf((Object)this.entityType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntitiesMapping)) {
            return false;
        }
        EntitiesMapping other = (EntitiesMapping)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.queryField, other.queryField) && Objects.equals((Object)this.entityType, (Object)other.entityType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.queryField == null ? 43 : this.queryField.hashCode());
        result = result * 59 + (this.entityType == null ? 43 : this.entityType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="queryField")
        private String queryField;
        @JsonProperty(value="entityType")
        private EntityType entityType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder queryField(String queryField) {
            this.queryField = queryField;
            this.__explicitlySet__.add("queryField");
            return this;
        }

        public Builder entityType(EntityType entityType) {
            this.entityType = entityType;
            this.__explicitlySet__.add("entityType");
            return this;
        }

        public EntitiesMapping build() {
            EntitiesMapping model = new EntitiesMapping(this.displayName, this.queryField, this.entityType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EntitiesMapping model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("queryField")) {
                this.queryField(model.getQueryField());
            }
            if (model.wasPropertyExplicitlySet("entityType")) {
                this.entityType(model.getEntityType());
            }
            return this;
        }
    }
}

