/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.DataSourceEventInfo;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="dataSourceFeedProvider")
@JsonFilter(value="explicitlySetFilter")
public final class LoggingEventInfo
extends DataSourceEventInfo {
    @JsonProperty(value="observedValue")
    private final String observedValue;
    @JsonProperty(value="triggerValue")
    private final String triggerValue;
    @JsonProperty(value="operator")
    private final String operator;
    @JsonProperty(value="logResult")
    private final String logResult;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public LoggingEventInfo(String observedValue, String triggerValue, String operator, String logResult) {
        this.observedValue = observedValue;
        this.triggerValue = triggerValue;
        this.operator = operator;
        this.logResult = logResult;
    }

    public String getObservedValue() {
        return this.observedValue;
    }

    public String getTriggerValue() {
        return this.triggerValue;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getLogResult() {
        return this.logResult;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LoggingEventInfo(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", observedValue=").append(String.valueOf(this.observedValue));
        sb.append(", triggerValue=").append(String.valueOf(this.triggerValue));
        sb.append(", operator=").append(String.valueOf(this.operator));
        sb.append(", logResult=").append(String.valueOf(this.logResult));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoggingEventInfo)) {
            return false;
        }
        LoggingEventInfo other = (LoggingEventInfo)((Object)o);
        return Objects.equals(this.observedValue, other.observedValue) && Objects.equals(this.triggerValue, other.triggerValue) && Objects.equals(this.operator, other.operator) && Objects.equals(this.logResult, other.logResult) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.observedValue == null ? 43 : this.observedValue.hashCode());
        result = result * 59 + (this.triggerValue == null ? 43 : this.triggerValue.hashCode());
        result = result * 59 + (this.operator == null ? 43 : this.operator.hashCode());
        result = result * 59 + (this.logResult == null ? 43 : this.logResult.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="observedValue")
        private String observedValue;
        @JsonProperty(value="triggerValue")
        private String triggerValue;
        @JsonProperty(value="operator")
        private String operator;
        @JsonProperty(value="logResult")
        private String logResult;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder observedValue(String observedValue) {
            this.observedValue = observedValue;
            this.__explicitlySet__.add("observedValue");
            return this;
        }

        public Builder triggerValue(String triggerValue) {
            this.triggerValue = triggerValue;
            this.__explicitlySet__.add("triggerValue");
            return this;
        }

        public Builder operator(String operator) {
            this.operator = operator;
            this.__explicitlySet__.add("operator");
            return this;
        }

        public Builder logResult(String logResult) {
            this.logResult = logResult;
            this.__explicitlySet__.add("logResult");
            return this;
        }

        public LoggingEventInfo build() {
            LoggingEventInfo model = new LoggingEventInfo(this.observedValue, this.triggerValue, this.operator, this.logResult);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LoggingEventInfo model) {
            if (model.wasPropertyExplicitlySet("observedValue")) {
                this.observedValue(model.getObservedValue());
            }
            if (model.wasPropertyExplicitlySet("triggerValue")) {
                this.triggerValue(model.getTriggerValue());
            }
            if (model.wasPropertyExplicitlySet("operator")) {
                this.operator(model.getOperator());
            }
            if (model.wasPropertyExplicitlySet("logResult")) {
                this.logResult(model.getLogResult());
            }
            return this;
        }
    }
}

