/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.ConditionFilterType;
import com.oracle.bmc.cloudguard.model.ConditionOperator;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OperatorSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="datatype")
    private final String datatype;
    @JsonProperty(value="managedListtype")
    private final String managedListtype;
    @JsonProperty(value="filterType")
    private final ConditionFilterType filterType;
    @JsonProperty(value="operators")
    private final List<ConditionOperator> operators;
    @JsonProperty(value="multiListTypes")
    private final List<String> multiListTypes;

    @Deprecated
    @ConstructorProperties(value={"name", "displayName", "datatype", "managedListtype", "filterType", "operators", "multiListTypes"})
    public OperatorSummary(String name, String displayName, String datatype, String managedListtype, ConditionFilterType filterType, List<ConditionOperator> operators, List<String> multiListTypes) {
        this.name = name;
        this.displayName = displayName;
        this.datatype = datatype;
        this.managedListtype = managedListtype;
        this.filterType = filterType;
        this.operators = operators;
        this.multiListTypes = multiListTypes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public String getManagedListtype() {
        return this.managedListtype;
    }

    public ConditionFilterType getFilterType() {
        return this.filterType;
    }

    public List<ConditionOperator> getOperators() {
        return this.operators;
    }

    public List<String> getMultiListTypes() {
        return this.multiListTypes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OperatorSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", datatype=").append(String.valueOf(this.datatype));
        sb.append(", managedListtype=").append(String.valueOf(this.managedListtype));
        sb.append(", filterType=").append(String.valueOf((Object)this.filterType));
        sb.append(", operators=").append(String.valueOf(this.operators));
        sb.append(", multiListTypes=").append(String.valueOf(this.multiListTypes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OperatorSummary)) {
            return false;
        }
        OperatorSummary other = (OperatorSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.datatype, other.datatype) && Objects.equals(this.managedListtype, other.managedListtype) && Objects.equals((Object)this.filterType, (Object)other.filterType) && Objects.equals(this.operators, other.operators) && Objects.equals(this.multiListTypes, other.multiListTypes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.datatype == null ? 43 : this.datatype.hashCode());
        result = result * 59 + (this.managedListtype == null ? 43 : this.managedListtype.hashCode());
        result = result * 59 + (this.filterType == null ? 43 : this.filterType.hashCode());
        result = result * 59 + (this.operators == null ? 43 : this.operators.hashCode());
        result = result * 59 + (this.multiListTypes == null ? 43 : this.multiListTypes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="datatype")
        private String datatype;
        @JsonProperty(value="managedListtype")
        private String managedListtype;
        @JsonProperty(value="filterType")
        private ConditionFilterType filterType;
        @JsonProperty(value="operators")
        private List<ConditionOperator> operators;
        @JsonProperty(value="multiListTypes")
        private List<String> multiListTypes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder datatype(String datatype) {
            this.datatype = datatype;
            this.__explicitlySet__.add("datatype");
            return this;
        }

        public Builder managedListtype(String managedListtype) {
            this.managedListtype = managedListtype;
            this.__explicitlySet__.add("managedListtype");
            return this;
        }

        public Builder filterType(ConditionFilterType filterType) {
            this.filterType = filterType;
            this.__explicitlySet__.add("filterType");
            return this;
        }

        public Builder operators(List<ConditionOperator> operators) {
            this.operators = operators;
            this.__explicitlySet__.add("operators");
            return this;
        }

        public Builder multiListTypes(List<String> multiListTypes) {
            this.multiListTypes = multiListTypes;
            this.__explicitlySet__.add("multiListTypes");
            return this;
        }

        public OperatorSummary build() {
            OperatorSummary model = new OperatorSummary(this.name, this.displayName, this.datatype, this.managedListtype, this.filterType, this.operators, this.multiListTypes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OperatorSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("datatype")) {
                this.datatype(model.getDatatype());
            }
            if (model.wasPropertyExplicitlySet("managedListtype")) {
                this.managedListtype(model.getManagedListtype());
            }
            if (model.wasPropertyExplicitlySet("filterType")) {
                this.filterType(model.getFilterType());
            }
            if (model.wasPropertyExplicitlySet("operators")) {
                this.operators(model.getOperators());
            }
            if (model.wasPropertyExplicitlySet("multiListTypes")) {
                this.multiListTypes(model.getMultiListTypes());
            }
            return this;
        }
    }
}

