/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.ActorType;
import com.oracle.bmc.cloudguard.model.EventStatus;
import com.oracle.bmc.cloudguard.model.ProblemLifecycleDetail;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ProblemHistorySummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="problemId")
    private final String problemId;
    @JsonProperty(value="actorType")
    private final ActorType actorType;
    @JsonProperty(value="actorName")
    private final String actorName;
    @JsonProperty(value="explanation")
    private final String explanation;
    @JsonProperty(value="lifecycleDetail")
    private final ProblemLifecycleDetail lifecycleDetail;
    @JsonProperty(value="eventStatus")
    private final EventStatus eventStatus;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="delta")
    private final String delta;
    @JsonProperty(value="comment")
    private final String comment;

    @Deprecated
    @ConstructorProperties(value={"id", "problemId", "actorType", "actorName", "explanation", "lifecycleDetail", "eventStatus", "timeCreated", "delta", "comment"})
    public ProblemHistorySummary(String id, String problemId, ActorType actorType, String actorName, String explanation, ProblemLifecycleDetail lifecycleDetail, EventStatus eventStatus, Date timeCreated, String delta, String comment) {
        this.id = id;
        this.problemId = problemId;
        this.actorType = actorType;
        this.actorName = actorName;
        this.explanation = explanation;
        this.lifecycleDetail = lifecycleDetail;
        this.eventStatus = eventStatus;
        this.timeCreated = timeCreated;
        this.delta = delta;
        this.comment = comment;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getProblemId() {
        return this.problemId;
    }

    public ActorType getActorType() {
        return this.actorType;
    }

    public String getActorName() {
        return this.actorName;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public ProblemLifecycleDetail getLifecycleDetail() {
        return this.lifecycleDetail;
    }

    public EventStatus getEventStatus() {
        return this.eventStatus;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getDelta() {
        return this.delta;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ProblemHistorySummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", problemId=").append(String.valueOf(this.problemId));
        sb.append(", actorType=").append(String.valueOf((Object)this.actorType));
        sb.append(", actorName=").append(String.valueOf(this.actorName));
        sb.append(", explanation=").append(String.valueOf(this.explanation));
        sb.append(", lifecycleDetail=").append(String.valueOf((Object)this.lifecycleDetail));
        sb.append(", eventStatus=").append(String.valueOf((Object)this.eventStatus));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", delta=").append(String.valueOf(this.delta));
        sb.append(", comment=").append(String.valueOf(this.comment));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProblemHistorySummary)) {
            return false;
        }
        ProblemHistorySummary other = (ProblemHistorySummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.problemId, other.problemId) && Objects.equals((Object)this.actorType, (Object)other.actorType) && Objects.equals(this.actorName, other.actorName) && Objects.equals(this.explanation, other.explanation) && Objects.equals((Object)this.lifecycleDetail, (Object)other.lifecycleDetail) && Objects.equals((Object)this.eventStatus, (Object)other.eventStatus) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.delta, other.delta) && Objects.equals(this.comment, other.comment) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.problemId == null ? 43 : this.problemId.hashCode());
        result = result * 59 + (this.actorType == null ? 43 : this.actorType.hashCode());
        result = result * 59 + (this.actorName == null ? 43 : this.actorName.hashCode());
        result = result * 59 + (this.explanation == null ? 43 : this.explanation.hashCode());
        result = result * 59 + (this.lifecycleDetail == null ? 43 : this.lifecycleDetail.hashCode());
        result = result * 59 + (this.eventStatus == null ? 43 : this.eventStatus.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.delta == null ? 43 : this.delta.hashCode());
        result = result * 59 + (this.comment == null ? 43 : this.comment.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="problemId")
        private String problemId;
        @JsonProperty(value="actorType")
        private ActorType actorType;
        @JsonProperty(value="actorName")
        private String actorName;
        @JsonProperty(value="explanation")
        private String explanation;
        @JsonProperty(value="lifecycleDetail")
        private ProblemLifecycleDetail lifecycleDetail;
        @JsonProperty(value="eventStatus")
        private EventStatus eventStatus;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="delta")
        private String delta;
        @JsonProperty(value="comment")
        private String comment;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder problemId(String problemId) {
            this.problemId = problemId;
            this.__explicitlySet__.add("problemId");
            return this;
        }

        public Builder actorType(ActorType actorType) {
            this.actorType = actorType;
            this.__explicitlySet__.add("actorType");
            return this;
        }

        public Builder actorName(String actorName) {
            this.actorName = actorName;
            this.__explicitlySet__.add("actorName");
            return this;
        }

        public Builder explanation(String explanation) {
            this.explanation = explanation;
            this.__explicitlySet__.add("explanation");
            return this;
        }

        public Builder lifecycleDetail(ProblemLifecycleDetail lifecycleDetail) {
            this.lifecycleDetail = lifecycleDetail;
            this.__explicitlySet__.add("lifecycleDetail");
            return this;
        }

        public Builder eventStatus(EventStatus eventStatus) {
            this.eventStatus = eventStatus;
            this.__explicitlySet__.add("eventStatus");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder delta(String delta) {
            this.delta = delta;
            this.__explicitlySet__.add("delta");
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            this.__explicitlySet__.add("comment");
            return this;
        }

        public ProblemHistorySummary build() {
            ProblemHistorySummary model = new ProblemHistorySummary(this.id, this.problemId, this.actorType, this.actorName, this.explanation, this.lifecycleDetail, this.eventStatus, this.timeCreated, this.delta, this.comment);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ProblemHistorySummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("problemId")) {
                this.problemId(model.getProblemId());
            }
            if (model.wasPropertyExplicitlySet("actorType")) {
                this.actorType(model.getActorType());
            }
            if (model.wasPropertyExplicitlySet("actorName")) {
                this.actorName(model.getActorName());
            }
            if (model.wasPropertyExplicitlySet("explanation")) {
                this.explanation(model.getExplanation());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetail")) {
                this.lifecycleDetail(model.getLifecycleDetail());
            }
            if (model.wasPropertyExplicitlySet("eventStatus")) {
                this.eventStatus(model.getEventStatus());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("delta")) {
                this.delta(model.getDelta());
            }
            if (model.wasPropertyExplicitlySet("comment")) {
                this.comment(model.getComment());
            }
            return this;
        }
    }
}

