/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.RiskLevel;
import com.oracle.bmc.cloudguard.model.TacticSummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ResourceProfile
extends ExplicitlySetBmcModel {
    @JsonProperty(value="sightingsCount")
    private final Integer sightingsCount;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="problemIds")
    private final List<String> problemIds;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="targetId")
    private final String targetId;
    @JsonProperty(value="riskScore")
    private final Double riskScore;
    @JsonProperty(value="riskLevel")
    private final RiskLevel riskLevel;
    @JsonProperty(value="peakRiskScore")
    private final Double peakRiskScore;
    @JsonProperty(value="timePeakScore")
    private final Date timePeakScore;
    @JsonProperty(value="timeFirstDetected")
    private final Date timeFirstDetected;
    @JsonProperty(value="timeLastDetected")
    private final Date timeLastDetected;
    @JsonProperty(value="tactics")
    private final List<TacticSummary> tactics;

    @Deprecated
    @ConstructorProperties(value={"sightingsCount", "id", "resourceId", "displayName", "type", "problemIds", "compartmentId", "targetId", "riskScore", "riskLevel", "peakRiskScore", "timePeakScore", "timeFirstDetected", "timeLastDetected", "tactics"})
    public ResourceProfile(Integer sightingsCount, String id, String resourceId, String displayName, String type, List<String> problemIds, String compartmentId, String targetId, Double riskScore, RiskLevel riskLevel, Double peakRiskScore, Date timePeakScore, Date timeFirstDetected, Date timeLastDetected, List<TacticSummary> tactics) {
        this.sightingsCount = sightingsCount;
        this.id = id;
        this.resourceId = resourceId;
        this.displayName = displayName;
        this.type = type;
        this.problemIds = problemIds;
        this.compartmentId = compartmentId;
        this.targetId = targetId;
        this.riskScore = riskScore;
        this.riskLevel = riskLevel;
        this.peakRiskScore = peakRiskScore;
        this.timePeakScore = timePeakScore;
        this.timeFirstDetected = timeFirstDetected;
        this.timeLastDetected = timeLastDetected;
        this.tactics = tactics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getSightingsCount() {
        return this.sightingsCount;
    }

    public String getId() {
        return this.id;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getType() {
        return this.type;
    }

    public List<String> getProblemIds() {
        return this.problemIds;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public Double getRiskScore() {
        return this.riskScore;
    }

    public RiskLevel getRiskLevel() {
        return this.riskLevel;
    }

    public Double getPeakRiskScore() {
        return this.peakRiskScore;
    }

    public Date getTimePeakScore() {
        return this.timePeakScore;
    }

    public Date getTimeFirstDetected() {
        return this.timeFirstDetected;
    }

    public Date getTimeLastDetected() {
        return this.timeLastDetected;
    }

    public List<TacticSummary> getTactics() {
        return this.tactics;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ResourceProfile(");
        sb.append("super=").append(super.toString());
        sb.append("sightingsCount=").append(String.valueOf(this.sightingsCount));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", resourceId=").append(String.valueOf(this.resourceId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", type=").append(String.valueOf(this.type));
        sb.append(", problemIds=").append(String.valueOf(this.problemIds));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", targetId=").append(String.valueOf(this.targetId));
        sb.append(", riskScore=").append(String.valueOf(this.riskScore));
        sb.append(", riskLevel=").append(String.valueOf((Object)this.riskLevel));
        sb.append(", peakRiskScore=").append(String.valueOf(this.peakRiskScore));
        sb.append(", timePeakScore=").append(String.valueOf(this.timePeakScore));
        sb.append(", timeFirstDetected=").append(String.valueOf(this.timeFirstDetected));
        sb.append(", timeLastDetected=").append(String.valueOf(this.timeLastDetected));
        sb.append(", tactics=").append(String.valueOf(this.tactics));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceProfile)) {
            return false;
        }
        ResourceProfile other = (ResourceProfile)((Object)o);
        return Objects.equals(this.sightingsCount, other.sightingsCount) && Objects.equals(this.id, other.id) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.type, other.type) && Objects.equals(this.problemIds, other.problemIds) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.riskScore, other.riskScore) && Objects.equals((Object)this.riskLevel, (Object)other.riskLevel) && Objects.equals(this.peakRiskScore, other.peakRiskScore) && Objects.equals(this.timePeakScore, other.timePeakScore) && Objects.equals(this.timeFirstDetected, other.timeFirstDetected) && Objects.equals(this.timeLastDetected, other.timeLastDetected) && Objects.equals(this.tactics, other.tactics) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.sightingsCount == null ? 43 : this.sightingsCount.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.problemIds == null ? 43 : this.problemIds.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.riskScore == null ? 43 : this.riskScore.hashCode());
        result = result * 59 + (this.riskLevel == null ? 43 : this.riskLevel.hashCode());
        result = result * 59 + (this.peakRiskScore == null ? 43 : this.peakRiskScore.hashCode());
        result = result * 59 + (this.timePeakScore == null ? 43 : this.timePeakScore.hashCode());
        result = result * 59 + (this.timeFirstDetected == null ? 43 : this.timeFirstDetected.hashCode());
        result = result * 59 + (this.timeLastDetected == null ? 43 : this.timeLastDetected.hashCode());
        result = result * 59 + (this.tactics == null ? 43 : this.tactics.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="sightingsCount")
        private Integer sightingsCount;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="problemIds")
        private List<String> problemIds;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonProperty(value="riskScore")
        private Double riskScore;
        @JsonProperty(value="riskLevel")
        private RiskLevel riskLevel;
        @JsonProperty(value="peakRiskScore")
        private Double peakRiskScore;
        @JsonProperty(value="timePeakScore")
        private Date timePeakScore;
        @JsonProperty(value="timeFirstDetected")
        private Date timeFirstDetected;
        @JsonProperty(value="timeLastDetected")
        private Date timeLastDetected;
        @JsonProperty(value="tactics")
        private List<TacticSummary> tactics;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder sightingsCount(Integer sightingsCount) {
            this.sightingsCount = sightingsCount;
            this.__explicitlySet__.add("sightingsCount");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder problemIds(List<String> problemIds) {
            this.problemIds = problemIds;
            this.__explicitlySet__.add("problemIds");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder riskScore(Double riskScore) {
            this.riskScore = riskScore;
            this.__explicitlySet__.add("riskScore");
            return this;
        }

        public Builder riskLevel(RiskLevel riskLevel) {
            this.riskLevel = riskLevel;
            this.__explicitlySet__.add("riskLevel");
            return this;
        }

        public Builder peakRiskScore(Double peakRiskScore) {
            this.peakRiskScore = peakRiskScore;
            this.__explicitlySet__.add("peakRiskScore");
            return this;
        }

        public Builder timePeakScore(Date timePeakScore) {
            this.timePeakScore = timePeakScore;
            this.__explicitlySet__.add("timePeakScore");
            return this;
        }

        public Builder timeFirstDetected(Date timeFirstDetected) {
            this.timeFirstDetected = timeFirstDetected;
            this.__explicitlySet__.add("timeFirstDetected");
            return this;
        }

        public Builder timeLastDetected(Date timeLastDetected) {
            this.timeLastDetected = timeLastDetected;
            this.__explicitlySet__.add("timeLastDetected");
            return this;
        }

        public Builder tactics(List<TacticSummary> tactics) {
            this.tactics = tactics;
            this.__explicitlySet__.add("tactics");
            return this;
        }

        public ResourceProfile build() {
            ResourceProfile model = new ResourceProfile(this.sightingsCount, this.id, this.resourceId, this.displayName, this.type, this.problemIds, this.compartmentId, this.targetId, this.riskScore, this.riskLevel, this.peakRiskScore, this.timePeakScore, this.timeFirstDetected, this.timeLastDetected, this.tactics);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ResourceProfile model) {
            if (model.wasPropertyExplicitlySet("sightingsCount")) {
                this.sightingsCount(model.getSightingsCount());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("problemIds")) {
                this.problemIds(model.getProblemIds());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("riskScore")) {
                this.riskScore(model.getRiskScore());
            }
            if (model.wasPropertyExplicitlySet("riskLevel")) {
                this.riskLevel(model.getRiskLevel());
            }
            if (model.wasPropertyExplicitlySet("peakRiskScore")) {
                this.peakRiskScore(model.getPeakRiskScore());
            }
            if (model.wasPropertyExplicitlySet("timePeakScore")) {
                this.timePeakScore(model.getTimePeakScore());
            }
            if (model.wasPropertyExplicitlySet("timeFirstDetected")) {
                this.timeFirstDetected(model.getTimeFirstDetected());
            }
            if (model.wasPropertyExplicitlySet("timeLastDetected")) {
                this.timeLastDetected(model.getTimeLastDetected());
            }
            if (model.wasPropertyExplicitlySet("tactics")) {
                this.tactics(model.getTactics());
            }
            return this;
        }
    }
}

