/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ResourceProfileEndpointSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="resourceProfileId")
    private final String resourceProfileId;
    @JsonProperty(value="problemId")
    private final String problemId;
    @JsonProperty(value="sightingType")
    private final String sightingType;
    @JsonProperty(value="sightingTypeDisplayName")
    private final String sightingTypeDisplayName;
    @JsonProperty(value="ipAddress")
    private final String ipAddress;
    @JsonProperty(value="ipAddressType")
    private final String ipAddressType;
    @JsonProperty(value="ipClassificationType")
    private final String ipClassificationType;
    @JsonProperty(value="country")
    private final String country;
    @JsonProperty(value="latitude")
    private final Double latitude;
    @JsonProperty(value="longitude")
    private final Double longitude;
    @JsonProperty(value="asnNumber")
    private final String asnNumber;
    @JsonProperty(value="regions")
    private final List<String> regions;
    @JsonProperty(value="services")
    private final List<String> services;
    @JsonProperty(value="timeLastDetected")
    private final Date timeLastDetected;

    @Deprecated
    @ConstructorProperties(value={"id", "resourceProfileId", "problemId", "sightingType", "sightingTypeDisplayName", "ipAddress", "ipAddressType", "ipClassificationType", "country", "latitude", "longitude", "asnNumber", "regions", "services", "timeLastDetected"})
    public ResourceProfileEndpointSummary(String id, String resourceProfileId, String problemId, String sightingType, String sightingTypeDisplayName, String ipAddress, String ipAddressType, String ipClassificationType, String country, Double latitude, Double longitude, String asnNumber, List<String> regions, List<String> services, Date timeLastDetected) {
        this.id = id;
        this.resourceProfileId = resourceProfileId;
        this.problemId = problemId;
        this.sightingType = sightingType;
        this.sightingTypeDisplayName = sightingTypeDisplayName;
        this.ipAddress = ipAddress;
        this.ipAddressType = ipAddressType;
        this.ipClassificationType = ipClassificationType;
        this.country = country;
        this.latitude = latitude;
        this.longitude = longitude;
        this.asnNumber = asnNumber;
        this.regions = regions;
        this.services = services;
        this.timeLastDetected = timeLastDetected;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getResourceProfileId() {
        return this.resourceProfileId;
    }

    public String getProblemId() {
        return this.problemId;
    }

    public String getSightingType() {
        return this.sightingType;
    }

    public String getSightingTypeDisplayName() {
        return this.sightingTypeDisplayName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getIpAddressType() {
        return this.ipAddressType;
    }

    public String getIpClassificationType() {
        return this.ipClassificationType;
    }

    public String getCountry() {
        return this.country;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public String getAsnNumber() {
        return this.asnNumber;
    }

    public List<String> getRegions() {
        return this.regions;
    }

    public List<String> getServices() {
        return this.services;
    }

    public Date getTimeLastDetected() {
        return this.timeLastDetected;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ResourceProfileEndpointSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", resourceProfileId=").append(String.valueOf(this.resourceProfileId));
        sb.append(", problemId=").append(String.valueOf(this.problemId));
        sb.append(", sightingType=").append(String.valueOf(this.sightingType));
        sb.append(", sightingTypeDisplayName=").append(String.valueOf(this.sightingTypeDisplayName));
        sb.append(", ipAddress=").append(String.valueOf(this.ipAddress));
        sb.append(", ipAddressType=").append(String.valueOf(this.ipAddressType));
        sb.append(", ipClassificationType=").append(String.valueOf(this.ipClassificationType));
        sb.append(", country=").append(String.valueOf(this.country));
        sb.append(", latitude=").append(String.valueOf(this.latitude));
        sb.append(", longitude=").append(String.valueOf(this.longitude));
        sb.append(", asnNumber=").append(String.valueOf(this.asnNumber));
        sb.append(", regions=").append(String.valueOf(this.regions));
        sb.append(", services=").append(String.valueOf(this.services));
        sb.append(", timeLastDetected=").append(String.valueOf(this.timeLastDetected));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceProfileEndpointSummary)) {
            return false;
        }
        ResourceProfileEndpointSummary other = (ResourceProfileEndpointSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.resourceProfileId, other.resourceProfileId) && Objects.equals(this.problemId, other.problemId) && Objects.equals(this.sightingType, other.sightingType) && Objects.equals(this.sightingTypeDisplayName, other.sightingTypeDisplayName) && Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.ipAddressType, other.ipAddressType) && Objects.equals(this.ipClassificationType, other.ipClassificationType) && Objects.equals(this.country, other.country) && Objects.equals(this.latitude, other.latitude) && Objects.equals(this.longitude, other.longitude) && Objects.equals(this.asnNumber, other.asnNumber) && Objects.equals(this.regions, other.regions) && Objects.equals(this.services, other.services) && Objects.equals(this.timeLastDetected, other.timeLastDetected) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.resourceProfileId == null ? 43 : this.resourceProfileId.hashCode());
        result = result * 59 + (this.problemId == null ? 43 : this.problemId.hashCode());
        result = result * 59 + (this.sightingType == null ? 43 : this.sightingType.hashCode());
        result = result * 59 + (this.sightingTypeDisplayName == null ? 43 : this.sightingTypeDisplayName.hashCode());
        result = result * 59 + (this.ipAddress == null ? 43 : this.ipAddress.hashCode());
        result = result * 59 + (this.ipAddressType == null ? 43 : this.ipAddressType.hashCode());
        result = result * 59 + (this.ipClassificationType == null ? 43 : this.ipClassificationType.hashCode());
        result = result * 59 + (this.country == null ? 43 : this.country.hashCode());
        result = result * 59 + (this.latitude == null ? 43 : this.latitude.hashCode());
        result = result * 59 + (this.longitude == null ? 43 : this.longitude.hashCode());
        result = result * 59 + (this.asnNumber == null ? 43 : this.asnNumber.hashCode());
        result = result * 59 + (this.regions == null ? 43 : this.regions.hashCode());
        result = result * 59 + (this.services == null ? 43 : this.services.hashCode());
        result = result * 59 + (this.timeLastDetected == null ? 43 : this.timeLastDetected.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="resourceProfileId")
        private String resourceProfileId;
        @JsonProperty(value="problemId")
        private String problemId;
        @JsonProperty(value="sightingType")
        private String sightingType;
        @JsonProperty(value="sightingTypeDisplayName")
        private String sightingTypeDisplayName;
        @JsonProperty(value="ipAddress")
        private String ipAddress;
        @JsonProperty(value="ipAddressType")
        private String ipAddressType;
        @JsonProperty(value="ipClassificationType")
        private String ipClassificationType;
        @JsonProperty(value="country")
        private String country;
        @JsonProperty(value="latitude")
        private Double latitude;
        @JsonProperty(value="longitude")
        private Double longitude;
        @JsonProperty(value="asnNumber")
        private String asnNumber;
        @JsonProperty(value="regions")
        private List<String> regions;
        @JsonProperty(value="services")
        private List<String> services;
        @JsonProperty(value="timeLastDetected")
        private Date timeLastDetected;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder resourceProfileId(String resourceProfileId) {
            this.resourceProfileId = resourceProfileId;
            this.__explicitlySet__.add("resourceProfileId");
            return this;
        }

        public Builder problemId(String problemId) {
            this.problemId = problemId;
            this.__explicitlySet__.add("problemId");
            return this;
        }

        public Builder sightingType(String sightingType) {
            this.sightingType = sightingType;
            this.__explicitlySet__.add("sightingType");
            return this;
        }

        public Builder sightingTypeDisplayName(String sightingTypeDisplayName) {
            this.sightingTypeDisplayName = sightingTypeDisplayName;
            this.__explicitlySet__.add("sightingTypeDisplayName");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.__explicitlySet__.add("ipAddress");
            return this;
        }

        public Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            this.__explicitlySet__.add("ipAddressType");
            return this;
        }

        public Builder ipClassificationType(String ipClassificationType) {
            this.ipClassificationType = ipClassificationType;
            this.__explicitlySet__.add("ipClassificationType");
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            this.__explicitlySet__.add("country");
            return this;
        }

        public Builder latitude(Double latitude) {
            this.latitude = latitude;
            this.__explicitlySet__.add("latitude");
            return this;
        }

        public Builder longitude(Double longitude) {
            this.longitude = longitude;
            this.__explicitlySet__.add("longitude");
            return this;
        }

        public Builder asnNumber(String asnNumber) {
            this.asnNumber = asnNumber;
            this.__explicitlySet__.add("asnNumber");
            return this;
        }

        public Builder regions(List<String> regions) {
            this.regions = regions;
            this.__explicitlySet__.add("regions");
            return this;
        }

        public Builder services(List<String> services) {
            this.services = services;
            this.__explicitlySet__.add("services");
            return this;
        }

        public Builder timeLastDetected(Date timeLastDetected) {
            this.timeLastDetected = timeLastDetected;
            this.__explicitlySet__.add("timeLastDetected");
            return this;
        }

        public ResourceProfileEndpointSummary build() {
            ResourceProfileEndpointSummary model = new ResourceProfileEndpointSummary(this.id, this.resourceProfileId, this.problemId, this.sightingType, this.sightingTypeDisplayName, this.ipAddress, this.ipAddressType, this.ipClassificationType, this.country, this.latitude, this.longitude, this.asnNumber, this.regions, this.services, this.timeLastDetected);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ResourceProfileEndpointSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("resourceProfileId")) {
                this.resourceProfileId(model.getResourceProfileId());
            }
            if (model.wasPropertyExplicitlySet("problemId")) {
                this.problemId(model.getProblemId());
            }
            if (model.wasPropertyExplicitlySet("sightingType")) {
                this.sightingType(model.getSightingType());
            }
            if (model.wasPropertyExplicitlySet("sightingTypeDisplayName")) {
                this.sightingTypeDisplayName(model.getSightingTypeDisplayName());
            }
            if (model.wasPropertyExplicitlySet("ipAddress")) {
                this.ipAddress(model.getIpAddress());
            }
            if (model.wasPropertyExplicitlySet("ipAddressType")) {
                this.ipAddressType(model.getIpAddressType());
            }
            if (model.wasPropertyExplicitlySet("ipClassificationType")) {
                this.ipClassificationType(model.getIpClassificationType());
            }
            if (model.wasPropertyExplicitlySet("country")) {
                this.country(model.getCountry());
            }
            if (model.wasPropertyExplicitlySet("latitude")) {
                this.latitude(model.getLatitude());
            }
            if (model.wasPropertyExplicitlySet("longitude")) {
                this.longitude(model.getLongitude());
            }
            if (model.wasPropertyExplicitlySet("asnNumber")) {
                this.asnNumber(model.getAsnNumber());
            }
            if (model.wasPropertyExplicitlySet("regions")) {
                this.regions(model.getRegions());
            }
            if (model.wasPropertyExplicitlySet("services")) {
                this.services(model.getServices());
            }
            if (model.wasPropertyExplicitlySet("timeLastDetected")) {
                this.timeLastDetected(model.getTimeLastDetected());
            }
            return this;
        }
    }
}

