/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.ResourceRiskScoreAggregation;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ResourceRiskScoreAggregationCollection
extends ExplicitlySetBmcModel {
    @JsonProperty(value="filterType")
    private final String filterType;
    @JsonProperty(value="filterId")
    private final String filterId;
    @JsonProperty(value="riskThreshold")
    private final Integer riskThreshold;
    @JsonProperty(value="items")
    private final List<ResourceRiskScoreAggregation> items;

    @Deprecated
    @ConstructorProperties(value={"filterType", "filterId", "riskThreshold", "items"})
    public ResourceRiskScoreAggregationCollection(String filterType, String filterId, Integer riskThreshold, List<ResourceRiskScoreAggregation> items) {
        this.filterType = filterType;
        this.filterId = filterId;
        this.riskThreshold = riskThreshold;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getFilterType() {
        return this.filterType;
    }

    public String getFilterId() {
        return this.filterId;
    }

    public Integer getRiskThreshold() {
        return this.riskThreshold;
    }

    public List<ResourceRiskScoreAggregation> getItems() {
        return this.items;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ResourceRiskScoreAggregationCollection(");
        sb.append("super=").append(super.toString());
        sb.append("filterType=").append(String.valueOf(this.filterType));
        sb.append(", filterId=").append(String.valueOf(this.filterId));
        sb.append(", riskThreshold=").append(String.valueOf(this.riskThreshold));
        sb.append(", items=").append(String.valueOf(this.items));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceRiskScoreAggregationCollection)) {
            return false;
        }
        ResourceRiskScoreAggregationCollection other = (ResourceRiskScoreAggregationCollection)((Object)o);
        return Objects.equals(this.filterType, other.filterType) && Objects.equals(this.filterId, other.filterId) && Objects.equals(this.riskThreshold, other.riskThreshold) && Objects.equals(this.items, other.items) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.filterType == null ? 43 : this.filterType.hashCode());
        result = result * 59 + (this.filterId == null ? 43 : this.filterId.hashCode());
        result = result * 59 + (this.riskThreshold == null ? 43 : this.riskThreshold.hashCode());
        result = result * 59 + (this.items == null ? 43 : this.items.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="filterType")
        private String filterType;
        @JsonProperty(value="filterId")
        private String filterId;
        @JsonProperty(value="riskThreshold")
        private Integer riskThreshold;
        @JsonProperty(value="items")
        private List<ResourceRiskScoreAggregation> items;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder filterType(String filterType) {
            this.filterType = filterType;
            this.__explicitlySet__.add("filterType");
            return this;
        }

        public Builder filterId(String filterId) {
            this.filterId = filterId;
            this.__explicitlySet__.add("filterId");
            return this;
        }

        public Builder riskThreshold(Integer riskThreshold) {
            this.riskThreshold = riskThreshold;
            this.__explicitlySet__.add("riskThreshold");
            return this;
        }

        public Builder items(List<ResourceRiskScoreAggregation> items) {
            this.items = items;
            this.__explicitlySet__.add("items");
            return this;
        }

        public ResourceRiskScoreAggregationCollection build() {
            ResourceRiskScoreAggregationCollection model = new ResourceRiskScoreAggregationCollection(this.filterType, this.filterId, this.riskThreshold, this.items);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ResourceRiskScoreAggregationCollection model) {
            if (model.wasPropertyExplicitlySet("filterType")) {
                this.filterType(model.getFilterType());
            }
            if (model.wasPropertyExplicitlySet("filterId")) {
                this.filterId(model.getFilterId());
            }
            if (model.wasPropertyExplicitlySet("riskThreshold")) {
                this.riskThreshold(model.getRiskThreshold());
            }
            if (model.wasPropertyExplicitlySet("items")) {
                this.items(model.getItems());
            }
            return this;
        }
    }
}

