/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.SecurityRating;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SecurityScoreAggregation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="dimensionsMap")
    private final Map<String, String> dimensionsMap;
    @JsonProperty(value="securityRating")
    private final SecurityRating securityRating;
    @JsonProperty(value="securityScore")
    private final Integer securityScore;

    @Deprecated
    @ConstructorProperties(value={"dimensionsMap", "securityRating", "securityScore"})
    public SecurityScoreAggregation(Map<String, String> dimensionsMap, SecurityRating securityRating, Integer securityScore) {
        this.dimensionsMap = dimensionsMap;
        this.securityRating = securityRating;
        this.securityScore = securityScore;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Map<String, String> getDimensionsMap() {
        return this.dimensionsMap;
    }

    public SecurityRating getSecurityRating() {
        return this.securityRating;
    }

    public Integer getSecurityScore() {
        return this.securityScore;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SecurityScoreAggregation(");
        sb.append("super=").append(super.toString());
        sb.append("dimensionsMap=").append(String.valueOf(this.dimensionsMap));
        sb.append(", securityRating=").append(String.valueOf((Object)this.securityRating));
        sb.append(", securityScore=").append(String.valueOf(this.securityScore));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecurityScoreAggregation)) {
            return false;
        }
        SecurityScoreAggregation other = (SecurityScoreAggregation)((Object)o);
        return Objects.equals(this.dimensionsMap, other.dimensionsMap) && Objects.equals((Object)this.securityRating, (Object)other.securityRating) && Objects.equals(this.securityScore, other.securityScore) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.dimensionsMap == null ? 43 : this.dimensionsMap.hashCode());
        result = result * 59 + (this.securityRating == null ? 43 : this.securityRating.hashCode());
        result = result * 59 + (this.securityScore == null ? 43 : this.securityScore.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="dimensionsMap")
        private Map<String, String> dimensionsMap;
        @JsonProperty(value="securityRating")
        private SecurityRating securityRating;
        @JsonProperty(value="securityScore")
        private Integer securityScore;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder dimensionsMap(Map<String, String> dimensionsMap) {
            this.dimensionsMap = dimensionsMap;
            this.__explicitlySet__.add("dimensionsMap");
            return this;
        }

        public Builder securityRating(SecurityRating securityRating) {
            this.securityRating = securityRating;
            this.__explicitlySet__.add("securityRating");
            return this;
        }

        public Builder securityScore(Integer securityScore) {
            this.securityScore = securityScore;
            this.__explicitlySet__.add("securityScore");
            return this;
        }

        public SecurityScoreAggregation build() {
            SecurityScoreAggregation model = new SecurityScoreAggregation(this.dimensionsMap, this.securityRating, this.securityScore);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SecurityScoreAggregation model) {
            if (model.wasPropertyExplicitlySet("dimensionsMap")) {
                this.dimensionsMap(model.getDimensionsMap());
            }
            if (model.wasPropertyExplicitlySet("securityRating")) {
                this.securityRating(model.getSecurityRating());
            }
            if (model.wasPropertyExplicitlySet("securityScore")) {
                this.securityScore(model.getSecurityScore());
            }
            return this;
        }
    }
}

