/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.SecurityRecipe;
import com.oracle.bmc.cloudguard.model.TargetDetails;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="targetResourceType")
@JsonFilter(value="explicitlySetFilter")
public final class SecurityZoneTargetDetails
extends TargetDetails {
    @JsonProperty(value="securityZoneId")
    private final String securityZoneId;
    @JsonProperty(value="securityZoneDisplayName")
    private final String securityZoneDisplayName;
    @JsonProperty(value="targetSecurityZoneRecipes")
    private final List<SecurityRecipe> targetSecurityZoneRecipes;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public SecurityZoneTargetDetails(String securityZoneId, String securityZoneDisplayName, List<SecurityRecipe> targetSecurityZoneRecipes) {
        this.securityZoneId = securityZoneId;
        this.securityZoneDisplayName = securityZoneDisplayName;
        this.targetSecurityZoneRecipes = targetSecurityZoneRecipes;
    }

    public String getSecurityZoneId() {
        return this.securityZoneId;
    }

    public String getSecurityZoneDisplayName() {
        return this.securityZoneDisplayName;
    }

    public List<SecurityRecipe> getTargetSecurityZoneRecipes() {
        return this.targetSecurityZoneRecipes;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SecurityZoneTargetDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", securityZoneId=").append(String.valueOf(this.securityZoneId));
        sb.append(", securityZoneDisplayName=").append(String.valueOf(this.securityZoneDisplayName));
        sb.append(", targetSecurityZoneRecipes=").append(String.valueOf(this.targetSecurityZoneRecipes));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecurityZoneTargetDetails)) {
            return false;
        }
        SecurityZoneTargetDetails other = (SecurityZoneTargetDetails)((Object)o);
        return Objects.equals(this.securityZoneId, other.securityZoneId) && Objects.equals(this.securityZoneDisplayName, other.securityZoneDisplayName) && Objects.equals(this.targetSecurityZoneRecipes, other.targetSecurityZoneRecipes) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.securityZoneId == null ? 43 : this.securityZoneId.hashCode());
        result = result * 59 + (this.securityZoneDisplayName == null ? 43 : this.securityZoneDisplayName.hashCode());
        result = result * 59 + (this.targetSecurityZoneRecipes == null ? 43 : this.targetSecurityZoneRecipes.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="securityZoneId")
        private String securityZoneId;
        @JsonProperty(value="securityZoneDisplayName")
        private String securityZoneDisplayName;
        @JsonProperty(value="targetSecurityZoneRecipes")
        private List<SecurityRecipe> targetSecurityZoneRecipes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder securityZoneId(String securityZoneId) {
            this.securityZoneId = securityZoneId;
            this.__explicitlySet__.add("securityZoneId");
            return this;
        }

        public Builder securityZoneDisplayName(String securityZoneDisplayName) {
            this.securityZoneDisplayName = securityZoneDisplayName;
            this.__explicitlySet__.add("securityZoneDisplayName");
            return this;
        }

        public Builder targetSecurityZoneRecipes(List<SecurityRecipe> targetSecurityZoneRecipes) {
            this.targetSecurityZoneRecipes = targetSecurityZoneRecipes;
            this.__explicitlySet__.add("targetSecurityZoneRecipes");
            return this;
        }

        public SecurityZoneTargetDetails build() {
            SecurityZoneTargetDetails model = new SecurityZoneTargetDetails(this.securityZoneId, this.securityZoneDisplayName, this.targetSecurityZoneRecipes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SecurityZoneTargetDetails model) {
            if (model.wasPropertyExplicitlySet("securityZoneId")) {
                this.securityZoneId(model.getSecurityZoneId());
            }
            if (model.wasPropertyExplicitlySet("securityZoneDisplayName")) {
                this.securityZoneDisplayName(model.getSecurityZoneDisplayName());
            }
            if (model.wasPropertyExplicitlySet("targetSecurityZoneRecipes")) {
                this.targetSecurityZoneRecipes(model.getTargetSecurityZoneRecipes());
            }
            return this;
        }
    }
}

