/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteTargetDetectorRecipeRequest
extends BmcRequest<Void> {
    private String targetId;
    private String targetDetectorRecipeId;
    private String ifMatch;
    private String opcRequestId;

    public String getTargetId() {
        return this.targetId;
    }

    public String getTargetDetectorRecipeId() {
        return this.targetDetectorRecipeId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().targetId(this.targetId).targetDetectorRecipeId(this.targetDetectorRecipeId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",targetId=").append(String.valueOf(this.targetId));
        sb.append(",targetDetectorRecipeId=").append(String.valueOf(this.targetDetectorRecipeId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteTargetDetectorRecipeRequest)) {
            return false;
        }
        DeleteTargetDetectorRecipeRequest other = (DeleteTargetDetectorRecipeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.targetDetectorRecipeId, other.targetDetectorRecipeId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.targetDetectorRecipeId == null ? 43 : this.targetDetectorRecipeId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteTargetDetectorRecipeRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String targetId = null;
        private String targetDetectorRecipeId = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public Builder targetDetectorRecipeId(String targetDetectorRecipeId) {
            this.targetDetectorRecipeId = targetDetectorRecipeId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteTargetDetectorRecipeRequest o) {
            this.targetId(o.getTargetId());
            this.targetDetectorRecipeId(o.getTargetDetectorRecipeId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteTargetDetectorRecipeRequest build() {
            DeleteTargetDetectorRecipeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteTargetDetectorRecipeRequest buildWithoutInvocationCallback() {
            DeleteTargetDetectorRecipeRequest request = new DeleteTargetDetectorRecipeRequest();
            request.targetId = this.targetId;
            request.targetDetectorRecipeId = this.targetDetectorRecipeId;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

