/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.cloudguard.model.ConditionTypeEnum;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetConditionMetadataTypeRequest
extends BmcRequest<Void> {
    private ConditionTypeEnum conditionMetadataTypeId;
    private String opcRequestId;
    private String serviceType;
    private String resourceType;

    public ConditionTypeEnum getConditionMetadataTypeId() {
        return this.conditionMetadataTypeId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public Builder toBuilder() {
        return new Builder().conditionMetadataTypeId(this.conditionMetadataTypeId).opcRequestId(this.opcRequestId).serviceType(this.serviceType).resourceType(this.resourceType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",conditionMetadataTypeId=").append(String.valueOf((Object)this.conditionMetadataTypeId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",serviceType=").append(String.valueOf(this.serviceType));
        sb.append(",resourceType=").append(String.valueOf(this.resourceType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetConditionMetadataTypeRequest)) {
            return false;
        }
        GetConditionMetadataTypeRequest other = (GetConditionMetadataTypeRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.conditionMetadataTypeId, (Object)other.conditionMetadataTypeId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.serviceType, other.serviceType) && Objects.equals(this.resourceType, other.resourceType);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.conditionMetadataTypeId == null ? 43 : this.conditionMetadataTypeId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.serviceType == null ? 43 : this.serviceType.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetConditionMetadataTypeRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private ConditionTypeEnum conditionMetadataTypeId = null;
        private String opcRequestId = null;
        private String serviceType = null;
        private String resourceType = null;

        public Builder conditionMetadataTypeId(ConditionTypeEnum conditionMetadataTypeId) {
            this.conditionMetadataTypeId = conditionMetadataTypeId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetConditionMetadataTypeRequest o) {
            this.conditionMetadataTypeId(o.getConditionMetadataTypeId());
            this.opcRequestId(o.getOpcRequestId());
            this.serviceType(o.getServiceType());
            this.resourceType(o.getResourceType());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetConditionMetadataTypeRequest build() {
            GetConditionMetadataTypeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetConditionMetadataTypeRequest buildWithoutInvocationCallback() {
            GetConditionMetadataTypeRequest request = new GetConditionMetadataTypeRequest();
            request.conditionMetadataTypeId = this.conditionMetadataTypeId;
            request.opcRequestId = this.opcRequestId;
            request.serviceType = this.serviceType;
            request.resourceType = this.resourceType;
            return request;
        }
    }
}

