/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetResponderExecutionRequest
extends BmcRequest<Void> {
    private String responderExecutionId;
    private String opcRequestId;

    public String getResponderExecutionId() {
        return this.responderExecutionId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().responderExecutionId(this.responderExecutionId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",responderExecutionId=").append(String.valueOf(this.responderExecutionId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetResponderExecutionRequest)) {
            return false;
        }
        GetResponderExecutionRequest other = (GetResponderExecutionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.responderExecutionId, other.responderExecutionId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.responderExecutionId == null ? 43 : this.responderExecutionId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetResponderExecutionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String responderExecutionId = null;
        private String opcRequestId = null;

        public Builder responderExecutionId(String responderExecutionId) {
            this.responderExecutionId = responderExecutionId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetResponderExecutionRequest o) {
            this.responderExecutionId(o.getResponderExecutionId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetResponderExecutionRequest build() {
            GetResponderExecutionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetResponderExecutionRequest buildWithoutInvocationCallback() {
            GetResponderExecutionRequest request = new GetResponderExecutionRequest();
            request.responderExecutionId = this.responderExecutionId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

