/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetSightingRequest
extends BmcRequest<Void> {
    private String sightingId;
    private String opcRequestId;

    public String getSightingId() {
        return this.sightingId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().sightingId(this.sightingId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",sightingId=").append(String.valueOf(this.sightingId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetSightingRequest)) {
            return false;
        }
        GetSightingRequest other = (GetSightingRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.sightingId, other.sightingId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.sightingId == null ? 43 : this.sightingId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetSightingRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String sightingId = null;
        private String opcRequestId = null;

        public Builder sightingId(String sightingId) {
            this.sightingId = sightingId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSightingRequest o) {
            this.sightingId(o.getSightingId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSightingRequest build() {
            GetSightingRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetSightingRequest buildWithoutInvocationCallback() {
            GetSightingRequest request = new GetSightingRequest();
            request.sightingId = this.sightingId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

