/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetTargetDetectorRecipeDetectorRuleRequest
extends BmcRequest<Void> {
    private String targetId;
    private String targetDetectorRecipeId;
    private String detectorRuleId;
    private String opcRequestId;

    public String getTargetId() {
        return this.targetId;
    }

    public String getTargetDetectorRecipeId() {
        return this.targetDetectorRecipeId;
    }

    public String getDetectorRuleId() {
        return this.detectorRuleId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().targetId(this.targetId).targetDetectorRecipeId(this.targetDetectorRecipeId).detectorRuleId(this.detectorRuleId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",targetId=").append(String.valueOf(this.targetId));
        sb.append(",targetDetectorRecipeId=").append(String.valueOf(this.targetDetectorRecipeId));
        sb.append(",detectorRuleId=").append(String.valueOf(this.detectorRuleId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetTargetDetectorRecipeDetectorRuleRequest)) {
            return false;
        }
        GetTargetDetectorRecipeDetectorRuleRequest other = (GetTargetDetectorRecipeDetectorRuleRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.targetDetectorRecipeId, other.targetDetectorRecipeId) && Objects.equals(this.detectorRuleId, other.detectorRuleId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.targetDetectorRecipeId == null ? 43 : this.targetDetectorRecipeId.hashCode());
        result = result * 59 + (this.detectorRuleId == null ? 43 : this.detectorRuleId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetTargetDetectorRecipeDetectorRuleRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String targetId = null;
        private String targetDetectorRecipeId = null;
        private String detectorRuleId = null;
        private String opcRequestId = null;

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public Builder targetDetectorRecipeId(String targetDetectorRecipeId) {
            this.targetDetectorRecipeId = targetDetectorRecipeId;
            return this;
        }

        public Builder detectorRuleId(String detectorRuleId) {
            this.detectorRuleId = detectorRuleId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetTargetDetectorRecipeDetectorRuleRequest o) {
            this.targetId(o.getTargetId());
            this.targetDetectorRecipeId(o.getTargetDetectorRecipeId());
            this.detectorRuleId(o.getDetectorRuleId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetTargetDetectorRecipeDetectorRuleRequest build() {
            GetTargetDetectorRecipeDetectorRuleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetTargetDetectorRecipeDetectorRuleRequest buildWithoutInvocationCallback() {
            GetTargetDetectorRecipeDetectorRuleRequest request = new GetTargetDetectorRecipeDetectorRuleRequest();
            request.targetId = this.targetId;
            request.targetDetectorRecipeId = this.targetDetectorRecipeId;
            request.detectorRuleId = this.detectorRuleId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

