/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetTargetResponderRecipeResponderRuleRequest
extends BmcRequest<Void> {
    private String targetId;
    private String targetResponderRecipeId;
    private String responderRuleId;
    private String opcRequestId;

    public String getTargetId() {
        return this.targetId;
    }

    public String getTargetResponderRecipeId() {
        return this.targetResponderRecipeId;
    }

    public String getResponderRuleId() {
        return this.responderRuleId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().targetId(this.targetId).targetResponderRecipeId(this.targetResponderRecipeId).responderRuleId(this.responderRuleId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",targetId=").append(String.valueOf(this.targetId));
        sb.append(",targetResponderRecipeId=").append(String.valueOf(this.targetResponderRecipeId));
        sb.append(",responderRuleId=").append(String.valueOf(this.responderRuleId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetTargetResponderRecipeResponderRuleRequest)) {
            return false;
        }
        GetTargetResponderRecipeResponderRuleRequest other = (GetTargetResponderRecipeResponderRuleRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.targetResponderRecipeId, other.targetResponderRecipeId) && Objects.equals(this.responderRuleId, other.responderRuleId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.targetResponderRecipeId == null ? 43 : this.targetResponderRecipeId.hashCode());
        result = result * 59 + (this.responderRuleId == null ? 43 : this.responderRuleId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetTargetResponderRecipeResponderRuleRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String targetId = null;
        private String targetResponderRecipeId = null;
        private String responderRuleId = null;
        private String opcRequestId = null;

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public Builder targetResponderRecipeId(String targetResponderRecipeId) {
            this.targetResponderRecipeId = targetResponderRecipeId;
            return this;
        }

        public Builder responderRuleId(String responderRuleId) {
            this.responderRuleId = responderRuleId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetTargetResponderRecipeResponderRuleRequest o) {
            this.targetId(o.getTargetId());
            this.targetResponderRecipeId(o.getTargetResponderRecipeId());
            this.responderRuleId(o.getResponderRuleId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetTargetResponderRecipeResponderRuleRequest build() {
            GetTargetResponderRecipeResponderRuleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetTargetResponderRecipeResponderRuleRequest buildWithoutInvocationCallback() {
            GetTargetResponderRecipeResponderRuleRequest request = new GetTargetResponderRecipeResponderRuleRequest();
            request.targetId = this.targetId;
            request.targetResponderRecipeId = this.targetResponderRecipeId;
            request.responderRuleId = this.responderRuleId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

