/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class RequestSummarizedTrendResponderExecutionsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Date timeCompletedGreaterThanOrEqualTo;
    private Date timeCompletedLessThanOrEqualTo;
    private Boolean compartmentIdInSubtree;
    private AccessLevel accessLevel;
    private Integer limit;
    private String page;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getTimeCompletedGreaterThanOrEqualTo() {
        return this.timeCompletedGreaterThanOrEqualTo;
    }

    public Date getTimeCompletedLessThanOrEqualTo() {
        return this.timeCompletedLessThanOrEqualTo;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).timeCompletedGreaterThanOrEqualTo(this.timeCompletedGreaterThanOrEqualTo).timeCompletedLessThanOrEqualTo(this.timeCompletedLessThanOrEqualTo).compartmentIdInSubtree(this.compartmentIdInSubtree).accessLevel(this.accessLevel).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",timeCompletedGreaterThanOrEqualTo=").append(String.valueOf(this.timeCompletedGreaterThanOrEqualTo));
        sb.append(",timeCompletedLessThanOrEqualTo=").append(String.valueOf(this.timeCompletedLessThanOrEqualTo));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(",accessLevel=").append(String.valueOf((Object)this.accessLevel));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestSummarizedTrendResponderExecutionsRequest)) {
            return false;
        }
        RequestSummarizedTrendResponderExecutionsRequest other = (RequestSummarizedTrendResponderExecutionsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.timeCompletedGreaterThanOrEqualTo, other.timeCompletedGreaterThanOrEqualTo) && Objects.equals(this.timeCompletedLessThanOrEqualTo, other.timeCompletedLessThanOrEqualTo) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals((Object)this.accessLevel, (Object)other.accessLevel) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.timeCompletedGreaterThanOrEqualTo == null ? 43 : this.timeCompletedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeCompletedLessThanOrEqualTo == null ? 43 : this.timeCompletedLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.accessLevel == null ? 43 : this.accessLevel.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RequestSummarizedTrendResponderExecutionsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private Date timeCompletedGreaterThanOrEqualTo = null;
        private Date timeCompletedLessThanOrEqualTo = null;
        private Boolean compartmentIdInSubtree = null;
        private AccessLevel accessLevel = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder timeCompletedGreaterThanOrEqualTo(Date timeCompletedGreaterThanOrEqualTo) {
            this.timeCompletedGreaterThanOrEqualTo = timeCompletedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeCompletedLessThanOrEqualTo(Date timeCompletedLessThanOrEqualTo) {
            this.timeCompletedLessThanOrEqualTo = timeCompletedLessThanOrEqualTo;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RequestSummarizedTrendResponderExecutionsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.timeCompletedGreaterThanOrEqualTo(o.getTimeCompletedGreaterThanOrEqualTo());
            this.timeCompletedLessThanOrEqualTo(o.getTimeCompletedLessThanOrEqualTo());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.accessLevel(o.getAccessLevel());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RequestSummarizedTrendResponderExecutionsRequest build() {
            RequestSummarizedTrendResponderExecutionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public RequestSummarizedTrendResponderExecutionsRequest buildWithoutInvocationCallback() {
            RequestSummarizedTrendResponderExecutionsRequest request = new RequestSummarizedTrendResponderExecutionsRequest();
            request.compartmentId = this.compartmentId;
            request.timeCompletedGreaterThanOrEqualTo = this.timeCompletedGreaterThanOrEqualTo;
            request.timeCompletedLessThanOrEqualTo = this.timeCompletedLessThanOrEqualTo;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            request.accessLevel = this.accessLevel;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum AccessLevel implements BmcEnum
    {
        Restricted("RESTRICTED"),
        Accessible("ACCESSIBLE");

        private final String value;
        private static Map<String, AccessLevel> map;

        private AccessLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AccessLevel: " + key);
        }

        static {
            map = new HashMap<String, AccessLevel>();
            for (AccessLevel v : AccessLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

