/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.responses;

import com.oracle.bmc.cloudguard.model.SightingCollection;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListSightingsResponse
extends BmcResponse {
    private String opcRequestId;
    private String opcNextPage;
    private SightingCollection sightingCollection;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public SightingCollection getSightingCollection() {
        return this.sightingCollection;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "opcNextPage", "sightingCollection"})
    private ListSightingsResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String opcNextPage, SightingCollection sightingCollection) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.sightingCollection = sightingCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcNextPage=").append(String.valueOf(this.opcNextPage));
        sb.append(",sightingCollection=").append(String.valueOf((Object)this.sightingCollection));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSightingsResponse)) {
            return false;
        }
        ListSightingsResponse other = (ListSightingsResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcNextPage, other.opcNextPage) && Objects.equals((Object)this.sightingCollection, (Object)other.sightingCollection);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcNextPage == null ? 43 : this.opcNextPage.hashCode());
        result = result * 59 + (this.sightingCollection == null ? 43 : this.sightingCollection.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<ListSightingsResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String opcNextPage;
        private SightingCollection sightingCollection;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder sightingCollection(SightingCollection sightingCollection) {
            this.sightingCollection = sightingCollection;
            return this;
        }

        public Builder copy(ListSightingsResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.sightingCollection(o.getSightingCollection());
            return this;
        }

        public ListSightingsResponse build() {
            return new ListSightingsResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.opcNextPage, this.sightingCollection);
        }
    }
}

