/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.DataSourceMappingInfo;
import com.oracle.bmc.cloudguard.model.DataSourceSummaryDetails;
import com.oracle.bmc.cloudguard.model.RegionStatusDetail;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="dataSourceFeedProvider")
@JsonFilter(value="explicitlySetFilter")
public final class LoggingQueryDataSourceSummaryDetails
extends DataSourceSummaryDetails {
    @JsonProperty(value="regions")
    private final List<String> regions;
    @JsonProperty(value="dataSourceDetectorMappingInfo")
    private final List<DataSourceMappingInfo> dataSourceDetectorMappingInfo;
    @JsonProperty(value="regionStatusDetail")
    private final List<RegionStatusDetail> regionStatusDetail;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public LoggingQueryDataSourceSummaryDetails(List<String> regions, List<DataSourceMappingInfo> dataSourceDetectorMappingInfo, List<RegionStatusDetail> regionStatusDetail) {
        this.regions = regions;
        this.dataSourceDetectorMappingInfo = dataSourceDetectorMappingInfo;
        this.regionStatusDetail = regionStatusDetail;
    }

    public List<String> getRegions() {
        return this.regions;
    }

    public List<DataSourceMappingInfo> getDataSourceDetectorMappingInfo() {
        return this.dataSourceDetectorMappingInfo;
    }

    public List<RegionStatusDetail> getRegionStatusDetail() {
        return this.regionStatusDetail;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LoggingQueryDataSourceSummaryDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", regions=").append(String.valueOf(this.regions));
        sb.append(", dataSourceDetectorMappingInfo=").append(String.valueOf(this.dataSourceDetectorMappingInfo));
        sb.append(", regionStatusDetail=").append(String.valueOf(this.regionStatusDetail));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoggingQueryDataSourceSummaryDetails)) {
            return false;
        }
        LoggingQueryDataSourceSummaryDetails other = (LoggingQueryDataSourceSummaryDetails)((Object)o);
        return Objects.equals(this.regions, other.regions) && Objects.equals(this.dataSourceDetectorMappingInfo, other.dataSourceDetectorMappingInfo) && Objects.equals(this.regionStatusDetail, other.regionStatusDetail) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.regions == null ? 43 : this.regions.hashCode());
        result = result * 59 + (this.dataSourceDetectorMappingInfo == null ? 43 : this.dataSourceDetectorMappingInfo.hashCode());
        result = result * 59 + (this.regionStatusDetail == null ? 43 : this.regionStatusDetail.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="regions")
        private List<String> regions;
        @JsonProperty(value="dataSourceDetectorMappingInfo")
        private List<DataSourceMappingInfo> dataSourceDetectorMappingInfo;
        @JsonProperty(value="regionStatusDetail")
        private List<RegionStatusDetail> regionStatusDetail;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder regions(List<String> regions) {
            this.regions = regions;
            this.__explicitlySet__.add("regions");
            return this;
        }

        public Builder dataSourceDetectorMappingInfo(List<DataSourceMappingInfo> dataSourceDetectorMappingInfo) {
            this.dataSourceDetectorMappingInfo = dataSourceDetectorMappingInfo;
            this.__explicitlySet__.add("dataSourceDetectorMappingInfo");
            return this;
        }

        public Builder regionStatusDetail(List<RegionStatusDetail> regionStatusDetail) {
            this.regionStatusDetail = regionStatusDetail;
            this.__explicitlySet__.add("regionStatusDetail");
            return this;
        }

        public LoggingQueryDataSourceSummaryDetails build() {
            LoggingQueryDataSourceSummaryDetails model = new LoggingQueryDataSourceSummaryDetails(this.regions, this.dataSourceDetectorMappingInfo, this.regionStatusDetail);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LoggingQueryDataSourceSummaryDetails model) {
            if (model.wasPropertyExplicitlySet("regions")) {
                this.regions(model.getRegions());
            }
            if (model.wasPropertyExplicitlySet("dataSourceDetectorMappingInfo")) {
                this.dataSourceDetectorMappingInfo(model.getDataSourceDetectorMappingInfo());
            }
            if (model.wasPropertyExplicitlySet("regionStatusDetail")) {
                this.regionStatusDetail(model.getRegionStatusDetail());
            }
            return this;
        }
    }
}

