/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard;

import com.oracle.bmc.cloudguard.CloudGuard;
import com.oracle.bmc.cloudguard.model.LifecycleState;
import com.oracle.bmc.cloudguard.model.ProblemLifecycleState;
import com.oracle.bmc.cloudguard.requests.GetAdhocQueryRequest;
import com.oracle.bmc.cloudguard.requests.GetDataMaskRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetDataSourceRequest;
import com.oracle.bmc.cloudguard.requests.GetDetectorRecipeDetectorRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.GetDetectorRequest;
import com.oracle.bmc.cloudguard.requests.GetDetectorRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetManagedListRequest;
import com.oracle.bmc.cloudguard.requests.GetProblemRequest;
import com.oracle.bmc.cloudguard.requests.GetResponderRecipeRequest;
import com.oracle.bmc.cloudguard.requests.GetResponderRecipeResponderRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetResponderRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetSavedQueryRequest;
import com.oracle.bmc.cloudguard.requests.GetSecurityPolicyRequest;
import com.oracle.bmc.cloudguard.requests.GetSecurityRecipeRequest;
import com.oracle.bmc.cloudguard.requests.GetSecurityZoneRequest;
import com.oracle.bmc.cloudguard.requests.GetTargetDetectorRecipeDetectorRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetTargetDetectorRecipeRequest;
import com.oracle.bmc.cloudguard.requests.GetTargetRequest;
import com.oracle.bmc.cloudguard.requests.GetTargetResponderRecipeResponderRuleRequest;
import com.oracle.bmc.cloudguard.requests.GetWorkRequestRequest;
import com.oracle.bmc.cloudguard.responses.GetAdhocQueryResponse;
import com.oracle.bmc.cloudguard.responses.GetDataMaskRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetDataSourceResponse;
import com.oracle.bmc.cloudguard.responses.GetDetectorRecipeDetectorRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.GetDetectorResponse;
import com.oracle.bmc.cloudguard.responses.GetDetectorRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetManagedListResponse;
import com.oracle.bmc.cloudguard.responses.GetProblemResponse;
import com.oracle.bmc.cloudguard.responses.GetResponderRecipeResponderRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetResponderRecipeResponse;
import com.oracle.bmc.cloudguard.responses.GetResponderRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetSavedQueryResponse;
import com.oracle.bmc.cloudguard.responses.GetSecurityPolicyResponse;
import com.oracle.bmc.cloudguard.responses.GetSecurityRecipeResponse;
import com.oracle.bmc.cloudguard.responses.GetSecurityZoneResponse;
import com.oracle.bmc.cloudguard.responses.GetTargetDetectorRecipeDetectorRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetTargetDetectorRecipeResponse;
import com.oracle.bmc.cloudguard.responses.GetTargetResponderRecipeResponderRuleResponse;
import com.oracle.bmc.cloudguard.responses.GetTargetResponse;
import com.oracle.bmc.cloudguard.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class CloudGuardWaiters {
    private final ExecutorService executorService;
    private final CloudGuard client;

    public CloudGuardWaiters(ExecutorService executorService, CloudGuard client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetAdhocQueryRequest, GetAdhocQueryResponse> forAdhocQuery(GetAdhocQueryRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAdhocQuery(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAdhocQueryRequest, GetAdhocQueryResponse> forAdhocQuery(GetAdhocQueryRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAdhocQuery(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAdhocQueryRequest, GetAdhocQueryResponse> forAdhocQuery(GetAdhocQueryRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAdhocQuery(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAdhocQueryRequest, GetAdhocQueryResponse> forAdhocQuery(BmcGenericWaiter waiter, GetAdhocQueryRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAdhocQueryRequest, GetAdhocQueryResponse>(){

            @Override
            public GetAdhocQueryResponse apply(GetAdhocQueryRequest request) {
                return CloudGuardWaiters.this.client.getAdhocQuery(request);
            }
        }, (Predicate)new Predicate<GetAdhocQueryResponse>(){

            @Override
            public boolean test(GetAdhocQueryResponse response) {
                return targetStatesSet.contains((Object)response.getAdhocQuery().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDataMaskRuleRequest, GetDataMaskRuleResponse> forDataMaskRule(GetDataMaskRuleRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDataMaskRule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDataMaskRuleRequest, GetDataMaskRuleResponse> forDataMaskRule(GetDataMaskRuleRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDataMaskRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDataMaskRuleRequest, GetDataMaskRuleResponse> forDataMaskRule(GetDataMaskRuleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDataMaskRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDataMaskRuleRequest, GetDataMaskRuleResponse> forDataMaskRule(BmcGenericWaiter waiter, GetDataMaskRuleRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDataMaskRuleRequest, GetDataMaskRuleResponse>(){

            @Override
            public GetDataMaskRuleResponse apply(GetDataMaskRuleRequest request) {
                return CloudGuardWaiters.this.client.getDataMaskRule(request);
            }
        }, (Predicate)new Predicate<GetDataMaskRuleResponse>(){

            @Override
            public boolean test(GetDataMaskRuleResponse response) {
                return targetStatesSet.contains((Object)response.getDataMaskRule().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDataSourceRequest, GetDataSourceResponse> forDataSource(GetDataSourceRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDataSource(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDataSourceRequest, GetDataSourceResponse> forDataSource(GetDataSourceRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDataSource(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDataSourceRequest, GetDataSourceResponse> forDataSource(GetDataSourceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDataSource(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDataSourceRequest, GetDataSourceResponse> forDataSource(BmcGenericWaiter waiter, GetDataSourceRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDataSourceRequest, GetDataSourceResponse>(){

            @Override
            public GetDataSourceResponse apply(GetDataSourceRequest request) {
                return CloudGuardWaiters.this.client.getDataSource(request);
            }
        }, (Predicate)new Predicate<GetDataSourceResponse>(){

            @Override
            public boolean test(GetDataSourceResponse response) {
                return targetStatesSet.contains((Object)response.getDataSource().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDetectorRequest, GetDetectorResponse> forDetector(GetDetectorRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDetector(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDetectorRequest, GetDetectorResponse> forDetector(GetDetectorRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDetector(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDetectorRequest, GetDetectorResponse> forDetector(GetDetectorRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDetector(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDetectorRequest, GetDetectorResponse> forDetector(BmcGenericWaiter waiter, GetDetectorRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDetectorRequest, GetDetectorResponse>(){

            @Override
            public GetDetectorResponse apply(GetDetectorRequest request) {
                return CloudGuardWaiters.this.client.getDetector(request);
            }
        }, (Predicate)new Predicate<GetDetectorResponse>(){

            @Override
            public boolean test(GetDetectorResponse response) {
                return targetStatesSet.contains((Object)response.getDetector().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDetectorRecipeRequest, GetDetectorRecipeResponse> forDetectorRecipe(GetDetectorRecipeRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDetectorRecipe(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDetectorRecipeRequest, GetDetectorRecipeResponse> forDetectorRecipe(GetDetectorRecipeRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDetectorRecipe(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDetectorRecipeRequest, GetDetectorRecipeResponse> forDetectorRecipe(GetDetectorRecipeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDetectorRecipe(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDetectorRecipeRequest, GetDetectorRecipeResponse> forDetectorRecipe(BmcGenericWaiter waiter, GetDetectorRecipeRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDetectorRecipeRequest, GetDetectorRecipeResponse>(){

            @Override
            public GetDetectorRecipeResponse apply(GetDetectorRecipeRequest request) {
                return CloudGuardWaiters.this.client.getDetectorRecipe(request);
            }
        }, (Predicate)new Predicate<GetDetectorRecipeResponse>(){

            @Override
            public boolean test(GetDetectorRecipeResponse response) {
                return targetStatesSet.contains((Object)response.getDetectorRecipe().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDetectorRecipeDetectorRuleRequest, GetDetectorRecipeDetectorRuleResponse> forDetectorRecipeDetectorRule(GetDetectorRecipeDetectorRuleRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDetectorRecipeDetectorRule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDetectorRecipeDetectorRuleRequest, GetDetectorRecipeDetectorRuleResponse> forDetectorRecipeDetectorRule(GetDetectorRecipeDetectorRuleRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDetectorRecipeDetectorRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDetectorRecipeDetectorRuleRequest, GetDetectorRecipeDetectorRuleResponse> forDetectorRecipeDetectorRule(GetDetectorRecipeDetectorRuleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDetectorRecipeDetectorRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDetectorRecipeDetectorRuleRequest, GetDetectorRecipeDetectorRuleResponse> forDetectorRecipeDetectorRule(BmcGenericWaiter waiter, GetDetectorRecipeDetectorRuleRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDetectorRecipeDetectorRuleRequest, GetDetectorRecipeDetectorRuleResponse>(){

            @Override
            public GetDetectorRecipeDetectorRuleResponse apply(GetDetectorRecipeDetectorRuleRequest request) {
                return CloudGuardWaiters.this.client.getDetectorRecipeDetectorRule(request);
            }
        }, (Predicate)new Predicate<GetDetectorRecipeDetectorRuleResponse>(){

            @Override
            public boolean test(GetDetectorRecipeDetectorRuleResponse response) {
                return targetStatesSet.contains((Object)response.getDetectorRecipeDetectorRule().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDetectorRuleRequest, GetDetectorRuleResponse> forDetectorRule(GetDetectorRuleRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDetectorRule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDetectorRuleRequest, GetDetectorRuleResponse> forDetectorRule(GetDetectorRuleRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDetectorRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDetectorRuleRequest, GetDetectorRuleResponse> forDetectorRule(GetDetectorRuleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDetectorRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDetectorRuleRequest, GetDetectorRuleResponse> forDetectorRule(BmcGenericWaiter waiter, GetDetectorRuleRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDetectorRuleRequest, GetDetectorRuleResponse>(){

            @Override
            public GetDetectorRuleResponse apply(GetDetectorRuleRequest request) {
                return CloudGuardWaiters.this.client.getDetectorRule(request);
            }
        }, (Predicate)new Predicate<GetDetectorRuleResponse>(){

            @Override
            public boolean test(GetDetectorRuleResponse response) {
                return targetStatesSet.contains((Object)response.getDetectorRule().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetManagedListRequest, GetManagedListResponse> forManagedList(GetManagedListRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forManagedList(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetManagedListRequest, GetManagedListResponse> forManagedList(GetManagedListRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forManagedList(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetManagedListRequest, GetManagedListResponse> forManagedList(GetManagedListRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forManagedList(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetManagedListRequest, GetManagedListResponse> forManagedList(BmcGenericWaiter waiter, GetManagedListRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetManagedListRequest, GetManagedListResponse>(){

            @Override
            public GetManagedListResponse apply(GetManagedListRequest request) {
                return CloudGuardWaiters.this.client.getManagedList(request);
            }
        }, (Predicate)new Predicate<GetManagedListResponse>(){

            @Override
            public boolean test(GetManagedListResponse response) {
                return targetStatesSet.contains((Object)response.getManagedList().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetProblemRequest, GetProblemResponse> forProblem(GetProblemRequest request, ProblemLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forProblem(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetProblemRequest, GetProblemResponse> forProblem(GetProblemRequest request, ProblemLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forProblem(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetProblemRequest, GetProblemResponse> forProblem(GetProblemRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ProblemLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forProblem(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetProblemRequest, GetProblemResponse> forProblem(BmcGenericWaiter waiter, GetProblemRequest request, ProblemLifecycleState ... targetStates) {
        final HashSet<ProblemLifecycleState> targetStatesSet = new HashSet<ProblemLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetProblemRequest, GetProblemResponse>(){

            @Override
            public GetProblemResponse apply(GetProblemRequest request) {
                return CloudGuardWaiters.this.client.getProblem(request);
            }
        }, (Predicate)new Predicate<GetProblemResponse>(){

            @Override
            public boolean test(GetProblemResponse response) {
                return targetStatesSet.contains((Object)response.getProblem().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetResponderRecipeRequest, GetResponderRecipeResponse> forResponderRecipe(GetResponderRecipeRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forResponderRecipe(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetResponderRecipeRequest, GetResponderRecipeResponse> forResponderRecipe(GetResponderRecipeRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forResponderRecipe(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetResponderRecipeRequest, GetResponderRecipeResponse> forResponderRecipe(GetResponderRecipeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forResponderRecipe(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetResponderRecipeRequest, GetResponderRecipeResponse> forResponderRecipe(BmcGenericWaiter waiter, GetResponderRecipeRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetResponderRecipeRequest, GetResponderRecipeResponse>(){

            @Override
            public GetResponderRecipeResponse apply(GetResponderRecipeRequest request) {
                return CloudGuardWaiters.this.client.getResponderRecipe(request);
            }
        }, (Predicate)new Predicate<GetResponderRecipeResponse>(){

            @Override
            public boolean test(GetResponderRecipeResponse response) {
                return targetStatesSet.contains((Object)response.getResponderRecipe().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetResponderRecipeResponderRuleRequest, GetResponderRecipeResponderRuleResponse> forResponderRecipeResponderRule(GetResponderRecipeResponderRuleRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forResponderRecipeResponderRule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetResponderRecipeResponderRuleRequest, GetResponderRecipeResponderRuleResponse> forResponderRecipeResponderRule(GetResponderRecipeResponderRuleRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forResponderRecipeResponderRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetResponderRecipeResponderRuleRequest, GetResponderRecipeResponderRuleResponse> forResponderRecipeResponderRule(GetResponderRecipeResponderRuleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forResponderRecipeResponderRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetResponderRecipeResponderRuleRequest, GetResponderRecipeResponderRuleResponse> forResponderRecipeResponderRule(BmcGenericWaiter waiter, GetResponderRecipeResponderRuleRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetResponderRecipeResponderRuleRequest, GetResponderRecipeResponderRuleResponse>(){

            @Override
            public GetResponderRecipeResponderRuleResponse apply(GetResponderRecipeResponderRuleRequest request) {
                return CloudGuardWaiters.this.client.getResponderRecipeResponderRule(request);
            }
        }, (Predicate)new Predicate<GetResponderRecipeResponderRuleResponse>(){

            @Override
            public boolean test(GetResponderRecipeResponderRuleResponse response) {
                return targetStatesSet.contains((Object)response.getResponderRecipeResponderRule().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetResponderRuleRequest, GetResponderRuleResponse> forResponderRule(GetResponderRuleRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forResponderRule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetResponderRuleRequest, GetResponderRuleResponse> forResponderRule(GetResponderRuleRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forResponderRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetResponderRuleRequest, GetResponderRuleResponse> forResponderRule(GetResponderRuleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forResponderRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetResponderRuleRequest, GetResponderRuleResponse> forResponderRule(BmcGenericWaiter waiter, GetResponderRuleRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetResponderRuleRequest, GetResponderRuleResponse>(){

            @Override
            public GetResponderRuleResponse apply(GetResponderRuleRequest request) {
                return CloudGuardWaiters.this.client.getResponderRule(request);
            }
        }, (Predicate)new Predicate<GetResponderRuleResponse>(){

            @Override
            public boolean test(GetResponderRuleResponse response) {
                return targetStatesSet.contains((Object)response.getResponderRule().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSavedQueryRequest, GetSavedQueryResponse> forSavedQuery(GetSavedQueryRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSavedQuery(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSavedQueryRequest, GetSavedQueryResponse> forSavedQuery(GetSavedQueryRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSavedQuery(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSavedQueryRequest, GetSavedQueryResponse> forSavedQuery(GetSavedQueryRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSavedQuery(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSavedQueryRequest, GetSavedQueryResponse> forSavedQuery(BmcGenericWaiter waiter, GetSavedQueryRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSavedQueryRequest, GetSavedQueryResponse>(){

            @Override
            public GetSavedQueryResponse apply(GetSavedQueryRequest request) {
                return CloudGuardWaiters.this.client.getSavedQuery(request);
            }
        }, (Predicate)new Predicate<GetSavedQueryResponse>(){

            @Override
            public boolean test(GetSavedQueryResponse response) {
                return targetStatesSet.contains((Object)response.getSavedQuery().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSecurityPolicyRequest, GetSecurityPolicyResponse> forSecurityPolicy(GetSecurityPolicyRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSecurityPolicy(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSecurityPolicyRequest, GetSecurityPolicyResponse> forSecurityPolicy(GetSecurityPolicyRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSecurityPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSecurityPolicyRequest, GetSecurityPolicyResponse> forSecurityPolicy(GetSecurityPolicyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSecurityPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSecurityPolicyRequest, GetSecurityPolicyResponse> forSecurityPolicy(BmcGenericWaiter waiter, GetSecurityPolicyRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSecurityPolicyRequest, GetSecurityPolicyResponse>(){

            @Override
            public GetSecurityPolicyResponse apply(GetSecurityPolicyRequest request) {
                return CloudGuardWaiters.this.client.getSecurityPolicy(request);
            }
        }, (Predicate)new Predicate<GetSecurityPolicyResponse>(){

            @Override
            public boolean test(GetSecurityPolicyResponse response) {
                return targetStatesSet.contains((Object)response.getSecurityPolicy().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSecurityRecipeRequest, GetSecurityRecipeResponse> forSecurityRecipe(GetSecurityRecipeRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSecurityRecipe(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSecurityRecipeRequest, GetSecurityRecipeResponse> forSecurityRecipe(GetSecurityRecipeRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSecurityRecipe(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSecurityRecipeRequest, GetSecurityRecipeResponse> forSecurityRecipe(GetSecurityRecipeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSecurityRecipe(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSecurityRecipeRequest, GetSecurityRecipeResponse> forSecurityRecipe(BmcGenericWaiter waiter, GetSecurityRecipeRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSecurityRecipeRequest, GetSecurityRecipeResponse>(){

            @Override
            public GetSecurityRecipeResponse apply(GetSecurityRecipeRequest request) {
                return CloudGuardWaiters.this.client.getSecurityRecipe(request);
            }
        }, (Predicate)new Predicate<GetSecurityRecipeResponse>(){

            @Override
            public boolean test(GetSecurityRecipeResponse response) {
                return targetStatesSet.contains((Object)response.getSecurityRecipe().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSecurityZoneRequest, GetSecurityZoneResponse> forSecurityZone(GetSecurityZoneRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSecurityZone(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSecurityZoneRequest, GetSecurityZoneResponse> forSecurityZone(GetSecurityZoneRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSecurityZone(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSecurityZoneRequest, GetSecurityZoneResponse> forSecurityZone(GetSecurityZoneRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSecurityZone(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSecurityZoneRequest, GetSecurityZoneResponse> forSecurityZone(BmcGenericWaiter waiter, GetSecurityZoneRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSecurityZoneRequest, GetSecurityZoneResponse>(){

            @Override
            public GetSecurityZoneResponse apply(GetSecurityZoneRequest request) {
                return CloudGuardWaiters.this.client.getSecurityZone(request);
            }
        }, (Predicate)new Predicate<GetSecurityZoneResponse>(){

            @Override
            public boolean test(GetSecurityZoneResponse response) {
                return targetStatesSet.contains((Object)response.getSecurityZone().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetTargetRequest, GetTargetResponse> forTarget(GetTargetRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTarget(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTargetRequest, GetTargetResponse> forTarget(GetTargetRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTarget(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTargetRequest, GetTargetResponse> forTarget(GetTargetRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTarget(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTargetRequest, GetTargetResponse> forTarget(BmcGenericWaiter waiter, GetTargetRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetTargetRequest, GetTargetResponse>(){

            @Override
            public GetTargetResponse apply(GetTargetRequest request) {
                return CloudGuardWaiters.this.client.getTarget(request);
            }
        }, (Predicate)new Predicate<GetTargetResponse>(){

            @Override
            public boolean test(GetTargetResponse response) {
                return targetStatesSet.contains((Object)response.getTarget().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetTargetDetectorRecipeRequest, GetTargetDetectorRecipeResponse> forTargetDetectorRecipe(GetTargetDetectorRecipeRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTargetDetectorRecipe(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTargetDetectorRecipeRequest, GetTargetDetectorRecipeResponse> forTargetDetectorRecipe(GetTargetDetectorRecipeRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTargetDetectorRecipe(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTargetDetectorRecipeRequest, GetTargetDetectorRecipeResponse> forTargetDetectorRecipe(GetTargetDetectorRecipeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTargetDetectorRecipe(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTargetDetectorRecipeRequest, GetTargetDetectorRecipeResponse> forTargetDetectorRecipe(BmcGenericWaiter waiter, GetTargetDetectorRecipeRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetTargetDetectorRecipeRequest, GetTargetDetectorRecipeResponse>(){

            @Override
            public GetTargetDetectorRecipeResponse apply(GetTargetDetectorRecipeRequest request) {
                return CloudGuardWaiters.this.client.getTargetDetectorRecipe(request);
            }
        }, (Predicate)new Predicate<GetTargetDetectorRecipeResponse>(){

            @Override
            public boolean test(GetTargetDetectorRecipeResponse response) {
                return targetStatesSet.contains((Object)response.getTargetDetectorRecipe().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetTargetDetectorRecipeDetectorRuleRequest, GetTargetDetectorRecipeDetectorRuleResponse> forTargetDetectorRecipeDetectorRule(GetTargetDetectorRecipeDetectorRuleRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTargetDetectorRecipeDetectorRule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTargetDetectorRecipeDetectorRuleRequest, GetTargetDetectorRecipeDetectorRuleResponse> forTargetDetectorRecipeDetectorRule(GetTargetDetectorRecipeDetectorRuleRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTargetDetectorRecipeDetectorRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTargetDetectorRecipeDetectorRuleRequest, GetTargetDetectorRecipeDetectorRuleResponse> forTargetDetectorRecipeDetectorRule(GetTargetDetectorRecipeDetectorRuleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTargetDetectorRecipeDetectorRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTargetDetectorRecipeDetectorRuleRequest, GetTargetDetectorRecipeDetectorRuleResponse> forTargetDetectorRecipeDetectorRule(BmcGenericWaiter waiter, GetTargetDetectorRecipeDetectorRuleRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetTargetDetectorRecipeDetectorRuleRequest, GetTargetDetectorRecipeDetectorRuleResponse>(){

            @Override
            public GetTargetDetectorRecipeDetectorRuleResponse apply(GetTargetDetectorRecipeDetectorRuleRequest request) {
                return CloudGuardWaiters.this.client.getTargetDetectorRecipeDetectorRule(request);
            }
        }, (Predicate)new Predicate<GetTargetDetectorRecipeDetectorRuleResponse>(){

            @Override
            public boolean test(GetTargetDetectorRecipeDetectorRuleResponse response) {
                return targetStatesSet.contains((Object)response.getTargetDetectorRecipeDetectorRule().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetTargetResponderRecipeResponderRuleRequest, GetTargetResponderRecipeResponderRuleResponse> forTargetResponderRecipeResponderRule(GetTargetResponderRecipeResponderRuleRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTargetResponderRecipeResponderRule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTargetResponderRecipeResponderRuleRequest, GetTargetResponderRecipeResponderRuleResponse> forTargetResponderRecipeResponderRule(GetTargetResponderRecipeResponderRuleRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTargetResponderRecipeResponderRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTargetResponderRecipeResponderRuleRequest, GetTargetResponderRecipeResponderRuleResponse> forTargetResponderRecipeResponderRule(GetTargetResponderRecipeResponderRuleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTargetResponderRecipeResponderRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTargetResponderRecipeResponderRuleRequest, GetTargetResponderRecipeResponderRuleResponse> forTargetResponderRecipeResponderRule(BmcGenericWaiter waiter, GetTargetResponderRecipeResponderRuleRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetTargetResponderRecipeResponderRuleRequest, GetTargetResponderRecipeResponderRuleResponse>(){

            @Override
            public GetTargetResponderRecipeResponderRuleResponse apply(GetTargetResponderRecipeResponderRuleRequest request) {
                return CloudGuardWaiters.this.client.getTargetResponderRecipeResponderRule(request);
            }
        }, (Predicate)new Predicate<GetTargetResponderRecipeResponderRuleResponse>(){

            @Override
            public boolean test(GetTargetResponderRecipeResponderRuleResponse response) {
                return targetStatesSet.contains((Object)response.getTargetResponderRecipeResponderRule().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return CloudGuardWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

