/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AdhocQueryResource
extends ExplicitlySetBmcModel {
    @JsonProperty(value="region")
    private final String region;
    @JsonProperty(value="resourceIds")
    private final List<String> resourceIds;
    @JsonProperty(value="resourceType")
    private final String resourceType;

    @Deprecated
    @ConstructorProperties(value={"region", "resourceIds", "resourceType"})
    public AdhocQueryResource(String region, List<String> resourceIds, String resourceType) {
        this.region = region;
        this.resourceIds = resourceIds;
        this.resourceType = resourceType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getRegion() {
        return this.region;
    }

    public List<String> getResourceIds() {
        return this.resourceIds;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AdhocQueryResource(");
        sb.append("super=").append(super.toString());
        sb.append("region=").append(String.valueOf(this.region));
        sb.append(", resourceIds=").append(String.valueOf(this.resourceIds));
        sb.append(", resourceType=").append(String.valueOf(this.resourceType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdhocQueryResource)) {
            return false;
        }
        AdhocQueryResource other = (AdhocQueryResource)((Object)o);
        return Objects.equals(this.region, other.region) && Objects.equals(this.resourceIds, other.resourceIds) && Objects.equals(this.resourceType, other.resourceType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.region == null ? 43 : this.region.hashCode());
        result = result * 59 + (this.resourceIds == null ? 43 : this.resourceIds.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="region")
        private String region;
        @JsonProperty(value="resourceIds")
        private List<String> resourceIds;
        @JsonProperty(value="resourceType")
        private String resourceType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder region(String region) {
            this.region = region;
            this.__explicitlySet__.add("region");
            return this;
        }

        public Builder resourceIds(List<String> resourceIds) {
            this.resourceIds = resourceIds;
            this.__explicitlySet__.add("resourceIds");
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public AdhocQueryResource build() {
            AdhocQueryResource model = new AdhocQueryResource(this.region, this.resourceIds, this.resourceType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AdhocQueryResource model) {
            if (model.wasPropertyExplicitlySet("region")) {
                this.region(model.getRegion());
            }
            if (model.wasPropertyExplicitlySet("resourceIds")) {
                this.resourceIds(model.getResourceIds());
            }
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            return this;
        }
    }
}

