/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateWlpAgentDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="agentVersion")
    private final String agentVersion;
    @JsonProperty(value="certificateSignedRequest")
    private final String certificateSignedRequest;
    @JsonProperty(value="osInfo")
    private final String osInfo;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "agentVersion", "certificateSignedRequest", "osInfo", "freeformTags", "definedTags"})
    public CreateWlpAgentDetails(String compartmentId, String agentVersion, String certificateSignedRequest, String osInfo, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.compartmentId = compartmentId;
        this.agentVersion = agentVersion;
        this.certificateSignedRequest = certificateSignedRequest;
        this.osInfo = osInfo;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public String getCertificateSignedRequest() {
        return this.certificateSignedRequest;
    }

    public String getOsInfo() {
        return this.osInfo;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateWlpAgentDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", agentVersion=").append(String.valueOf(this.agentVersion));
        sb.append(", certificateSignedRequest=").append(String.valueOf(this.certificateSignedRequest));
        sb.append(", osInfo=").append(String.valueOf(this.osInfo));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateWlpAgentDetails)) {
            return false;
        }
        CreateWlpAgentDetails other = (CreateWlpAgentDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.agentVersion, other.agentVersion) && Objects.equals(this.certificateSignedRequest, other.certificateSignedRequest) && Objects.equals(this.osInfo, other.osInfo) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.agentVersion == null ? 43 : this.agentVersion.hashCode());
        result = result * 59 + (this.certificateSignedRequest == null ? 43 : this.certificateSignedRequest.hashCode());
        result = result * 59 + (this.osInfo == null ? 43 : this.osInfo.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="agentVersion")
        private String agentVersion;
        @JsonProperty(value="certificateSignedRequest")
        private String certificateSignedRequest;
        @JsonProperty(value="osInfo")
        private String osInfo;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            this.__explicitlySet__.add("agentVersion");
            return this;
        }

        public Builder certificateSignedRequest(String certificateSignedRequest) {
            this.certificateSignedRequest = certificateSignedRequest;
            this.__explicitlySet__.add("certificateSignedRequest");
            return this;
        }

        public Builder osInfo(String osInfo) {
            this.osInfo = osInfo;
            this.__explicitlySet__.add("osInfo");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CreateWlpAgentDetails build() {
            CreateWlpAgentDetails model = new CreateWlpAgentDetails(this.compartmentId, this.agentVersion, this.certificateSignedRequest, this.osInfo, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateWlpAgentDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("agentVersion")) {
                this.agentVersion(model.getAgentVersion());
            }
            if (model.wasPropertyExplicitlySet("certificateSignedRequest")) {
                this.certificateSignedRequest(model.getCertificateSignedRequest());
            }
            if (model.wasPropertyExplicitlySet("osInfo")) {
                this.osInfo(model.getOsInfo());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

