/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.CveRiskLevel;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ResourceSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="resourceName")
    private final String resourceName;
    @JsonProperty(value="resourceType")
    private final String resourceType;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="targetId")
    private final String targetId;
    @JsonProperty(value="targetName")
    private final String targetName;
    @JsonProperty(value="region")
    private final String region;
    @JsonProperty(value="riskLevel")
    private final CveRiskLevel riskLevel;
    @JsonProperty(value="problemCount")
    private final Integer problemCount;
    @JsonProperty(value="vulnerabilityCount")
    private final Integer vulnerabilityCount;
    @JsonProperty(value="openPortsCount")
    private final Integer openPortsCount;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "resourceName", "resourceType", "compartmentId", "targetId", "targetName", "region", "riskLevel", "problemCount", "vulnerabilityCount", "openPortsCount", "freeformTags", "definedTags", "systemTags"})
    public ResourceSummary(String id, String resourceName, String resourceType, String compartmentId, String targetId, String targetName, String region, CveRiskLevel riskLevel, Integer problemCount, Integer vulnerabilityCount, Integer openPortsCount, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.resourceName = resourceName;
        this.resourceType = resourceType;
        this.compartmentId = compartmentId;
        this.targetId = targetId;
        this.targetName = targetName;
        this.region = region;
        this.riskLevel = riskLevel;
        this.problemCount = problemCount;
        this.vulnerabilityCount = vulnerabilityCount;
        this.openPortsCount = openPortsCount;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getRegion() {
        return this.region;
    }

    public CveRiskLevel getRiskLevel() {
        return this.riskLevel;
    }

    public Integer getProblemCount() {
        return this.problemCount;
    }

    public Integer getVulnerabilityCount() {
        return this.vulnerabilityCount;
    }

    public Integer getOpenPortsCount() {
        return this.openPortsCount;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ResourceSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", resourceName=").append(String.valueOf(this.resourceName));
        sb.append(", resourceType=").append(String.valueOf(this.resourceType));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", targetId=").append(String.valueOf(this.targetId));
        sb.append(", targetName=").append(String.valueOf(this.targetName));
        sb.append(", region=").append(String.valueOf(this.region));
        sb.append(", riskLevel=").append(String.valueOf((Object)this.riskLevel));
        sb.append(", problemCount=").append(String.valueOf(this.problemCount));
        sb.append(", vulnerabilityCount=").append(String.valueOf(this.vulnerabilityCount));
        sb.append(", openPortsCount=").append(String.valueOf(this.openPortsCount));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceSummary)) {
            return false;
        }
        ResourceSummary other = (ResourceSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.resourceName, other.resourceName) && Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.targetName, other.targetName) && Objects.equals(this.region, other.region) && Objects.equals((Object)this.riskLevel, (Object)other.riskLevel) && Objects.equals(this.problemCount, other.problemCount) && Objects.equals(this.vulnerabilityCount, other.vulnerabilityCount) && Objects.equals(this.openPortsCount, other.openPortsCount) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.resourceName == null ? 43 : this.resourceName.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.targetName == null ? 43 : this.targetName.hashCode());
        result = result * 59 + (this.region == null ? 43 : this.region.hashCode());
        result = result * 59 + (this.riskLevel == null ? 43 : this.riskLevel.hashCode());
        result = result * 59 + (this.problemCount == null ? 43 : this.problemCount.hashCode());
        result = result * 59 + (this.vulnerabilityCount == null ? 43 : this.vulnerabilityCount.hashCode());
        result = result * 59 + (this.openPortsCount == null ? 43 : this.openPortsCount.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="resourceName")
        private String resourceName;
        @JsonProperty(value="resourceType")
        private String resourceType;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonProperty(value="targetName")
        private String targetName;
        @JsonProperty(value="region")
        private String region;
        @JsonProperty(value="riskLevel")
        private CveRiskLevel riskLevel;
        @JsonProperty(value="problemCount")
        private Integer problemCount;
        @JsonProperty(value="vulnerabilityCount")
        private Integer vulnerabilityCount;
        @JsonProperty(value="openPortsCount")
        private Integer openPortsCount;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            this.__explicitlySet__.add("resourceName");
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder targetName(String targetName) {
            this.targetName = targetName;
            this.__explicitlySet__.add("targetName");
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            this.__explicitlySet__.add("region");
            return this;
        }

        public Builder riskLevel(CveRiskLevel riskLevel) {
            this.riskLevel = riskLevel;
            this.__explicitlySet__.add("riskLevel");
            return this;
        }

        public Builder problemCount(Integer problemCount) {
            this.problemCount = problemCount;
            this.__explicitlySet__.add("problemCount");
            return this;
        }

        public Builder vulnerabilityCount(Integer vulnerabilityCount) {
            this.vulnerabilityCount = vulnerabilityCount;
            this.__explicitlySet__.add("vulnerabilityCount");
            return this;
        }

        public Builder openPortsCount(Integer openPortsCount) {
            this.openPortsCount = openPortsCount;
            this.__explicitlySet__.add("openPortsCount");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public ResourceSummary build() {
            ResourceSummary model = new ResourceSummary(this.id, this.resourceName, this.resourceType, this.compartmentId, this.targetId, this.targetName, this.region, this.riskLevel, this.problemCount, this.vulnerabilityCount, this.openPortsCount, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ResourceSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("resourceName")) {
                this.resourceName(model.getResourceName());
            }
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("targetName")) {
                this.targetName(model.getTargetName());
            }
            if (model.wasPropertyExplicitlySet("region")) {
                this.region(model.getRegion());
            }
            if (model.wasPropertyExplicitlySet("riskLevel")) {
                this.riskLevel(model.getRiskLevel());
            }
            if (model.wasPropertyExplicitlySet("problemCount")) {
                this.problemCount(model.getProblemCount());
            }
            if (model.wasPropertyExplicitlySet("vulnerabilityCount")) {
                this.vulnerabilityCount(model.getVulnerabilityCount());
            }
            if (model.wasPropertyExplicitlySet("openPortsCount")) {
                this.openPortsCount(model.getOpenPortsCount());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

