/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.DataSourceSummaryDetails;
import com.oracle.bmc.cloudguard.model.RegionStatusDetail;
import com.oracle.bmc.cloudguard.model.ScheduledQueryScopeDetail;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="dataSourceFeedProvider")
@JsonFilter(value="explicitlySetFilter")
public final class ScheduledQueryDataSourceSummaryObjDetails
extends DataSourceSummaryDetails {
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="scheduledQueryScopeDetails")
    private final List<ScheduledQueryScopeDetail> scheduledQueryScopeDetails;
    @JsonProperty(value="intervalInSeconds")
    private final Integer intervalInSeconds;
    @JsonProperty(value="regionStatusDetail")
    private final List<RegionStatusDetail> regionStatusDetail;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ScheduledQueryDataSourceSummaryObjDetails(String description, List<ScheduledQueryScopeDetail> scheduledQueryScopeDetails, Integer intervalInSeconds, List<RegionStatusDetail> regionStatusDetail) {
        this.description = description;
        this.scheduledQueryScopeDetails = scheduledQueryScopeDetails;
        this.intervalInSeconds = intervalInSeconds;
        this.regionStatusDetail = regionStatusDetail;
    }

    public String getDescription() {
        return this.description;
    }

    public List<ScheduledQueryScopeDetail> getScheduledQueryScopeDetails() {
        return this.scheduledQueryScopeDetails;
    }

    public Integer getIntervalInSeconds() {
        return this.intervalInSeconds;
    }

    public List<RegionStatusDetail> getRegionStatusDetail() {
        return this.regionStatusDetail;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ScheduledQueryDataSourceSummaryObjDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", scheduledQueryScopeDetails=").append(String.valueOf(this.scheduledQueryScopeDetails));
        sb.append(", intervalInSeconds=").append(String.valueOf(this.intervalInSeconds));
        sb.append(", regionStatusDetail=").append(String.valueOf(this.regionStatusDetail));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduledQueryDataSourceSummaryObjDetails)) {
            return false;
        }
        ScheduledQueryDataSourceSummaryObjDetails other = (ScheduledQueryDataSourceSummaryObjDetails)((Object)o);
        return Objects.equals(this.description, other.description) && Objects.equals(this.scheduledQueryScopeDetails, other.scheduledQueryScopeDetails) && Objects.equals(this.intervalInSeconds, other.intervalInSeconds) && Objects.equals(this.regionStatusDetail, other.regionStatusDetail) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.scheduledQueryScopeDetails == null ? 43 : this.scheduledQueryScopeDetails.hashCode());
        result = result * 59 + (this.intervalInSeconds == null ? 43 : this.intervalInSeconds.hashCode());
        result = result * 59 + (this.regionStatusDetail == null ? 43 : this.regionStatusDetail.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="scheduledQueryScopeDetails")
        private List<ScheduledQueryScopeDetail> scheduledQueryScopeDetails;
        @JsonProperty(value="intervalInSeconds")
        private Integer intervalInSeconds;
        @JsonProperty(value="regionStatusDetail")
        private List<RegionStatusDetail> regionStatusDetail;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder scheduledQueryScopeDetails(List<ScheduledQueryScopeDetail> scheduledQueryScopeDetails) {
            this.scheduledQueryScopeDetails = scheduledQueryScopeDetails;
            this.__explicitlySet__.add("scheduledQueryScopeDetails");
            return this;
        }

        public Builder intervalInSeconds(Integer intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
            this.__explicitlySet__.add("intervalInSeconds");
            return this;
        }

        public Builder regionStatusDetail(List<RegionStatusDetail> regionStatusDetail) {
            this.regionStatusDetail = regionStatusDetail;
            this.__explicitlySet__.add("regionStatusDetail");
            return this;
        }

        public ScheduledQueryDataSourceSummaryObjDetails build() {
            ScheduledQueryDataSourceSummaryObjDetails model = new ScheduledQueryDataSourceSummaryObjDetails(this.description, this.scheduledQueryScopeDetails, this.intervalInSeconds, this.regionStatusDetail);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ScheduledQueryDataSourceSummaryObjDetails model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("scheduledQueryScopeDetails")) {
                this.scheduledQueryScopeDetails(model.getScheduledQueryScopeDetails());
            }
            if (model.wasPropertyExplicitlySet("intervalInSeconds")) {
                this.intervalInSeconds(model.getIntervalInSeconds());
            }
            if (model.wasPropertyExplicitlySet("regionStatusDetail")) {
                this.regionStatusDetail(model.getRegionStatusDetail());
            }
            return this;
        }
    }
}

