/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetSavedQueryRequest
extends BmcRequest<Void> {
    private String savedQueryId;
    private String opcRequestId;

    public String getSavedQueryId() {
        return this.savedQueryId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().savedQueryId(this.savedQueryId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",savedQueryId=").append(String.valueOf(this.savedQueryId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetSavedQueryRequest)) {
            return false;
        }
        GetSavedQueryRequest other = (GetSavedQueryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.savedQueryId, other.savedQueryId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.savedQueryId == null ? 43 : this.savedQueryId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetSavedQueryRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String savedQueryId = null;
        private String opcRequestId = null;

        public Builder savedQueryId(String savedQueryId) {
            this.savedQueryId = savedQueryId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSavedQueryRequest o) {
            this.savedQueryId(o.getSavedQueryId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSavedQueryRequest build() {
            GetSavedQueryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetSavedQueryRequest buildWithoutInvocationCallback() {
            GetSavedQueryRequest request = new GetSavedQueryRequest();
            request.savedQueryId = this.savedQueryId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

