/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.AdhocQueryResultState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AdhocQueryResultSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="hostId")
    private final String hostId;
    @JsonProperty(value="state")
    private final AdhocQueryResultState state;
    @JsonProperty(value="region")
    private final String region;
    @JsonProperty(value="timeSubmitted")
    private final Date timeSubmitted;
    @JsonProperty(value="errorMessage")
    private final String errorMessage;
    @JsonProperty(value="resultCount")
    private final Long resultCount;
    @JsonProperty(value="result")
    private final List<Map<String, String>> result;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"hostId", "state", "region", "timeSubmitted", "errorMessage", "resultCount", "result", "freeformTags", "definedTags", "systemTags"})
    public AdhocQueryResultSummary(String hostId, AdhocQueryResultState state, String region, Date timeSubmitted, String errorMessage, Long resultCount, List<Map<String, String>> result, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.hostId = hostId;
        this.state = state;
        this.region = region;
        this.timeSubmitted = timeSubmitted;
        this.errorMessage = errorMessage;
        this.resultCount = resultCount;
        this.result = result;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getHostId() {
        return this.hostId;
    }

    public AdhocQueryResultState getState() {
        return this.state;
    }

    public String getRegion() {
        return this.region;
    }

    public Date getTimeSubmitted() {
        return this.timeSubmitted;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Long getResultCount() {
        return this.resultCount;
    }

    public List<Map<String, String>> getResult() {
        return this.result;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AdhocQueryResultSummary(");
        sb.append("super=").append(super.toString());
        sb.append("hostId=").append(String.valueOf(this.hostId));
        sb.append(", state=").append(String.valueOf((Object)this.state));
        sb.append(", region=").append(String.valueOf(this.region));
        sb.append(", timeSubmitted=").append(String.valueOf(this.timeSubmitted));
        sb.append(", errorMessage=").append(String.valueOf(this.errorMessage));
        sb.append(", resultCount=").append(String.valueOf(this.resultCount));
        sb.append(", result=").append(String.valueOf(this.result));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdhocQueryResultSummary)) {
            return false;
        }
        AdhocQueryResultSummary other = (AdhocQueryResultSummary)((Object)o);
        return Objects.equals(this.hostId, other.hostId) && Objects.equals((Object)this.state, (Object)other.state) && Objects.equals(this.region, other.region) && Objects.equals(this.timeSubmitted, other.timeSubmitted) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals(this.resultCount, other.resultCount) && Objects.equals(this.result, other.result) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.hostId == null ? 43 : this.hostId.hashCode());
        result = result * 59 + (this.state == null ? 43 : this.state.hashCode());
        result = result * 59 + (this.region == null ? 43 : this.region.hashCode());
        result = result * 59 + (this.timeSubmitted == null ? 43 : this.timeSubmitted.hashCode());
        result = result * 59 + (this.errorMessage == null ? 43 : this.errorMessage.hashCode());
        result = result * 59 + (this.resultCount == null ? 43 : this.resultCount.hashCode());
        result = result * 59 + (this.result == null ? 43 : this.result.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="hostId")
        private String hostId;
        @JsonProperty(value="state")
        private AdhocQueryResultState state;
        @JsonProperty(value="region")
        private String region;
        @JsonProperty(value="timeSubmitted")
        private Date timeSubmitted;
        @JsonProperty(value="errorMessage")
        private String errorMessage;
        @JsonProperty(value="resultCount")
        private Long resultCount;
        @JsonProperty(value="result")
        private List<Map<String, String>> result;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder hostId(String hostId) {
            this.hostId = hostId;
            this.__explicitlySet__.add("hostId");
            return this;
        }

        public Builder state(AdhocQueryResultState state) {
            this.state = state;
            this.__explicitlySet__.add("state");
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            this.__explicitlySet__.add("region");
            return this;
        }

        public Builder timeSubmitted(Date timeSubmitted) {
            this.timeSubmitted = timeSubmitted;
            this.__explicitlySet__.add("timeSubmitted");
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            this.__explicitlySet__.add("errorMessage");
            return this;
        }

        public Builder resultCount(Long resultCount) {
            this.resultCount = resultCount;
            this.__explicitlySet__.add("resultCount");
            return this;
        }

        public Builder result(List<Map<String, String>> result) {
            this.result = result;
            this.__explicitlySet__.add("result");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public AdhocQueryResultSummary build() {
            AdhocQueryResultSummary model = new AdhocQueryResultSummary(this.hostId, this.state, this.region, this.timeSubmitted, this.errorMessage, this.resultCount, this.result, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AdhocQueryResultSummary model) {
            if (model.wasPropertyExplicitlySet("hostId")) {
                this.hostId(model.getHostId());
            }
            if (model.wasPropertyExplicitlySet("state")) {
                this.state(model.getState());
            }
            if (model.wasPropertyExplicitlySet("region")) {
                this.region(model.getRegion());
            }
            if (model.wasPropertyExplicitlySet("timeSubmitted")) {
                this.timeSubmitted(model.getTimeSubmitted());
            }
            if (model.wasPropertyExplicitlySet("errorMessage")) {
                this.errorMessage(model.getErrorMessage());
            }
            if (model.wasPropertyExplicitlySet("resultCount")) {
                this.resultCount(model.getResultCount());
            }
            if (model.wasPropertyExplicitlySet("result")) {
                this.result(model.getResult());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

