/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.DataSourceDetails;
import com.oracle.bmc.cloudguard.model.ScheduledQueryScopeDetail;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="dataSourceFeedProvider")
@JsonFilter(value="explicitlySetFilter")
public final class ScheduledQueryDataSourceObjDetails
extends DataSourceDetails {
    @JsonProperty(value="query")
    private final String query;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="intervalInSeconds")
    private final Integer intervalInSeconds;
    @JsonProperty(value="scheduledQueryScopeDetails")
    private final List<ScheduledQueryScopeDetail> scheduledQueryScopeDetails;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ScheduledQueryDataSourceObjDetails(String query, String description, Integer intervalInSeconds, List<ScheduledQueryScopeDetail> scheduledQueryScopeDetails) {
        this.query = query;
        this.description = description;
        this.intervalInSeconds = intervalInSeconds;
        this.scheduledQueryScopeDetails = scheduledQueryScopeDetails;
    }

    public String getQuery() {
        return this.query;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getIntervalInSeconds() {
        return this.intervalInSeconds;
    }

    public List<ScheduledQueryScopeDetail> getScheduledQueryScopeDetails() {
        return this.scheduledQueryScopeDetails;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ScheduledQueryDataSourceObjDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", query=").append(String.valueOf(this.query));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", intervalInSeconds=").append(String.valueOf(this.intervalInSeconds));
        sb.append(", scheduledQueryScopeDetails=").append(String.valueOf(this.scheduledQueryScopeDetails));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduledQueryDataSourceObjDetails)) {
            return false;
        }
        ScheduledQueryDataSourceObjDetails other = (ScheduledQueryDataSourceObjDetails)((Object)o);
        return Objects.equals(this.query, other.query) && Objects.equals(this.description, other.description) && Objects.equals(this.intervalInSeconds, other.intervalInSeconds) && Objects.equals(this.scheduledQueryScopeDetails, other.scheduledQueryScopeDetails) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.query == null ? 43 : this.query.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.intervalInSeconds == null ? 43 : this.intervalInSeconds.hashCode());
        result = result * 59 + (this.scheduledQueryScopeDetails == null ? 43 : this.scheduledQueryScopeDetails.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="query")
        private String query;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="intervalInSeconds")
        private Integer intervalInSeconds;
        @JsonProperty(value="scheduledQueryScopeDetails")
        private List<ScheduledQueryScopeDetail> scheduledQueryScopeDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder query(String query) {
            this.query = query;
            this.__explicitlySet__.add("query");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder intervalInSeconds(Integer intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
            this.__explicitlySet__.add("intervalInSeconds");
            return this;
        }

        public Builder scheduledQueryScopeDetails(List<ScheduledQueryScopeDetail> scheduledQueryScopeDetails) {
            this.scheduledQueryScopeDetails = scheduledQueryScopeDetails;
            this.__explicitlySet__.add("scheduledQueryScopeDetails");
            return this;
        }

        public ScheduledQueryDataSourceObjDetails build() {
            ScheduledQueryDataSourceObjDetails model = new ScheduledQueryDataSourceObjDetails(this.query, this.description, this.intervalInSeconds, this.scheduledQueryScopeDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ScheduledQueryDataSourceObjDetails model) {
            if (model.wasPropertyExplicitlySet("query")) {
                this.query(model.getQuery());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("intervalInSeconds")) {
                this.intervalInSeconds(model.getIntervalInSeconds());
            }
            if (model.wasPropertyExplicitlySet("scheduledQueryScopeDetails")) {
                this.scheduledQueryScopeDetails(model.getScheduledQueryScopeDetails());
            }
            return this;
        }
    }
}

