/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.DetectorEnum;
import com.oracle.bmc.cloudguard.model.DetectorRecipeEnum;
import com.oracle.bmc.cloudguard.model.LifecycleState;
import com.oracle.bmc.cloudguard.model.OwnerType;
import com.oracle.bmc.cloudguard.model.ResourceLock;
import com.oracle.bmc.cloudguard.model.TargetDetectorRecipeDetectorRule;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TargetDetectorRecipe
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="detectorRecipeId")
    private final String detectorRecipeId;
    @JsonProperty(value="owner")
    private final OwnerType owner;
    @JsonProperty(value="detector")
    private final DetectorEnum detector;
    @JsonProperty(value="detectorRules")
    private final List<TargetDetectorRecipeDetectorRule> detectorRules;
    @JsonProperty(value="effectiveDetectorRules")
    private final List<TargetDetectorRecipeDetectorRule> effectiveDetectorRules;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="locks")
    private final List<ResourceLock> locks;
    @JsonProperty(value="detectorRecipeType")
    private final DetectorRecipeEnum detectorRecipeType;
    @JsonProperty(value="sourceDataRetention")
    private final Integer sourceDataRetention;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "description", "compartmentId", "detectorRecipeId", "owner", "detector", "detectorRules", "effectiveDetectorRules", "timeCreated", "timeUpdated", "lifecycleState", "locks", "detectorRecipeType", "sourceDataRetention"})
    public TargetDetectorRecipe(String id, String displayName, String description, String compartmentId, String detectorRecipeId, OwnerType owner, DetectorEnum detector, List<TargetDetectorRecipeDetectorRule> detectorRules, List<TargetDetectorRecipeDetectorRule> effectiveDetectorRules, Date timeCreated, Date timeUpdated, LifecycleState lifecycleState, List<ResourceLock> locks, DetectorRecipeEnum detectorRecipeType, Integer sourceDataRetention) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.compartmentId = compartmentId;
        this.detectorRecipeId = detectorRecipeId;
        this.owner = owner;
        this.detector = detector;
        this.detectorRules = detectorRules;
        this.effectiveDetectorRules = effectiveDetectorRules;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleState = lifecycleState;
        this.locks = locks;
        this.detectorRecipeType = detectorRecipeType;
        this.sourceDataRetention = sourceDataRetention;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDetectorRecipeId() {
        return this.detectorRecipeId;
    }

    public OwnerType getOwner() {
        return this.owner;
    }

    public DetectorEnum getDetector() {
        return this.detector;
    }

    public List<TargetDetectorRecipeDetectorRule> getDetectorRules() {
        return this.detectorRules;
    }

    public List<TargetDetectorRecipeDetectorRule> getEffectiveDetectorRules() {
        return this.effectiveDetectorRules;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public List<ResourceLock> getLocks() {
        return this.locks;
    }

    public DetectorRecipeEnum getDetectorRecipeType() {
        return this.detectorRecipeType;
    }

    public Integer getSourceDataRetention() {
        return this.sourceDataRetention;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TargetDetectorRecipe(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", detectorRecipeId=").append(String.valueOf(this.detectorRecipeId));
        sb.append(", owner=").append(String.valueOf((Object)this.owner));
        sb.append(", detector=").append(String.valueOf((Object)this.detector));
        sb.append(", detectorRules=").append(String.valueOf(this.detectorRules));
        sb.append(", effectiveDetectorRules=").append(String.valueOf(this.effectiveDetectorRules));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", locks=").append(String.valueOf(this.locks));
        sb.append(", detectorRecipeType=").append(String.valueOf((Object)this.detectorRecipeType));
        sb.append(", sourceDataRetention=").append(String.valueOf(this.sourceDataRetention));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TargetDetectorRecipe)) {
            return false;
        }
        TargetDetectorRecipe other = (TargetDetectorRecipe)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.detectorRecipeId, other.detectorRecipeId) && Objects.equals((Object)this.owner, (Object)other.owner) && Objects.equals((Object)this.detector, (Object)other.detector) && Objects.equals(this.detectorRules, other.detectorRules) && Objects.equals(this.effectiveDetectorRules, other.effectiveDetectorRules) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.locks, other.locks) && Objects.equals((Object)this.detectorRecipeType, (Object)other.detectorRecipeType) && Objects.equals(this.sourceDataRetention, other.sourceDataRetention) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.detectorRecipeId == null ? 43 : this.detectorRecipeId.hashCode());
        result = result * 59 + (this.owner == null ? 43 : this.owner.hashCode());
        result = result * 59 + (this.detector == null ? 43 : this.detector.hashCode());
        result = result * 59 + (this.detectorRules == null ? 43 : this.detectorRules.hashCode());
        result = result * 59 + (this.effectiveDetectorRules == null ? 43 : this.effectiveDetectorRules.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.locks == null ? 43 : this.locks.hashCode());
        result = result * 59 + (this.detectorRecipeType == null ? 43 : this.detectorRecipeType.hashCode());
        result = result * 59 + (this.sourceDataRetention == null ? 43 : this.sourceDataRetention.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="detectorRecipeId")
        private String detectorRecipeId;
        @JsonProperty(value="owner")
        private OwnerType owner;
        @JsonProperty(value="detector")
        private DetectorEnum detector;
        @JsonProperty(value="detectorRules")
        private List<TargetDetectorRecipeDetectorRule> detectorRules;
        @JsonProperty(value="effectiveDetectorRules")
        private List<TargetDetectorRecipeDetectorRule> effectiveDetectorRules;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="locks")
        private List<ResourceLock> locks;
        @JsonProperty(value="detectorRecipeType")
        private DetectorRecipeEnum detectorRecipeType;
        @JsonProperty(value="sourceDataRetention")
        private Integer sourceDataRetention;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder detectorRecipeId(String detectorRecipeId) {
            this.detectorRecipeId = detectorRecipeId;
            this.__explicitlySet__.add("detectorRecipeId");
            return this;
        }

        public Builder owner(OwnerType owner) {
            this.owner = owner;
            this.__explicitlySet__.add("owner");
            return this;
        }

        public Builder detector(DetectorEnum detector) {
            this.detector = detector;
            this.__explicitlySet__.add("detector");
            return this;
        }

        public Builder detectorRules(List<TargetDetectorRecipeDetectorRule> detectorRules) {
            this.detectorRules = detectorRules;
            this.__explicitlySet__.add("detectorRules");
            return this;
        }

        public Builder effectiveDetectorRules(List<TargetDetectorRecipeDetectorRule> effectiveDetectorRules) {
            this.effectiveDetectorRules = effectiveDetectorRules;
            this.__explicitlySet__.add("effectiveDetectorRules");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder locks(List<ResourceLock> locks) {
            this.locks = locks;
            this.__explicitlySet__.add("locks");
            return this;
        }

        public Builder detectorRecipeType(DetectorRecipeEnum detectorRecipeType) {
            this.detectorRecipeType = detectorRecipeType;
            this.__explicitlySet__.add("detectorRecipeType");
            return this;
        }

        public Builder sourceDataRetention(Integer sourceDataRetention) {
            this.sourceDataRetention = sourceDataRetention;
            this.__explicitlySet__.add("sourceDataRetention");
            return this;
        }

        public TargetDetectorRecipe build() {
            TargetDetectorRecipe model = new TargetDetectorRecipe(this.id, this.displayName, this.description, this.compartmentId, this.detectorRecipeId, this.owner, this.detector, this.detectorRules, this.effectiveDetectorRules, this.timeCreated, this.timeUpdated, this.lifecycleState, this.locks, this.detectorRecipeType, this.sourceDataRetention);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TargetDetectorRecipe model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("detectorRecipeId")) {
                this.detectorRecipeId(model.getDetectorRecipeId());
            }
            if (model.wasPropertyExplicitlySet("owner")) {
                this.owner(model.getOwner());
            }
            if (model.wasPropertyExplicitlySet("detector")) {
                this.detector(model.getDetector());
            }
            if (model.wasPropertyExplicitlySet("detectorRules")) {
                this.detectorRules(model.getDetectorRules());
            }
            if (model.wasPropertyExplicitlySet("effectiveDetectorRules")) {
                this.effectiveDetectorRules(model.getEffectiveDetectorRules());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("locks")) {
                this.locks(model.getLocks());
            }
            if (model.wasPropertyExplicitlySet("detectorRecipeType")) {
                this.detectorRecipeType(model.getDetectorRecipeType());
            }
            if (model.wasPropertyExplicitlySet("sourceDataRetention")) {
                this.sourceDataRetention(model.getSourceDataRetention());
            }
            return this;
        }
    }
}

