/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetResourceProfileRequest
extends BmcRequest<Void> {
    private String resourceProfileId;
    private String opcRequestId;

    public String getResourceProfileId() {
        return this.resourceProfileId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().resourceProfileId(this.resourceProfileId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",resourceProfileId=").append(String.valueOf(this.resourceProfileId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetResourceProfileRequest)) {
            return false;
        }
        GetResourceProfileRequest other = (GetResourceProfileRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.resourceProfileId, other.resourceProfileId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.resourceProfileId == null ? 43 : this.resourceProfileId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetResourceProfileRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String resourceProfileId = null;
        private String opcRequestId = null;

        public Builder resourceProfileId(String resourceProfileId) {
            this.resourceProfileId = resourceProfileId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetResourceProfileRequest o) {
            this.resourceProfileId(o.getResourceProfileId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetResourceProfileRequest build() {
            GetResourceProfileRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetResourceProfileRequest buildWithoutInvocationCallback() {
            GetResourceProfileRequest request = new GetResourceProfileRequest();
            request.resourceProfileId = this.resourceProfileId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

