/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetResourceVulnerabilityRequest
extends BmcRequest<Void> {
    private String resourceId;
    private String vulnerabilityKey;
    private String opcRequestId;

    public String getResourceId() {
        return this.resourceId;
    }

    public String getVulnerabilityKey() {
        return this.vulnerabilityKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().resourceId(this.resourceId).vulnerabilityKey(this.vulnerabilityKey).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",resourceId=").append(String.valueOf(this.resourceId));
        sb.append(",vulnerabilityKey=").append(String.valueOf(this.vulnerabilityKey));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetResourceVulnerabilityRequest)) {
            return false;
        }
        GetResourceVulnerabilityRequest other = (GetResourceVulnerabilityRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.vulnerabilityKey, other.vulnerabilityKey) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.vulnerabilityKey == null ? 43 : this.vulnerabilityKey.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetResourceVulnerabilityRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String resourceId = null;
        private String vulnerabilityKey = null;
        private String opcRequestId = null;

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder vulnerabilityKey(String vulnerabilityKey) {
            this.vulnerabilityKey = vulnerabilityKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetResourceVulnerabilityRequest o) {
            this.resourceId(o.getResourceId());
            this.vulnerabilityKey(o.getVulnerabilityKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetResourceVulnerabilityRequest build() {
            GetResourceVulnerabilityRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetResourceVulnerabilityRequest buildWithoutInvocationCallback() {
            GetResourceVulnerabilityRequest request = new GetResourceVulnerabilityRequest();
            request.resourceId = this.resourceId;
            request.vulnerabilityKey = this.vulnerabilityKey;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

