/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.cloudguard.model.AdhocQueryStatus;
import com.oracle.bmc.cloudguard.model.SortOrders;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListAdhocQueriesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private AdhocQueryStatus adhocQueryStatus;
    private Date timeStartedFilterQueryParam;
    private Date timeEndedFilterQueryParam;
    private Integer limit;
    private String page;
    private Boolean compartmentIdInSubtree;
    private AccessLevel accessLevel;
    private SortOrders sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public AdhocQueryStatus getAdhocQueryStatus() {
        return this.adhocQueryStatus;
    }

    public Date getTimeStartedFilterQueryParam() {
        return this.timeStartedFilterQueryParam;
    }

    public Date getTimeEndedFilterQueryParam() {
        return this.timeEndedFilterQueryParam;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).adhocQueryStatus(this.adhocQueryStatus).timeStartedFilterQueryParam(this.timeStartedFilterQueryParam).timeEndedFilterQueryParam(this.timeEndedFilterQueryParam).limit(this.limit).page(this.page).compartmentIdInSubtree(this.compartmentIdInSubtree).accessLevel(this.accessLevel).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",adhocQueryStatus=").append(String.valueOf((Object)this.adhocQueryStatus));
        sb.append(",timeStartedFilterQueryParam=").append(String.valueOf(this.timeStartedFilterQueryParam));
        sb.append(",timeEndedFilterQueryParam=").append(String.valueOf(this.timeEndedFilterQueryParam));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(",accessLevel=").append(String.valueOf((Object)this.accessLevel));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListAdhocQueriesRequest)) {
            return false;
        }
        ListAdhocQueriesRequest other = (ListAdhocQueriesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.adhocQueryStatus, (Object)other.adhocQueryStatus) && Objects.equals(this.timeStartedFilterQueryParam, other.timeStartedFilterQueryParam) && Objects.equals(this.timeEndedFilterQueryParam, other.timeEndedFilterQueryParam) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals((Object)this.accessLevel, (Object)other.accessLevel) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.adhocQueryStatus == null ? 43 : this.adhocQueryStatus.hashCode());
        result = result * 59 + (this.timeStartedFilterQueryParam == null ? 43 : this.timeStartedFilterQueryParam.hashCode());
        result = result * 59 + (this.timeEndedFilterQueryParam == null ? 43 : this.timeEndedFilterQueryParam.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.accessLevel == null ? 43 : this.accessLevel.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAdhocQueriesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private AdhocQueryStatus adhocQueryStatus = null;
        private Date timeStartedFilterQueryParam = null;
        private Date timeEndedFilterQueryParam = null;
        private Integer limit = null;
        private String page = null;
        private Boolean compartmentIdInSubtree = null;
        private AccessLevel accessLevel = null;
        private SortOrders sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder adhocQueryStatus(AdhocQueryStatus adhocQueryStatus) {
            this.adhocQueryStatus = adhocQueryStatus;
            return this;
        }

        public Builder timeStartedFilterQueryParam(Date timeStartedFilterQueryParam) {
            this.timeStartedFilterQueryParam = timeStartedFilterQueryParam;
            return this;
        }

        public Builder timeEndedFilterQueryParam(Date timeEndedFilterQueryParam) {
            this.timeEndedFilterQueryParam = timeEndedFilterQueryParam;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAdhocQueriesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.adhocQueryStatus(o.getAdhocQueryStatus());
            this.timeStartedFilterQueryParam(o.getTimeStartedFilterQueryParam());
            this.timeEndedFilterQueryParam(o.getTimeEndedFilterQueryParam());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.accessLevel(o.getAccessLevel());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAdhocQueriesRequest build() {
            ListAdhocQueriesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListAdhocQueriesRequest buildWithoutInvocationCallback() {
            ListAdhocQueriesRequest request = new ListAdhocQueriesRequest();
            request.compartmentId = this.compartmentId;
            request.adhocQueryStatus = this.adhocQueryStatus;
            request.timeStartedFilterQueryParam = this.timeStartedFilterQueryParam;
            request.timeEndedFilterQueryParam = this.timeEndedFilterQueryParam;
            request.limit = this.limit;
            request.page = this.page;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            request.accessLevel = this.accessLevel;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AccessLevel implements BmcEnum
    {
        Restricted("RESTRICTED"),
        Accessible("ACCESSIBLE");

        private final String value;
        private static Map<String, AccessLevel> map;

        private AccessLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AccessLevel: " + key);
        }

        static {
            map = new HashMap<String, AccessLevel>();
            for (AccessLevel v : AccessLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

