/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.cloudguard.model.ResponderDimension;
import com.oracle.bmc.cloudguard.model.ResponderExecutionStatus;
import com.oracle.bmc.cloudguard.model.ResponderType;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RequestSummarizedResponderExecutionsRequest
extends BmcRequest<Void> {
    private List<ResponderDimension> responderExecutionsDimensions;
    private String compartmentId;
    private List<ResponderType> responderTypeFilter;
    private List<ResponderExecutionStatus> responderExecutionStatusFilter;
    private Boolean compartmentIdInSubtree;
    private AccessLevel accessLevel;
    private Integer limit;
    private String page;
    private String opcRequestId;

    public List<ResponderDimension> getResponderExecutionsDimensions() {
        return this.responderExecutionsDimensions;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<ResponderType> getResponderTypeFilter() {
        return this.responderTypeFilter;
    }

    public List<ResponderExecutionStatus> getResponderExecutionStatusFilter() {
        return this.responderExecutionStatusFilter;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().responderExecutionsDimensions(this.responderExecutionsDimensions).compartmentId(this.compartmentId).responderTypeFilter(this.responderTypeFilter).responderExecutionStatusFilter(this.responderExecutionStatusFilter).compartmentIdInSubtree(this.compartmentIdInSubtree).accessLevel(this.accessLevel).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",responderExecutionsDimensions=").append(String.valueOf(this.responderExecutionsDimensions));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",responderTypeFilter=").append(String.valueOf(this.responderTypeFilter));
        sb.append(",responderExecutionStatusFilter=").append(String.valueOf(this.responderExecutionStatusFilter));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(",accessLevel=").append(String.valueOf((Object)this.accessLevel));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestSummarizedResponderExecutionsRequest)) {
            return false;
        }
        RequestSummarizedResponderExecutionsRequest other = (RequestSummarizedResponderExecutionsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.responderExecutionsDimensions, other.responderExecutionsDimensions) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.responderTypeFilter, other.responderTypeFilter) && Objects.equals(this.responderExecutionStatusFilter, other.responderExecutionStatusFilter) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals((Object)this.accessLevel, (Object)other.accessLevel) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.responderExecutionsDimensions == null ? 43 : this.responderExecutionsDimensions.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.responderTypeFilter == null ? 43 : this.responderTypeFilter.hashCode());
        result = result * 59 + (this.responderExecutionStatusFilter == null ? 43 : this.responderExecutionStatusFilter.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.accessLevel == null ? 43 : this.accessLevel.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RequestSummarizedResponderExecutionsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private List<ResponderDimension> responderExecutionsDimensions = null;
        private String compartmentId = null;
        private List<ResponderType> responderTypeFilter = null;
        private List<ResponderExecutionStatus> responderExecutionStatusFilter = null;
        private Boolean compartmentIdInSubtree = null;
        private AccessLevel accessLevel = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder responderExecutionsDimensions(List<ResponderDimension> responderExecutionsDimensions) {
            this.responderExecutionsDimensions = responderExecutionsDimensions;
            return this;
        }

        public Builder responderExecutionsDimensions(ResponderDimension singularValue) {
            return this.responderExecutionsDimensions(Arrays.asList(singularValue));
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder responderTypeFilter(List<ResponderType> responderTypeFilter) {
            this.responderTypeFilter = responderTypeFilter;
            return this;
        }

        public Builder responderTypeFilter(ResponderType singularValue) {
            return this.responderTypeFilter(Arrays.asList(singularValue));
        }

        public Builder responderExecutionStatusFilter(List<ResponderExecutionStatus> responderExecutionStatusFilter) {
            this.responderExecutionStatusFilter = responderExecutionStatusFilter;
            return this;
        }

        public Builder responderExecutionStatusFilter(ResponderExecutionStatus singularValue) {
            return this.responderExecutionStatusFilter(Arrays.asList(singularValue));
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RequestSummarizedResponderExecutionsRequest o) {
            this.responderExecutionsDimensions(o.getResponderExecutionsDimensions());
            this.compartmentId(o.getCompartmentId());
            this.responderTypeFilter(o.getResponderTypeFilter());
            this.responderExecutionStatusFilter(o.getResponderExecutionStatusFilter());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.accessLevel(o.getAccessLevel());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RequestSummarizedResponderExecutionsRequest build() {
            RequestSummarizedResponderExecutionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public RequestSummarizedResponderExecutionsRequest buildWithoutInvocationCallback() {
            RequestSummarizedResponderExecutionsRequest request = new RequestSummarizedResponderExecutionsRequest();
            request.responderExecutionsDimensions = this.responderExecutionsDimensions;
            request.compartmentId = this.compartmentId;
            request.responderTypeFilter = this.responderTypeFilter;
            request.responderExecutionStatusFilter = this.responderExecutionStatusFilter;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            request.accessLevel = this.accessLevel;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum AccessLevel implements BmcEnum
    {
        Restricted("RESTRICTED"),
        Accessible("ACCESSIBLE");

        private final String value;
        private static Map<String, AccessLevel> map;

        private AccessLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AccessLevel: " + key);
        }

        static {
            map = new HashMap<String, AccessLevel>();
            for (AccessLevel v : AccessLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

