/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.cloudguard.model.TriggerResponderDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class TriggerResponderRequest
extends BmcRequest<TriggerResponderDetails> {
    private String problemId;
    private TriggerResponderDetails triggerResponderDetails;
    private String opcRetryToken;
    private String opcRequestId;
    private String ifMatch;

    public String getProblemId() {
        return this.problemId;
    }

    public TriggerResponderDetails getTriggerResponderDetails() {
        return this.triggerResponderDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public TriggerResponderDetails getBody$() {
        return this.triggerResponderDetails;
    }

    public Builder toBuilder() {
        return new Builder().problemId(this.problemId).triggerResponderDetails(this.triggerResponderDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",problemId=").append(String.valueOf(this.problemId));
        sb.append(",triggerResponderDetails=").append(String.valueOf((Object)this.triggerResponderDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TriggerResponderRequest)) {
            return false;
        }
        TriggerResponderRequest other = (TriggerResponderRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.problemId, other.problemId) && Objects.equals((Object)this.triggerResponderDetails, (Object)other.triggerResponderDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.problemId == null ? 43 : this.problemId.hashCode());
        result = result * 59 + (this.triggerResponderDetails == null ? 43 : this.triggerResponderDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<TriggerResponderRequest, TriggerResponderDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String problemId = null;
        private TriggerResponderDetails triggerResponderDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder problemId(String problemId) {
            this.problemId = problemId;
            return this;
        }

        public Builder triggerResponderDetails(TriggerResponderDetails triggerResponderDetails) {
            this.triggerResponderDetails = triggerResponderDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(TriggerResponderRequest o) {
            this.problemId(o.getProblemId());
            this.triggerResponderDetails(o.getTriggerResponderDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public TriggerResponderRequest build() {
            TriggerResponderRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(TriggerResponderDetails body) {
            this.triggerResponderDetails(body);
            return this;
        }

        public TriggerResponderRequest buildWithoutInvocationCallback() {
            TriggerResponderRequest request = new TriggerResponderRequest();
            request.problemId = this.problemId;
            request.triggerResponderDetails = this.triggerResponderDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

