/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.responses;

import com.oracle.bmc.cloudguard.model.Resource;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetResourceResponse
extends BmcResponse {
    private String etag;
    private String opcRequestId;
    private Resource resource;

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Resource getResource() {
        return this.resource;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "etag", "opcRequestId", "resource"})
    private GetResourceResponse(int __httpStatusCode__, Map<String, List<String>> headers, String etag, String opcRequestId, Resource resource) {
        super(__httpStatusCode__, headers);
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.resource = resource;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",resource=").append(String.valueOf((Object)this.resource));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetResourceResponse)) {
            return false;
        }
        GetResourceResponse other = (GetResourceResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.resource, (Object)other.resource);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.resource == null ? 43 : this.resource.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetResourceResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String etag;
        private String opcRequestId;
        private Resource resource;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder copy(GetResourceResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.resource(o.getResource());
            return this;
        }

        public GetResourceResponse build() {
            return new GetResourceResponse(this.__httpStatusCode__, this.headers, this.etag, this.opcRequestId, this.resource);
        }
    }
}

