/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PackageDetail
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="packageType")
    private final String packageType;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="cause")
    private final String cause;
    @JsonProperty(value="location")
    private final String location;
    @JsonProperty(value="remediation")
    private final String remediation;

    @Deprecated
    @ConstructorProperties(value={"name", "packageType", "version", "cause", "location", "remediation"})
    public PackageDetail(String name, String packageType, String version, String cause, String location, String remediation) {
        this.name = name;
        this.packageType = packageType;
        this.version = version;
        this.cause = cause;
        this.location = location;
        this.remediation = remediation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getPackageType() {
        return this.packageType;
    }

    public String getVersion() {
        return this.version;
    }

    public String getCause() {
        return this.cause;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRemediation() {
        return this.remediation;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PackageDetail(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", packageType=").append(String.valueOf(this.packageType));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", cause=").append(String.valueOf(this.cause));
        sb.append(", location=").append(String.valueOf(this.location));
        sb.append(", remediation=").append(String.valueOf(this.remediation));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageDetail)) {
            return false;
        }
        PackageDetail other = (PackageDetail)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.packageType, other.packageType) && Objects.equals(this.version, other.version) && Objects.equals(this.cause, other.cause) && Objects.equals(this.location, other.location) && Objects.equals(this.remediation, other.remediation) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.packageType == null ? 43 : this.packageType.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.cause == null ? 43 : this.cause.hashCode());
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.remediation == null ? 43 : this.remediation.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="packageType")
        private String packageType;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="cause")
        private String cause;
        @JsonProperty(value="location")
        private String location;
        @JsonProperty(value="remediation")
        private String remediation;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder packageType(String packageType) {
            this.packageType = packageType;
            this.__explicitlySet__.add("packageType");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder cause(String cause) {
            this.cause = cause;
            this.__explicitlySet__.add("cause");
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            this.__explicitlySet__.add("location");
            return this;
        }

        public Builder remediation(String remediation) {
            this.remediation = remediation;
            this.__explicitlySet__.add("remediation");
            return this;
        }

        public PackageDetail build() {
            PackageDetail model = new PackageDetail(this.name, this.packageType, this.version, this.cause, this.location, this.remediation);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PackageDetail model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("packageType")) {
                this.packageType(model.getPackageType());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("cause")) {
                this.cause(model.getCause());
            }
            if (model.wasPropertyExplicitlySet("location")) {
                this.location(model.getLocation());
            }
            if (model.wasPropertyExplicitlySet("remediation")) {
                this.remediation(model.getRemediation());
            }
            return this;
        }
    }
}

