/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.TacticSummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ResourceProfileSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="sightingsCount")
    private final Integer sightingsCount;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="riskScore")
    private final Double riskScore;
    @JsonProperty(value="tactics")
    private final List<TacticSummary> tactics;
    @JsonProperty(value="timeFirstDetected")
    private final Date timeFirstDetected;
    @JsonProperty(value="timeLastDetected")
    private final Date timeLastDetected;
    @JsonProperty(value="timeFirstOccurred")
    private final Date timeFirstOccurred;
    @JsonProperty(value="timeLastOccurred")
    private final Date timeLastOccurred;
    @JsonProperty(value="problemsCount")
    private final Integer problemsCount;

    @Deprecated
    @ConstructorProperties(value={"sightingsCount", "id", "resourceId", "displayName", "type", "riskScore", "tactics", "timeFirstDetected", "timeLastDetected", "timeFirstOccurred", "timeLastOccurred", "problemsCount"})
    public ResourceProfileSummary(Integer sightingsCount, String id, String resourceId, String displayName, String type, Double riskScore, List<TacticSummary> tactics, Date timeFirstDetected, Date timeLastDetected, Date timeFirstOccurred, Date timeLastOccurred, Integer problemsCount) {
        this.sightingsCount = sightingsCount;
        this.id = id;
        this.resourceId = resourceId;
        this.displayName = displayName;
        this.type = type;
        this.riskScore = riskScore;
        this.tactics = tactics;
        this.timeFirstDetected = timeFirstDetected;
        this.timeLastDetected = timeLastDetected;
        this.timeFirstOccurred = timeFirstOccurred;
        this.timeLastOccurred = timeLastOccurred;
        this.problemsCount = problemsCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getSightingsCount() {
        return this.sightingsCount;
    }

    public String getId() {
        return this.id;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getType() {
        return this.type;
    }

    public Double getRiskScore() {
        return this.riskScore;
    }

    public List<TacticSummary> getTactics() {
        return this.tactics;
    }

    public Date getTimeFirstDetected() {
        return this.timeFirstDetected;
    }

    public Date getTimeLastDetected() {
        return this.timeLastDetected;
    }

    public Date getTimeFirstOccurred() {
        return this.timeFirstOccurred;
    }

    public Date getTimeLastOccurred() {
        return this.timeLastOccurred;
    }

    public Integer getProblemsCount() {
        return this.problemsCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ResourceProfileSummary(");
        sb.append("super=").append(super.toString());
        sb.append("sightingsCount=").append(String.valueOf(this.sightingsCount));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", resourceId=").append(String.valueOf(this.resourceId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", type=").append(String.valueOf(this.type));
        sb.append(", riskScore=").append(String.valueOf(this.riskScore));
        sb.append(", tactics=").append(String.valueOf(this.tactics));
        sb.append(", timeFirstDetected=").append(String.valueOf(this.timeFirstDetected));
        sb.append(", timeLastDetected=").append(String.valueOf(this.timeLastDetected));
        sb.append(", timeFirstOccurred=").append(String.valueOf(this.timeFirstOccurred));
        sb.append(", timeLastOccurred=").append(String.valueOf(this.timeLastOccurred));
        sb.append(", problemsCount=").append(String.valueOf(this.problemsCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceProfileSummary)) {
            return false;
        }
        ResourceProfileSummary other = (ResourceProfileSummary)((Object)o);
        return Objects.equals(this.sightingsCount, other.sightingsCount) && Objects.equals(this.id, other.id) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.type, other.type) && Objects.equals(this.riskScore, other.riskScore) && Objects.equals(this.tactics, other.tactics) && Objects.equals(this.timeFirstDetected, other.timeFirstDetected) && Objects.equals(this.timeLastDetected, other.timeLastDetected) && Objects.equals(this.timeFirstOccurred, other.timeFirstOccurred) && Objects.equals(this.timeLastOccurred, other.timeLastOccurred) && Objects.equals(this.problemsCount, other.problemsCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.sightingsCount == null ? 43 : this.sightingsCount.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.riskScore == null ? 43 : this.riskScore.hashCode());
        result = result * 59 + (this.tactics == null ? 43 : this.tactics.hashCode());
        result = result * 59 + (this.timeFirstDetected == null ? 43 : this.timeFirstDetected.hashCode());
        result = result * 59 + (this.timeLastDetected == null ? 43 : this.timeLastDetected.hashCode());
        result = result * 59 + (this.timeFirstOccurred == null ? 43 : this.timeFirstOccurred.hashCode());
        result = result * 59 + (this.timeLastOccurred == null ? 43 : this.timeLastOccurred.hashCode());
        result = result * 59 + (this.problemsCount == null ? 43 : this.problemsCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="sightingsCount")
        private Integer sightingsCount;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="riskScore")
        private Double riskScore;
        @JsonProperty(value="tactics")
        private List<TacticSummary> tactics;
        @JsonProperty(value="timeFirstDetected")
        private Date timeFirstDetected;
        @JsonProperty(value="timeLastDetected")
        private Date timeLastDetected;
        @JsonProperty(value="timeFirstOccurred")
        private Date timeFirstOccurred;
        @JsonProperty(value="timeLastOccurred")
        private Date timeLastOccurred;
        @JsonProperty(value="problemsCount")
        private Integer problemsCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder sightingsCount(Integer sightingsCount) {
            this.sightingsCount = sightingsCount;
            this.__explicitlySet__.add("sightingsCount");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder riskScore(Double riskScore) {
            this.riskScore = riskScore;
            this.__explicitlySet__.add("riskScore");
            return this;
        }

        public Builder tactics(List<TacticSummary> tactics) {
            this.tactics = tactics;
            this.__explicitlySet__.add("tactics");
            return this;
        }

        public Builder timeFirstDetected(Date timeFirstDetected) {
            this.timeFirstDetected = timeFirstDetected;
            this.__explicitlySet__.add("timeFirstDetected");
            return this;
        }

        public Builder timeLastDetected(Date timeLastDetected) {
            this.timeLastDetected = timeLastDetected;
            this.__explicitlySet__.add("timeLastDetected");
            return this;
        }

        public Builder timeFirstOccurred(Date timeFirstOccurred) {
            this.timeFirstOccurred = timeFirstOccurred;
            this.__explicitlySet__.add("timeFirstOccurred");
            return this;
        }

        public Builder timeLastOccurred(Date timeLastOccurred) {
            this.timeLastOccurred = timeLastOccurred;
            this.__explicitlySet__.add("timeLastOccurred");
            return this;
        }

        public Builder problemsCount(Integer problemsCount) {
            this.problemsCount = problemsCount;
            this.__explicitlySet__.add("problemsCount");
            return this;
        }

        public ResourceProfileSummary build() {
            ResourceProfileSummary model = new ResourceProfileSummary(this.sightingsCount, this.id, this.resourceId, this.displayName, this.type, this.riskScore, this.tactics, this.timeFirstDetected, this.timeLastDetected, this.timeFirstOccurred, this.timeLastOccurred, this.problemsCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ResourceProfileSummary model) {
            if (model.wasPropertyExplicitlySet("sightingsCount")) {
                this.sightingsCount(model.getSightingsCount());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("riskScore")) {
                this.riskScore(model.getRiskScore());
            }
            if (model.wasPropertyExplicitlySet("tactics")) {
                this.tactics(model.getTactics());
            }
            if (model.wasPropertyExplicitlySet("timeFirstDetected")) {
                this.timeFirstDetected(model.getTimeFirstDetected());
            }
            if (model.wasPropertyExplicitlySet("timeLastDetected")) {
                this.timeLastDetected(model.getTimeLastDetected());
            }
            if (model.wasPropertyExplicitlySet("timeFirstOccurred")) {
                this.timeFirstOccurred(model.getTimeFirstOccurred());
            }
            if (model.wasPropertyExplicitlySet("timeLastOccurred")) {
                this.timeLastOccurred(model.getTimeLastOccurred());
            }
            if (model.wasPropertyExplicitlySet("problemsCount")) {
                this.problemsCount(model.getProblemsCount());
            }
            return this;
        }
    }
}

