/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.DetectorEnum;
import com.oracle.bmc.cloudguard.model.DetectorRecipeEnum;
import com.oracle.bmc.cloudguard.model.LifecycleState;
import com.oracle.bmc.cloudguard.model.OwnerType;
import com.oracle.bmc.cloudguard.model.ResourceLock;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TargetDetectorRecipeSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="owner")
    private final OwnerType owner;
    @JsonProperty(value="detectorRecipeId")
    private final String detectorRecipeId;
    @JsonProperty(value="detector")
    private final DetectorEnum detector;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="locks")
    private final List<ResourceLock> locks;
    @JsonProperty(value="detectorRecipeType")
    private final DetectorRecipeEnum detectorRecipeType;
    @JsonProperty(value="sourceDataRetention")
    private final Integer sourceDataRetention;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "displayName", "description", "owner", "detectorRecipeId", "detector", "lifecycleState", "timeCreated", "timeUpdated", "lifecycleDetails", "locks", "detectorRecipeType", "sourceDataRetention"})
    public TargetDetectorRecipeSummary(String id, String compartmentId, String displayName, String description, OwnerType owner, String detectorRecipeId, DetectorEnum detector, LifecycleState lifecycleState, Date timeCreated, Date timeUpdated, String lifecycleDetails, List<ResourceLock> locks, DetectorRecipeEnum detectorRecipeType, Integer sourceDataRetention) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.description = description;
        this.owner = owner;
        this.detectorRecipeId = detectorRecipeId;
        this.detector = detector;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleDetails = lifecycleDetails;
        this.locks = locks;
        this.detectorRecipeType = detectorRecipeType;
        this.sourceDataRetention = sourceDataRetention;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public OwnerType getOwner() {
        return this.owner;
    }

    public String getDetectorRecipeId() {
        return this.detectorRecipeId;
    }

    public DetectorEnum getDetector() {
        return this.detector;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public List<ResourceLock> getLocks() {
        return this.locks;
    }

    public DetectorRecipeEnum getDetectorRecipeType() {
        return this.detectorRecipeType;
    }

    public Integer getSourceDataRetention() {
        return this.sourceDataRetention;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TargetDetectorRecipeSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", owner=").append(String.valueOf((Object)this.owner));
        sb.append(", detectorRecipeId=").append(String.valueOf(this.detectorRecipeId));
        sb.append(", detector=").append(String.valueOf((Object)this.detector));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", locks=").append(String.valueOf(this.locks));
        sb.append(", detectorRecipeType=").append(String.valueOf((Object)this.detectorRecipeType));
        sb.append(", sourceDataRetention=").append(String.valueOf(this.sourceDataRetention));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TargetDetectorRecipeSummary)) {
            return false;
        }
        TargetDetectorRecipeSummary other = (TargetDetectorRecipeSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.owner, (Object)other.owner) && Objects.equals(this.detectorRecipeId, other.detectorRecipeId) && Objects.equals((Object)this.detector, (Object)other.detector) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.locks, other.locks) && Objects.equals((Object)this.detectorRecipeType, (Object)other.detectorRecipeType) && Objects.equals(this.sourceDataRetention, other.sourceDataRetention) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.owner == null ? 43 : this.owner.hashCode());
        result = result * 59 + (this.detectorRecipeId == null ? 43 : this.detectorRecipeId.hashCode());
        result = result * 59 + (this.detector == null ? 43 : this.detector.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.locks == null ? 43 : this.locks.hashCode());
        result = result * 59 + (this.detectorRecipeType == null ? 43 : this.detectorRecipeType.hashCode());
        result = result * 59 + (this.sourceDataRetention == null ? 43 : this.sourceDataRetention.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="owner")
        private OwnerType owner;
        @JsonProperty(value="detectorRecipeId")
        private String detectorRecipeId;
        @JsonProperty(value="detector")
        private DetectorEnum detector;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="locks")
        private List<ResourceLock> locks;
        @JsonProperty(value="detectorRecipeType")
        private DetectorRecipeEnum detectorRecipeType;
        @JsonProperty(value="sourceDataRetention")
        private Integer sourceDataRetention;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder owner(OwnerType owner) {
            this.owner = owner;
            this.__explicitlySet__.add("owner");
            return this;
        }

        public Builder detectorRecipeId(String detectorRecipeId) {
            this.detectorRecipeId = detectorRecipeId;
            this.__explicitlySet__.add("detectorRecipeId");
            return this;
        }

        public Builder detector(DetectorEnum detector) {
            this.detector = detector;
            this.__explicitlySet__.add("detector");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder locks(List<ResourceLock> locks) {
            this.locks = locks;
            this.__explicitlySet__.add("locks");
            return this;
        }

        public Builder detectorRecipeType(DetectorRecipeEnum detectorRecipeType) {
            this.detectorRecipeType = detectorRecipeType;
            this.__explicitlySet__.add("detectorRecipeType");
            return this;
        }

        public Builder sourceDataRetention(Integer sourceDataRetention) {
            this.sourceDataRetention = sourceDataRetention;
            this.__explicitlySet__.add("sourceDataRetention");
            return this;
        }

        public TargetDetectorRecipeSummary build() {
            TargetDetectorRecipeSummary model = new TargetDetectorRecipeSummary(this.id, this.compartmentId, this.displayName, this.description, this.owner, this.detectorRecipeId, this.detector, this.lifecycleState, this.timeCreated, this.timeUpdated, this.lifecycleDetails, this.locks, this.detectorRecipeType, this.sourceDataRetention);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TargetDetectorRecipeSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("owner")) {
                this.owner(model.getOwner());
            }
            if (model.wasPropertyExplicitlySet("detectorRecipeId")) {
                this.detectorRecipeId(model.getDetectorRecipeId());
            }
            if (model.wasPropertyExplicitlySet("detector")) {
                this.detector(model.getDetector());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("locks")) {
                this.locks(model.getLocks());
            }
            if (model.wasPropertyExplicitlySet("detectorRecipeType")) {
                this.detectorRecipeType(model.getDetectorRecipeType());
            }
            if (model.wasPropertyExplicitlySet("sourceDataRetention")) {
                this.sourceDataRetention(model.getSourceDataRetention());
            }
            return this;
        }
    }
}

