/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetAdhocQueryRequest
extends BmcRequest<Void> {
    private String adhocQueryId;
    private String opcRequestId;

    public String getAdhocQueryId() {
        return this.adhocQueryId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().adhocQueryId(this.adhocQueryId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",adhocQueryId=").append(String.valueOf(this.adhocQueryId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAdhocQueryRequest)) {
            return false;
        }
        GetAdhocQueryRequest other = (GetAdhocQueryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.adhocQueryId, other.adhocQueryId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.adhocQueryId == null ? 43 : this.adhocQueryId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAdhocQueryRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String adhocQueryId = null;
        private String opcRequestId = null;

        public Builder adhocQueryId(String adhocQueryId) {
            this.adhocQueryId = adhocQueryId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAdhocQueryRequest o) {
            this.adhocQueryId(o.getAdhocQueryId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAdhocQueryRequest build() {
            GetAdhocQueryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAdhocQueryRequest buildWithoutInvocationCallback() {
            GetAdhocQueryRequest request = new GetAdhocQueryRequest();
            request.adhocQueryId = this.adhocQueryId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

