/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.cloudguard.model.DetectorEnum;
import com.oracle.bmc.cloudguard.model.SortOrders;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListResourcesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String targetId;
    private String region;
    private Integer cvssScore;
    private Integer cvssScoreGreaterThan;
    private Integer cvssScoreLessThan;
    private String cveId;
    private String riskLevel;
    private String riskLevelGreaterThan;
    private String riskLevelLessThan;
    private List<String> detectorRuleIdList;
    private DetectorEnum detectorType;
    private Integer limit;
    private String page;
    private Boolean compartmentIdInSubtree;
    private AccessLevel accessLevel;
    private SortOrders sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getRegion() {
        return this.region;
    }

    public Integer getCvssScore() {
        return this.cvssScore;
    }

    public Integer getCvssScoreGreaterThan() {
        return this.cvssScoreGreaterThan;
    }

    public Integer getCvssScoreLessThan() {
        return this.cvssScoreLessThan;
    }

    public String getCveId() {
        return this.cveId;
    }

    public String getRiskLevel() {
        return this.riskLevel;
    }

    public String getRiskLevelGreaterThan() {
        return this.riskLevelGreaterThan;
    }

    public String getRiskLevelLessThan() {
        return this.riskLevelLessThan;
    }

    public List<String> getDetectorRuleIdList() {
        return this.detectorRuleIdList;
    }

    public DetectorEnum getDetectorType() {
        return this.detectorType;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).targetId(this.targetId).region(this.region).cvssScore(this.cvssScore).cvssScoreGreaterThan(this.cvssScoreGreaterThan).cvssScoreLessThan(this.cvssScoreLessThan).cveId(this.cveId).riskLevel(this.riskLevel).riskLevelGreaterThan(this.riskLevelGreaterThan).riskLevelLessThan(this.riskLevelLessThan).detectorRuleIdList(this.detectorRuleIdList).detectorType(this.detectorType).limit(this.limit).page(this.page).compartmentIdInSubtree(this.compartmentIdInSubtree).accessLevel(this.accessLevel).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",targetId=").append(String.valueOf(this.targetId));
        sb.append(",region=").append(String.valueOf(this.region));
        sb.append(",cvssScore=").append(String.valueOf(this.cvssScore));
        sb.append(",cvssScoreGreaterThan=").append(String.valueOf(this.cvssScoreGreaterThan));
        sb.append(",cvssScoreLessThan=").append(String.valueOf(this.cvssScoreLessThan));
        sb.append(",cveId=").append(String.valueOf(this.cveId));
        sb.append(",riskLevel=").append(String.valueOf(this.riskLevel));
        sb.append(",riskLevelGreaterThan=").append(String.valueOf(this.riskLevelGreaterThan));
        sb.append(",riskLevelLessThan=").append(String.valueOf(this.riskLevelLessThan));
        sb.append(",detectorRuleIdList=").append(String.valueOf(this.detectorRuleIdList));
        sb.append(",detectorType=").append(String.valueOf((Object)this.detectorType));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(",accessLevel=").append(String.valueOf((Object)this.accessLevel));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListResourcesRequest)) {
            return false;
        }
        ListResourcesRequest other = (ListResourcesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.region, other.region) && Objects.equals(this.cvssScore, other.cvssScore) && Objects.equals(this.cvssScoreGreaterThan, other.cvssScoreGreaterThan) && Objects.equals(this.cvssScoreLessThan, other.cvssScoreLessThan) && Objects.equals(this.cveId, other.cveId) && Objects.equals(this.riskLevel, other.riskLevel) && Objects.equals(this.riskLevelGreaterThan, other.riskLevelGreaterThan) && Objects.equals(this.riskLevelLessThan, other.riskLevelLessThan) && Objects.equals(this.detectorRuleIdList, other.detectorRuleIdList) && Objects.equals((Object)this.detectorType, (Object)other.detectorType) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals((Object)this.accessLevel, (Object)other.accessLevel) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.region == null ? 43 : this.region.hashCode());
        result = result * 59 + (this.cvssScore == null ? 43 : this.cvssScore.hashCode());
        result = result * 59 + (this.cvssScoreGreaterThan == null ? 43 : this.cvssScoreGreaterThan.hashCode());
        result = result * 59 + (this.cvssScoreLessThan == null ? 43 : this.cvssScoreLessThan.hashCode());
        result = result * 59 + (this.cveId == null ? 43 : this.cveId.hashCode());
        result = result * 59 + (this.riskLevel == null ? 43 : this.riskLevel.hashCode());
        result = result * 59 + (this.riskLevelGreaterThan == null ? 43 : this.riskLevelGreaterThan.hashCode());
        result = result * 59 + (this.riskLevelLessThan == null ? 43 : this.riskLevelLessThan.hashCode());
        result = result * 59 + (this.detectorRuleIdList == null ? 43 : this.detectorRuleIdList.hashCode());
        result = result * 59 + (this.detectorType == null ? 43 : this.detectorType.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.accessLevel == null ? 43 : this.accessLevel.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListResourcesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String targetId = null;
        private String region = null;
        private Integer cvssScore = null;
        private Integer cvssScoreGreaterThan = null;
        private Integer cvssScoreLessThan = null;
        private String cveId = null;
        private String riskLevel = null;
        private String riskLevelGreaterThan = null;
        private String riskLevelLessThan = null;
        private List<String> detectorRuleIdList = null;
        private DetectorEnum detectorType = null;
        private Integer limit = null;
        private String page = null;
        private Boolean compartmentIdInSubtree = null;
        private AccessLevel accessLevel = null;
        private SortOrders sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder cvssScore(Integer cvssScore) {
            this.cvssScore = cvssScore;
            return this;
        }

        public Builder cvssScoreGreaterThan(Integer cvssScoreGreaterThan) {
            this.cvssScoreGreaterThan = cvssScoreGreaterThan;
            return this;
        }

        public Builder cvssScoreLessThan(Integer cvssScoreLessThan) {
            this.cvssScoreLessThan = cvssScoreLessThan;
            return this;
        }

        public Builder cveId(String cveId) {
            this.cveId = cveId;
            return this;
        }

        public Builder riskLevel(String riskLevel) {
            this.riskLevel = riskLevel;
            return this;
        }

        public Builder riskLevelGreaterThan(String riskLevelGreaterThan) {
            this.riskLevelGreaterThan = riskLevelGreaterThan;
            return this;
        }

        public Builder riskLevelLessThan(String riskLevelLessThan) {
            this.riskLevelLessThan = riskLevelLessThan;
            return this;
        }

        public Builder detectorRuleIdList(List<String> detectorRuleIdList) {
            this.detectorRuleIdList = detectorRuleIdList;
            return this;
        }

        public Builder detectorRuleIdList(String singularValue) {
            return this.detectorRuleIdList(Arrays.asList(singularValue));
        }

        public Builder detectorType(DetectorEnum detectorType) {
            this.detectorType = detectorType;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListResourcesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.targetId(o.getTargetId());
            this.region(o.getRegion());
            this.cvssScore(o.getCvssScore());
            this.cvssScoreGreaterThan(o.getCvssScoreGreaterThan());
            this.cvssScoreLessThan(o.getCvssScoreLessThan());
            this.cveId(o.getCveId());
            this.riskLevel(o.getRiskLevel());
            this.riskLevelGreaterThan(o.getRiskLevelGreaterThan());
            this.riskLevelLessThan(o.getRiskLevelLessThan());
            this.detectorRuleIdList(o.getDetectorRuleIdList());
            this.detectorType(o.getDetectorType());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.accessLevel(o.getAccessLevel());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListResourcesRequest build() {
            ListResourcesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListResourcesRequest buildWithoutInvocationCallback() {
            ListResourcesRequest request = new ListResourcesRequest();
            request.compartmentId = this.compartmentId;
            request.targetId = this.targetId;
            request.region = this.region;
            request.cvssScore = this.cvssScore;
            request.cvssScoreGreaterThan = this.cvssScoreGreaterThan;
            request.cvssScoreLessThan = this.cvssScoreLessThan;
            request.cveId = this.cveId;
            request.riskLevel = this.riskLevel;
            request.riskLevelGreaterThan = this.riskLevelGreaterThan;
            request.riskLevelLessThan = this.riskLevelLessThan;
            request.detectorRuleIdList = this.detectorRuleIdList;
            request.detectorType = this.detectorType;
            request.limit = this.limit;
            request.page = this.page;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            request.accessLevel = this.accessLevel;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AccessLevel implements BmcEnum
    {
        Restricted("RESTRICTED"),
        Accessible("ACCESSIBLE");

        private final String value;
        private static Map<String, AccessLevel> map;

        private AccessLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AccessLevel: " + key);
        }

        static {
            map = new HashMap<String, AccessLevel>();
            for (AccessLevel v : AccessLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

