/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.cloudguard.model.UpdateSavedQueryDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateSavedQueryRequest
extends BmcRequest<UpdateSavedQueryDetails> {
    private String savedQueryId;
    private UpdateSavedQueryDetails updateSavedQueryDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getSavedQueryId() {
        return this.savedQueryId;
    }

    public UpdateSavedQueryDetails getUpdateSavedQueryDetails() {
        return this.updateSavedQueryDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public UpdateSavedQueryDetails getBody$() {
        return this.updateSavedQueryDetails;
    }

    public Builder toBuilder() {
        return new Builder().savedQueryId(this.savedQueryId).updateSavedQueryDetails(this.updateSavedQueryDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",savedQueryId=").append(String.valueOf(this.savedQueryId));
        sb.append(",updateSavedQueryDetails=").append(String.valueOf((Object)this.updateSavedQueryDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateSavedQueryRequest)) {
            return false;
        }
        UpdateSavedQueryRequest other = (UpdateSavedQueryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.savedQueryId, other.savedQueryId) && Objects.equals((Object)this.updateSavedQueryDetails, (Object)other.updateSavedQueryDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.savedQueryId == null ? 43 : this.savedQueryId.hashCode());
        result = result * 59 + (this.updateSavedQueryDetails == null ? 43 : this.updateSavedQueryDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateSavedQueryRequest, UpdateSavedQueryDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String savedQueryId = null;
        private UpdateSavedQueryDetails updateSavedQueryDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder savedQueryId(String savedQueryId) {
            this.savedQueryId = savedQueryId;
            return this;
        }

        public Builder updateSavedQueryDetails(UpdateSavedQueryDetails updateSavedQueryDetails) {
            this.updateSavedQueryDetails = updateSavedQueryDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateSavedQueryRequest o) {
            this.savedQueryId(o.getSavedQueryId());
            this.updateSavedQueryDetails(o.getUpdateSavedQueryDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateSavedQueryRequest build() {
            UpdateSavedQueryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateSavedQueryDetails body) {
            this.updateSavedQueryDetails(body);
            return this;
        }

        public UpdateSavedQueryRequest buildWithoutInvocationCallback() {
            UpdateSavedQueryRequest request = new UpdateSavedQueryRequest();
            request.savedQueryId = this.savedQueryId;
            request.updateSavedQueryDetails = this.updateSavedQueryDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

