/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudmigrations.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.io.InputStream;
import java.util.Objects;

public class ImportMigrationPlanRequest
extends BmcRequest<InputStream> {
    private String migrationPlanId;
    private InputStream importMigrationPlanDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getMigrationPlanId() {
        return this.migrationPlanId;
    }

    public InputStream getImportMigrationPlanDetails() {
        return this.importMigrationPlanDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public InputStream getBody$() {
        return this.importMigrationPlanDetails;
    }

    public Builder toBuilder() {
        return new Builder().migrationPlanId(this.migrationPlanId).importMigrationPlanDetails(this.importMigrationPlanDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",migrationPlanId=").append(String.valueOf(this.migrationPlanId));
        sb.append(",importMigrationPlanDetails=").append(String.valueOf(this.importMigrationPlanDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImportMigrationPlanRequest)) {
            return false;
        }
        ImportMigrationPlanRequest other = (ImportMigrationPlanRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.migrationPlanId, other.migrationPlanId) && Objects.equals(this.importMigrationPlanDetails, other.importMigrationPlanDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.migrationPlanId == null ? 43 : this.migrationPlanId.hashCode());
        result = result * 59 + (this.importMigrationPlanDetails == null ? 43 : this.importMigrationPlanDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ImportMigrationPlanRequest, InputStream> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String migrationPlanId = null;
        private InputStream importMigrationPlanDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder migrationPlanId(String migrationPlanId) {
            this.migrationPlanId = migrationPlanId;
            return this;
        }

        public Builder importMigrationPlanDetails(InputStream importMigrationPlanDetails) {
            this.importMigrationPlanDetails = importMigrationPlanDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ImportMigrationPlanRequest o) {
            this.migrationPlanId(o.getMigrationPlanId());
            this.importMigrationPlanDetails(o.getImportMigrationPlanDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ImportMigrationPlanRequest build() {
            ImportMigrationPlanRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.importMigrationPlanDetails(body);
            return this;
        }

        public ImportMigrationPlanRequest buildWithoutInvocationCallback() {
            ImportMigrationPlanRequest request = new ImportMigrationPlanRequest();
            request.migrationPlanId = this.migrationPlanId;
            request.importMigrationPlanDetails = this.importMigrationPlanDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

